% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jaatha.R
\name{jaatha}
\alias{jaatha}
\title{Simulation based maximum likelihood estimation}
\usage{
jaatha(model, data, repetitions = 3, sim = model$get_par_number() * 25,
  max_steps = 100, init_method = c("zoom-in", "initial-search", "random",
  "middle"), cores = 1, verbose = TRUE, sim_cache_limit = 10000,
  block_width = 0.1)
}
\arguments{
\item{model}{The model used for the estimation. 
See \code{\link{create_jaatha_model}}.}

\item{data}{The data used for the estimation.
See \code{\link{create_jaatha_data}}.}

\item{repetitions}{The number of independend optimizations that will be
conducted. You should use a value greater than one here, to minimize
the chance that the algorithms is stuck in a local maximum.}

\item{sim}{The number of simulations conducted for each step.}

\item{max_steps}{The maximal number of steps, in case Jaatha fails to 
converge.}

\item{init_method}{Determines how the starting position of each repetition
is chosen. See below for a description of the different options.}

\item{cores}{The number of CPU cores that will be used for the simulations.
The relies on the \pkg{parallel} package, and consequenlty only one
core is supported on Windows.}

\item{verbose}{If \code{TRUE}, information about the optimization algorithm
is printed.}

\item{sim_cache_limit}{The maximal number of simulations results that will be 
cached. Cached results may be reused in following estimation steps if 
they are within the current block. Reduce this value to save memory. 
Setting this to a value smaller than \code{sim} disables caching.}

\item{block_width}{The relative width of a block within jaatha will fit its
local GLM. The default value is usually fine. Increasing this value may 
help in case jaatha fails to converge, while you can try decreasing it if 
the estimates of the likelihoods differ from the corrected values in the 
'Correcting likelihoods for best estimates' phase.}
}
\value{
A list contain the results. The list has the following entries:
\describe{
   \item{estimate}{The (approximated) maximum likelihood estimate}
   \item{loglikelihood}{The estimate log-likelihood of the estimate.}
   \item{converged}{A boolean indicating whether the optimization procedure
                    converged or not}
   \item{args}{The arguments provided to the jaatha function}
}
}
\description{
Simulation based maximum likelihood estimation
}
\section{Initialization Methods}{

  Jaatha has different options for determining the starting positions for 
  it's optimization procedure. The option \code{initial-search} will divide
  the parameter space in a number of equally sized block, estimate parameters
  within each block and use the estimates with the highest likelihood as
  starting positions. The option \code{zoom-in} starts with a block that
  is equal to the complete parameter space, estimate parameters in there,
  and then iteratively creates a smaller block around the estimates. Finally,
  \code{random} chooses random starting postions and
  \code{middle} will just start all repetitions at the middle of the 
  parameter space.
}
\author{
Paul Staab and Lisha Mathew
}

