% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Polynomials.R
\name{ZonalPol}
\alias{ZonalPol}
\title{Zonal polynomial}
\usage{
ZonalPol(n, lambda, algorithm = "DK", basis = "canonical",
  exact = TRUE)
}
\arguments{
\item{n}{number of variables, a positive integer}

\item{lambda}{an integer partition, given as a vector of decreasing
integers}

\item{algorithm}{the algorithm used, either \code{"DK"} or \code{"naive"}}

\item{basis}{the polynomial basis for \code{algorithm = "naive"},
either \code{"canonical"} or \code{"MSF"} (monomial symmetric functions);
for \code{algorithm = "DK"} the canonical basis is always used and
this parameter is ignored}

\item{exact}{logical, whether to get rational coefficients when using
\code{algorithm = "naive"}; ignored if \code{algorithm = "DK"}}
}
\value{
A polynomial (\code{mvp} object; see \link[mvp]{mvp-package}) or a
character string if \code{basis = "MSF"}.
}
\description{
Returns the zonal polynomial.
}
\examples{
ZonalPol(3, lambda = c(3,1), algorithm = "naive")
ZonalPol(3, lambda = c(3,1), algorithm = "DK")
ZonalPol(3, lambda = c(3,1), algorithm = "naive", basis = "MSF")
}
