% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_variants.R
\name{create_variants}
\alias{create_variants}
\title{Create variants from a reference genome.}
\usage{
create_variants(reference, vars_info, sub, ins = NULL, del = NULL,
  gamma_mats = NULL, region_size = 100, n_threads = 1,
  show_progress = FALSE)
}
\arguments{
\item{reference}{A \code{ref_genome} object from which to generate variants.
This argument is required.}

\item{vars_info}{Output from one of the \code{\link{vars_functions}}.
These functions organize higher-level information for use here.
See \code{\link{vars_functions}} for brief descriptions and links to each method.
If this argument is \code{NULL}, all arguments other than \code{reference} are ignored,
and an empty \code{variants} object with no variants is returned.
This is designed for use when you'd like to add mutations manually.
If you create a blank \code{variants} object, you can= use its \code{add_vars} method
to add variants manually.}

\item{sub}{Output from one of the \code{\link{sub_models}} functions that organizes
information for the substitution models.
See \code{\link{sub_models}} for more information on these models and
their required parameters.
This argument is only allowed to be missing if you are using a VCF file to create
variants.
Defaults to \code{NULL}.}

\item{ins}{Output from the \code{\link{indels}} function that specifies rates
of insertions by length.
Passing \code{NULL} to this argument results in no insertions.
Defaults to \code{NULL}.}

\item{del}{Output from the \code{\link{indels}} function that specifies rates
of deletions by length.
Passing \code{NULL} to this argument results in no deletions.
Defaults to \code{NULL}.}

\item{gamma_mats}{Output from the \code{\link{site_var}} function that specifies
variability in mutation rates among sites (for both substitutions and indels).
Passing \code{NULL} to this argument results in no variability among sites.
Defaults to \code{NULL}.}

\item{region_size}{Size of regions to break genome into for sampling mutation
locations.
This causes Gamma regions to be split into smaller sections (obviously the
Gamma values themselves are not changed).
Doing this splitting is useful because sampling within a region is more
computationally costly than sampling among regions.
Higher numbers will result in lower memory usage but slower speed.
Defaults to \code{100}.}

\item{n_threads}{Number of threads to use for parallel processing.
This argument is ignored if OpenMP is not enabled.
Threads are spread across sequences, so it
doesn't make sense to supply more threads than sequences in the reference genome.
Defaults to \code{1}.}

\item{show_progress}{Boolean for whether to show a progress bar during processing.
Defaults to \code{FALSE}.}
}
\description{
Uses one of multiple methods to create haploid variants from a reference genome.
See \code{\link{vars_functions}} for the methods available.
}
\examples{
r <- create_genome(10, 1000)
v_phylo <- create_variants(r, vars_phylo(ape::rcoal(5)), sub_JC69(0.1))
v_theta <- create_variants(r, vars_theta(0.001, 5), sub_K80(0.1, 0.2))

}
