% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as_and_untabyl.R
\name{as_tabyl}
\alias{as_tabyl}
\title{Add \code{tabyl} attributes to a data.frame.}
\usage{
as_tabyl(dat, axes = 2, row_var_name = NULL, col_var_name = NULL)
}
\arguments{
\item{dat}{a data.frame with variable values in the first column and numeric values in all other columns.}

\item{axes}{is this a two_way tabyl or a one_way tabyl?  If this function is being called by a user, this should probably be "2".  One-way tabyls are created by \code{tabyl} but are a special case.}

\item{row_var_name}{(optional) the name of the variable in the row dimension; used by \code{adorn_title()}.}

\item{col_var_name}{(optional) the name of the variable in the column dimension; used by \code{adorn_title()}.}
}
\value{
Returns the same data.frame, but with the additional class of "tabyl" and the attribute "core".
}
\description{
A \code{tabyl} is a data.frame containing counts of a variable or co-occurrences of two variables (a.k.a., a contingency table or crosstab).  This specialized kind of data.frame has attributes that enable \code{adorn_} functions to be called for precise formatting and presentation of results.  E.g., display results as a mix of percentages, Ns, add totals rows or columns, rounding options, in the style of Microsoft Excel PivotTable.

A \code{tabyl} can be the result of a call to \code{janitor::tabyl()}, in which case these attributes are added automatically.  This function adds \code{tabyl} class attributes to a data.frame that isn't the result of a call to \code{tabyl} but meets the requirements of a two-way tabyl:
1) First column contains values of variable 1
2) Column names 2:n are the values of variable 2
3) Numeric values in columns 2:n are counts of the co-occurrences of the two variables.*

* = this is the ideal form of a tabyl, but janitor's \code{adorn_} functions tolerate and ignore non-numeric columns in positions 2:n.

For instance, the result of \code{dplyr::count()} followed by \code{tidyr::spread()} can be treated as a \code{tabyl}.

The result of calling \code{tabyl()} on a single variable is a special class of one-way tabyl; this function only pertains to the two-way tabyl.
}
\examples{
as_tabyl(mtcars)

}
