% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ges.R
\name{ges}
\alias{ges}
\title{Generalized Evidence Synthesis with Direct Penalization of Observational Studies}
\usage{
ges(data, EmBi = FALSE, mu.bias = -1.25, sigma.bias = 0.1,
  ExPe = FALSE, K = 0.5, df = 4, mean.mu.0 = 0, sd.mu.0 = 10,
  scale.sigma.within = 0.5, scale.sigma.between = 0.5,
  df.scale.within = 1, df.scale.between = 1, nr.chains = 2,
  nr.iterations = 20000, nr.adapt = 1000, nr.burnin = 1000,
  nr.thin = 1, be.quiet = FALSE, r2jags = TRUE)
}
\arguments{
\item{data}{A data frame where the first colum is the treatment effect TE, the second column
is the standard error of the treatment effect seTE and the third column is a factor
indicating the statistical design of the study.}

\item{EmBi}{Indicates if Empirical Bias Penalization is performed. The default is FALSE.}

\item{mu.bias}{Empirical mean bias. The default value is -1.25 (BRANDO study, Savovic et al. 2012).}

\item{sigma.bias}{Empirical bias sd. The default value is 0.1 (BRANDO study, Savovic et al. 2012).}

\item{ExPe}{Indicates if Explicit Bias Penalization is performed.  The default is FALSE.}

\item{K}{Prior expected value of the weights used for observational studies, E(w_OS)=K. 
The default value is 0.5.}

\item{df}{The degrees of freedom for the scale mixture distribution. The default value is 4.}

\item{mean.mu.0}{Prior mean of the overall mean parameter mu.0. The default value is 0.}

\item{sd.mu.0}{Prior standard deviation of mu.0}

\item{scale.sigma.within}{Prior scale parameter for the standard deviation within study type. The default value is 0.5.}

\item{scale.sigma.between}{Prior scale parameter for the standard deviation between study type. The default value is 0.5.}

\item{df.scale.within}{Degrees of freedom of the standard deviation within study type. The default value is 1.}

\item{df.scale.between}{Degrees of freedom of the standard deviation between study type. The default value is 1.}

\item{nr.chains}{Number of chains for the MCMC computations, default 2.}

\item{nr.iterations}{Number of iterations after adapting the MCMC, default is 10000. Some models may need more iterations.}

\item{nr.adapt}{Number of iterations in the adaptation process, defualt is 1000. Some models may need more iterations during adptation.}

\item{nr.burnin}{Number of iteration discared for burnin period, default is 1000. Some models may need a longer burnin period.}

\item{nr.thin}{Thinning rate, it must be a positive integer, the default value 1.}

\item{be.quiet}{Do not print warning message if the model does not adapt. The default value is FALSE. If you are not sure about the adaptation period choose be.quiet=TRUE.}

\item{r2jags}{Which interface is used to link R to JAGS (rjags and R2jags), default value is R2Jags=TRUE.}
}
\value{
This function returns an object of the class "ges". This object contains the MCMC output of
each parameter and hyper-parameter in the model, the data frame used for fitting the model and 
type of random effects distribution

The results of the object of the class ges can be extracted with R2jags or with rjags. In addition
a summary, a print and a plot functions are implemented for this type of object.
}
\description{
This function fits a hierarchical meta-regression model based on
a three levels random-effects model with direct penalization of observational studies.
}
\examples{

\dontrun{

 library(jarbes)
 data(ppvipv)
 
 # Three levels hierarchical model ....
 m1.ges = ges(ppvipv)
 summary(m1.ges)
 
 # Three levels hierarchical mode with empirical bias penalization...
 m2.ges = ges(ppvipv, EmBi = TRUE)
 summary(m2.ges)
 
 # Three levels hierarchical model with explicit bias penalization ...
 m3.ges = ges(ppvipv, ExPe = TRUE, K = 0.5, df = 10)
 summary(m3.ges)
}


}
\references{
Verde, P.E. and Curcio, D. (2017) Hierarchical Meta-Regression Modelling: The Case of The Pneumococcal Polysaccharide Vaccine. Technical Report.
}
