/*
 * Decompiled with CFR 0.152.
 */
package org.fgilbert.jdx;

import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import jdk.nashorn.api.scripting.ScriptObjectMirror;
import org.fgilbert.jdx.Utility;

public class JavaToR {
    private static final int NA_INT = Integer.MIN_VALUE;
    private static final double NA_DOUBLE = Double.longBitsToDouble(9218868437227407266L);
    private static final boolean NA_ASSUMPTION_LOGICAL = false;
    private static final byte NA_ASSUMPTION_RAW = 0;
    private ArrayOrder arrayOrder;
    private int[] dimensions;
    private boolean isNamedListOfScalars;
    private RdataExceptionCode rDataExceptionCode;
    private RdataTypeCode rDataTypeCode;
    private RdataStructureCode rDataStructureCode;
    private int rDataUserDefinedCode;
    private Object value;

    public JavaToR() {
        this.initialize(null, ArrayOrder.ROW_MAJOR);
    }

    public JavaToR(Object value) {
        this.initialize(value, ArrayOrder.ROW_MAJOR);
    }

    public JavaToR(Object value, ArrayOrder arrayOrder) {
        this.initialize(value, arrayOrder);
    }

    public JavaToR(Object value, int rDataUserDefinedCode) {
        this.initialize(value, rDataUserDefinedCode);
    }

    private double[] coerceToDoubleArray1D(BigDecimal[] a) {
        if (a == null) {
            return null;
        }
        double[] b = new double[a.length];
        int i = 0;
        while (i < b.length) {
            b[i] = a[i] == null ? NA_DOUBLE : a[i].doubleValue();
            ++i;
        }
        return b;
    }

    private double[] coerceToDoubleArray1D(BigInteger[] a) {
        if (a == null) {
            return null;
        }
        double[] b = new double[a.length];
        int i = 0;
        while (i < b.length) {
            b[i] = a[i] == null ? NA_DOUBLE : a[i].doubleValue();
            ++i;
        }
        return b;
    }

    private double[] coerceToDoubleArray1D(float[] a) {
        if (a == null) {
            return null;
        }
        double[] b = new double[a.length];
        int i = 0;
        while (i < b.length) {
            b[i] = a[i];
            ++i;
        }
        return b;
    }

    private double[] coerceToDoubleArray1D(Float[] a) {
        if (a == null) {
            return null;
        }
        double[] b = new double[a.length];
        int i = 0;
        while (i < b.length) {
            b[i] = a[i] == null ? NA_DOUBLE : a[i].doubleValue();
            ++i;
        }
        return b;
    }

    private double[] coerceToDoubleArray1D(long[] a) {
        if (a == null) {
            return null;
        }
        double[] b = new double[a.length];
        int i = 0;
        while (i < b.length) {
            b[i] = a[i];
            ++i;
        }
        return b;
    }

    private double[] coerceToDoubleArray1D(Long[] a) {
        if (a == null) {
            return null;
        }
        double[] b = new double[a.length];
        int i = 0;
        while (i < b.length) {
            b[i] = a[i] == null ? NA_DOUBLE : a[i].doubleValue();
            ++i;
        }
        return b;
    }

    private int[] coerceToIntegerArray1D(short[] a) {
        if (a == null) {
            return null;
        }
        int[] b = new int[a.length];
        int i = 0;
        while (i < b.length) {
            b[i] = a[i];
            ++i;
        }
        return b;
    }

    private int[] coerceToIntegerArray1D(Short[] a) {
        if (a == null) {
            return null;
        }
        int[] b = new int[a.length];
        int i = 0;
        while (i < b.length) {
            b[i] = a[i] == null ? Integer.MIN_VALUE : a[i].intValue();
            ++i;
        }
        return b;
    }

    private String[] coerceToStringArray1D(char[] a) {
        if (a == null) {
            return null;
        }
        String[] b = new String[a.length];
        int i = 0;
        while (i < b.length) {
            b[i] = Character.toString(a[i]);
            ++i;
        }
        return b;
    }

    private String[] coerceToStringArray1D(Character[] a) {
        if (a == null) {
            return null;
        }
        String[] b = new String[a.length];
        int i = 0;
        while (i < b.length) {
            b[i] = a[i] == null ? null : a[i].toString();
            ++i;
        }
        return b;
    }

    private boolean[] coerceCollectionToBooleanArray1D(Collection<Boolean> a) {
        if (a == null) {
            return null;
        }
        boolean[] z = new boolean[a.size()];
        Iterator<Boolean> iter = a.iterator();
        int i = 0;
        while (i < z.length) {
            Boolean bool = iter.next();
            if (bool == null) {
                z[i] = false;
                this.rDataExceptionCode = RdataExceptionCode.WARNING_MISSING_LOGICAL_VALUES;
            } else {
                z[i] = bool;
            }
            ++i;
        }
        return z;
    }

    private byte[] coerceCollectionToByteArray1D(Collection<Number> a) {
        if (a == null) {
            return null;
        }
        byte[] b = new byte[a.size()];
        Iterator<Number> iter = a.iterator();
        int i = 0;
        while (i < b.length) {
            Number nu = iter.next();
            if (nu == null) {
                b[i] = 0;
                this.rDataExceptionCode = RdataExceptionCode.WARNING_MISSING_RAW_VALUES;
            } else {
                b[i] = nu.byteValue();
            }
            ++i;
        }
        return b;
    }

    private double[] coerceCollectionToDoubleArray1D(Collection<Number> a) {
        if (a == null) {
            return null;
        }
        double[] b = new double[a.size()];
        Iterator<Number> iter = a.iterator();
        int i = 0;
        while (i < b.length) {
            Number nu = iter.next();
            b[i] = nu == null ? NA_DOUBLE : nu.doubleValue();
            ++i;
        }
        return b;
    }

    private int[] coerceCollectionToIntArray1D(Collection<Number> a) {
        if (a == null) {
            return null;
        }
        int[] b = new int[a.size()];
        Iterator<Number> iter = a.iterator();
        int i = 0;
        while (i < b.length) {
            Number nu = iter.next();
            b[i] = nu == null ? Integer.MIN_VALUE : nu.intValue();
            ++i;
        }
        return b;
    }

    private String[] coerceCollectionToStringArray1D(Collection<?> a) {
        if (a == null) {
            return null;
        }
        String[] b = new String[a.size()];
        Iterator<?> iter = a.iterator();
        int i = 0;
        while (i < b.length) {
            Object o = iter.next();
            b[i] = o == null ? null : o.toString();
            ++i;
        }
        return b;
    }

    private void convertCollection() {
        Collection col = (Collection)this.value;
        if (col.isEmpty()) {
            this.rDataTypeCode = RdataTypeCode.OTHER;
            this.rDataStructureCode = RdataStructureCode.LIST;
            this.value = new Object[]{new int[0], new Object[0]};
            return;
        }
        if (this.convertCollectionToArray1D(col)) {
            return;
        }
        Iterator iter = col.iterator();
        Object o = iter.next();
        JavaToR j2r = new JavaToR(o, this.arrayOrder);
        if (j2r.rDataExceptionCode != RdataExceptionCode.NONE) {
            this.rDataExceptionCode = j2r.rDataExceptionCode;
        }
        int[] compositeTypes = new int[col.size()];
        compositeTypes[0] = j2r.getRdataCompositeCode();
        Object[] objects = new Object[col.size()];
        objects[0] = j2r.getValueObject();
        MaybeNdimensionalArray maybeNdimensionalArray = new MaybeNdimensionalArray(col.size(), j2r);
        MaybeRowMajorDataFrame maybeRowMajorDataFrame = new MaybeRowMajorDataFrame(j2r);
        int i = 1;
        while (i < compositeTypes.length) {
            j2r = new JavaToR(iter.next(), this.arrayOrder);
            if (j2r.rDataExceptionCode != RdataExceptionCode.NONE) {
                this.rDataExceptionCode = j2r.rDataExceptionCode;
            }
            compositeTypes[i] = j2r.getRdataCompositeCode();
            objects[i] = j2r.getValueObject();
            if (maybeNdimensionalArray.getValue()) {
                maybeNdimensionalArray.update(j2r);
            } else if (maybeRowMajorDataFrame.getValue()) {
                maybeRowMajorDataFrame.update(j2r);
            }
            ++i;
        }
        if (maybeNdimensionalArray.getValue()) {
            if (maybeNdimensionalArray.getSubarrayDimensions().length == 1) {
                this.convertCollectionToArray2D(maybeNdimensionalArray, objects, compositeTypes);
            } else {
                this.convertCollectionToArrayND(maybeNdimensionalArray, objects, compositeTypes);
            }
            return;
        }
        if (maybeRowMajorDataFrame.getValue()) {
            this.convertCollectionToDataFrame(maybeRowMajorDataFrame, objects);
            return;
        }
        this.rDataTypeCode = RdataTypeCode.OTHER;
        this.rDataStructureCode = RdataStructureCode.LIST;
        this.value = new Object[]{compositeTypes, objects};
    }

    private boolean convertCollectionToArray1D(Collection<?> col) {
        boolean characterVector = false;
        boolean integerVector = false;
        boolean logicalVector = false;
        boolean numericVector = false;
        boolean rawVector = false;
        Iterator<?> iter = col.iterator();
        Class<?> cls = null;
        Object o = null;
        while (iter.hasNext()) {
            o = iter.next();
            if (o == null) continue;
            cls = o.getClass();
            if (Number.class.isAssignableFrom(cls)) {
                if (cls.equals(Double.class) || cls.equals(Long.class) || cls.equals(Float.class) || cls.equals(BigDecimal.class) || cls.equals(BigInteger.class)) {
                    numericVector = true;
                } else if (cls.equals(Integer.class) || cls.equals(Short.class)) {
                    integerVector = true;
                } else if (cls.equals(Byte.class)) {
                    rawVector = true;
                }
                if (!characterVector && !logicalVector) continue;
                return false;
            }
            if (cls.equals(String.class) || cls.equals(Character.class)) {
                if (numericVector || integerVector || rawVector || logicalVector) {
                    return false;
                }
                characterVector = true;
                continue;
            }
            if (cls.equals(Boolean.class)) {
                if (numericVector || integerVector || rawVector || characterVector) {
                    return false;
                }
                logicalVector = true;
                continue;
            }
            return false;
        }
        if (numericVector) {
            this.dimensions = new int[]{col.size()};
            this.rDataTypeCode = RdataTypeCode.NUMERIC;
            this.rDataStructureCode = RdataStructureCode.VECTOR;
            this.value = this.coerceCollectionToDoubleArray1D(col);
            return true;
        }
        if (integerVector) {
            this.dimensions = new int[]{col.size()};
            this.rDataTypeCode = RdataTypeCode.INTEGER;
            this.rDataStructureCode = RdataStructureCode.VECTOR;
            this.value = this.coerceCollectionToIntArray1D(col);
            return true;
        }
        if (rawVector) {
            this.dimensions = new int[]{col.size()};
            this.rDataTypeCode = RdataTypeCode.RAW;
            this.rDataStructureCode = RdataStructureCode.VECTOR;
            this.value = this.coerceCollectionToByteArray1D(col);
            return true;
        }
        if (characterVector) {
            this.dimensions = new int[]{col.size()};
            this.rDataTypeCode = RdataTypeCode.CHARACTER;
            this.rDataStructureCode = RdataStructureCode.VECTOR;
            this.value = this.coerceCollectionToStringArray1D(col);
            return true;
        }
        if (logicalVector) {
            this.dimensions = new int[]{col.size()};
            this.rDataTypeCode = RdataTypeCode.LOGICAL;
            this.rDataStructureCode = RdataStructureCode.VECTOR;
            this.value = this.coerceCollectionToBooleanArray1D(col);
            return true;
        }
        return false;
    }

    private void convertCollectionToArray2D(MaybeNdimensionalArray maybeNdimensionalArray, Object[] objects, int[] compositeTypes) {
        int subarrayLength = maybeNdimensionalArray.getSubarrayDimensions()[0];
        switch (this.arrayOrder) {
            case COLUMN_MINOR: 
            case ROW_MAJOR: {
                this.dimensions = new int[]{objects.length, subarrayLength};
                break;
            }
            case COLUMN_MAJOR: {
                this.dimensions = new int[]{subarrayLength, objects.length};
            }
        }
        Object[] flatArray = null;
        int flatArrayLength = objects.length * subarrayLength;
        switch (maybeNdimensionalArray.getTypeCode()) {
            case NUMERIC: {
                double[] flatArrayDouble = new double[flatArrayLength];
                switch (this.arrayOrder) {
                    case COLUMN_MINOR: 
                    case ROW_MAJOR: {
                        int rows = objects.length;
                        int i = 0;
                        while (i < rows) {
                            int j;
                            int dataTypeCodeInt = compositeTypes[i] & 0xFF;
                            if (dataTypeCodeInt == RdataTypeCode.NUMERIC.value) {
                                double[] subarrayDouble = (double[])objects[i];
                                j = 0;
                                while (j < subarrayLength) {
                                    flatArrayDouble[i + j * rows] = subarrayDouble[j];
                                    ++j;
                                }
                            } else if (dataTypeCodeInt == RdataTypeCode.INTEGER.value) {
                                int[] subarrayInt = (int[])objects[i];
                                j = 0;
                                while (j < subarrayLength) {
                                    flatArrayDouble[i + j * rows] = subarrayInt[j];
                                    ++j;
                                }
                            } else if (dataTypeCodeInt == RdataTypeCode.RAW.value) {
                                byte[] subarrayByte = (byte[])objects[i];
                                j = 0;
                                while (j < subarrayLength) {
                                    flatArrayDouble[i + j * rows] = subarrayByte[j];
                                    ++j;
                                }
                            } else {
                                throw new RuntimeException(String.format("The R data type code 0x%X is unsupported when converting a collection of arrays to a numeric matrix.", dataTypeCodeInt));
                            }
                            ++i;
                        }
                        break;
                    }
                    case COLUMN_MAJOR: {
                        int flatArrayIndex = 0;
                        int i = 0;
                        while (i < objects.length) {
                            int j;
                            int dataTypeCodeInt = compositeTypes[i] & 0xFF;
                            if (dataTypeCodeInt == RdataTypeCode.NUMERIC.value) {
                                double[] subarrayDouble = (double[])objects[i];
                                j = 0;
                                while (j < subarrayLength) {
                                    flatArrayDouble[flatArrayIndex++] = subarrayDouble[j];
                                    ++j;
                                }
                            } else if (dataTypeCodeInt == RdataTypeCode.INTEGER.value) {
                                int[] subarrayInt = (int[])objects[i];
                                j = 0;
                                while (j < subarrayLength) {
                                    flatArrayDouble[flatArrayIndex++] = subarrayInt[j];
                                    ++j;
                                }
                            } else if (dataTypeCodeInt == RdataTypeCode.RAW.value) {
                                byte[] subarrayByte = (byte[])objects[i];
                                j = 0;
                                while (j < subarrayLength) {
                                    flatArrayDouble[flatArrayIndex++] = subarrayByte[j];
                                    ++j;
                                }
                            } else {
                                throw new RuntimeException(String.format("The R data type code 0x%X is unsupported when converting a collection of arrays to a numeric matrix.", dataTypeCodeInt));
                            }
                            ++i;
                        }
                        break;
                    }
                }
                flatArray = flatArrayDouble;
                break;
            }
            case INTEGER: {
                int[] flatArrayInt = new int[flatArrayLength];
                switch (this.arrayOrder) {
                    case COLUMN_MINOR: 
                    case ROW_MAJOR: {
                        int rows = objects.length;
                        int i = 0;
                        while (i < rows) {
                            int j;
                            int dataTypeCodeInt = compositeTypes[i] & 0xFF;
                            if (dataTypeCodeInt == RdataTypeCode.INTEGER.value) {
                                int[] subarrayInt = (int[])objects[i];
                                j = 0;
                                while (j < subarrayLength) {
                                    flatArrayInt[i + j * rows] = subarrayInt[j];
                                    ++j;
                                }
                            } else if (dataTypeCodeInt == RdataTypeCode.RAW.value) {
                                byte[] subarrayByte = (byte[])objects[i];
                                j = 0;
                                while (j < subarrayLength) {
                                    flatArrayInt[i + j * rows] = subarrayByte[j];
                                    ++j;
                                }
                            } else {
                                throw new RuntimeException(String.format("The R data type code 0x%X is unsupported when converting a collection of arrays to an integer matrix.", dataTypeCodeInt));
                            }
                            ++i;
                        }
                        break;
                    }
                    case COLUMN_MAJOR: {
                        int flatArrayIndex = 0;
                        int i = 0;
                        while (i < objects.length) {
                            int j;
                            int dataTypeCodeInt = compositeTypes[i] & 0xFF;
                            if (dataTypeCodeInt == RdataTypeCode.INTEGER.value) {
                                int[] subarrayInt = (int[])objects[i];
                                j = 0;
                                while (j < subarrayLength) {
                                    flatArrayInt[flatArrayIndex++] = subarrayInt[j];
                                    ++j;
                                }
                            } else if (dataTypeCodeInt == RdataTypeCode.RAW.value) {
                                byte[] subarrayByte = (byte[])objects[i];
                                j = 0;
                                while (j < subarrayLength) {
                                    flatArrayInt[flatArrayIndex++] = subarrayByte[j];
                                    ++j;
                                }
                            } else {
                                throw new RuntimeException(String.format("The R data type code 0x%X is unsupported when converting a collection of arrays to an integer matrix.", dataTypeCodeInt));
                            }
                            ++i;
                        }
                        break;
                    }
                }
                flatArray = flatArrayInt;
                break;
            }
            case CHARACTER: {
                String[] flatArrayString = new String[flatArrayLength];
                switch (this.arrayOrder) {
                    case COLUMN_MINOR: 
                    case ROW_MAJOR: {
                        int rows = objects.length;
                        int i = 0;
                        while (i < rows) {
                            String[] subarrayString = (String[])objects[i];
                            int j = 0;
                            while (j < subarrayLength) {
                                flatArrayString[i + j * rows] = subarrayString[j];
                                ++j;
                            }
                            ++i;
                        }
                        break;
                    }
                    case COLUMN_MAJOR: {
                        int flatArrayIndex = 0;
                        int i = 0;
                        while (i < objects.length) {
                            String[] subarrayString = (String[])objects[i];
                            int j = 0;
                            while (j < subarrayLength) {
                                flatArrayString[flatArrayIndex++] = subarrayString[j];
                                ++j;
                            }
                            ++i;
                        }
                        break;
                    }
                }
                flatArray = flatArrayString;
                break;
            }
            case LOGICAL: {
                boolean[] flatArrayBoolean = new boolean[flatArrayLength];
                switch (this.arrayOrder) {
                    case COLUMN_MINOR: 
                    case ROW_MAJOR: {
                        int rows = objects.length;
                        int i = 0;
                        while (i < rows) {
                            boolean[] subarrayBoolean = (boolean[])objects[i];
                            int j = 0;
                            while (j < subarrayLength) {
                                flatArrayBoolean[i + j * rows] = subarrayBoolean[j];
                                ++j;
                            }
                            ++i;
                        }
                        break;
                    }
                    case COLUMN_MAJOR: {
                        int flatArrayIndex = 0;
                        int i = 0;
                        while (i < objects.length) {
                            boolean[] subarrayBoolean = (boolean[])objects[i];
                            int j = 0;
                            while (j < subarrayLength) {
                                flatArrayBoolean[flatArrayIndex++] = subarrayBoolean[j];
                                ++j;
                            }
                            ++i;
                        }
                        break;
                    }
                }
                flatArray = flatArrayBoolean;
                break;
            }
            case RAW: {
                byte[] flatArrayByte = new byte[flatArrayLength];
                switch (this.arrayOrder) {
                    case COLUMN_MINOR: 
                    case ROW_MAJOR: {
                        int rows = objects.length;
                        int i = 0;
                        while (i < rows) {
                            byte[] subarrayByte = (byte[])objects[i];
                            int j = 0;
                            while (j < subarrayLength) {
                                flatArrayByte[i + j * rows] = subarrayByte[j];
                                ++j;
                            }
                            ++i;
                        }
                        break;
                    }
                    case COLUMN_MAJOR: {
                        int flatArrayIndex = 0;
                        int i = 0;
                        while (i < objects.length) {
                            byte[] subarrayByte = (byte[])objects[i];
                            int j = 0;
                            while (j < subarrayLength) {
                                flatArrayByte[flatArrayIndex++] = subarrayByte[j];
                                ++j;
                            }
                            ++i;
                        }
                        break;
                    }
                }
                flatArray = flatArrayByte;
                break;
            }
            default: {
                throw new RuntimeException(String.format("The R data type code %s is unsupported when converting collections to matrices.", new Object[]{maybeNdimensionalArray.getTypeCode()}));
            }
        }
        this.value = new Object[]{this.dimensions, flatArray};
        this.rDataTypeCode = maybeNdimensionalArray.getTypeCode();
        this.rDataStructureCode = RdataStructureCode.ND_ARRAY;
    }

    private void convertCollectionToArrayND(MaybeNdimensionalArray maybeNdimensionalArray, Object[] objects, int[] compositeTypes) {
        int[] subarrayDimensions = maybeNdimensionalArray.getSubarrayDimensions();
        switch (this.arrayOrder) {
            case ROW_MAJOR: {
                this.dimensions = new int[subarrayDimensions.length + 1];
                this.dimensions[0] = objects.length;
                int i = 0;
                while (i < subarrayDimensions.length) {
                    this.dimensions[i + 1] = subarrayDimensions[i];
                    ++i;
                }
                break;
            }
            case COLUMN_MAJOR: 
            case COLUMN_MINOR: {
                this.dimensions = Arrays.copyOf(subarrayDimensions, subarrayDimensions.length + 1);
                this.dimensions[this.dimensions.length - 1] = objects.length;
            }
        }
        Object[] flatArray = null;
        int flatArrayIndex = 0;
        int flatArrayLength = objects.length;
        int i = 0;
        while (i < subarrayDimensions.length) {
            flatArrayLength *= subarrayDimensions[i];
            ++i;
        }
        switch (maybeNdimensionalArray.getTypeCode()) {
            case NUMERIC: {
                int dataTypeCodeInt;
                double[] flatArrayDouble = new double[flatArrayLength];
                switch (this.arrayOrder) {
                    case ROW_MAJOR: {
                        int i2 = 0;
                        while (i2 < objects.length) {
                            int j;
                            Object[] ndObject = (Object[])objects[i2];
                            dataTypeCodeInt = compositeTypes[i2] & 0xFF;
                            if (dataTypeCodeInt == RdataTypeCode.NUMERIC.value) {
                                double[] arrayDataDouble = (double[])ndObject[1];
                                j = 0;
                                while (j < arrayDataDouble.length) {
                                    flatArrayDouble[flatArrayIndex + j * objects.length] = arrayDataDouble[j];
                                    ++j;
                                }
                                ++flatArrayIndex;
                            } else if (dataTypeCodeInt == RdataTypeCode.INTEGER.value) {
                                int[] arrayDataInt = (int[])ndObject[1];
                                j = 0;
                                while (j < arrayDataInt.length) {
                                    flatArrayDouble[flatArrayIndex + j * objects.length] = arrayDataInt[j];
                                    ++j;
                                }
                                ++flatArrayIndex;
                            } else if (dataTypeCodeInt == RdataTypeCode.RAW.value) {
                                byte[] arrayDataByte = (byte[])ndObject[1];
                                j = 0;
                                while (j < arrayDataByte.length) {
                                    flatArrayDouble[flatArrayIndex + j * objects.length] = arrayDataByte[j];
                                    ++j;
                                }
                                ++flatArrayIndex;
                            } else {
                                throw new RuntimeException(String.format("The R data type code 0x%X is unsupported when converting a collection of arrays to a numeric n-dimensional array.", dataTypeCodeInt));
                            }
                            ++i2;
                        }
                        break;
                    }
                    case COLUMN_MAJOR: 
                    case COLUMN_MINOR: {
                        int i3 = 0;
                        while (i3 < objects.length) {
                            int j;
                            Object[] ndObject = (Object[])objects[i3];
                            dataTypeCodeInt = compositeTypes[i3] & 0xFF;
                            if (dataTypeCodeInt == RdataTypeCode.NUMERIC.value) {
                                double[] arrayDataDouble = (double[])ndObject[1];
                                j = 0;
                                while (j < arrayDataDouble.length) {
                                    flatArrayDouble[flatArrayIndex++] = arrayDataDouble[j];
                                    ++j;
                                }
                            } else if (dataTypeCodeInt == RdataTypeCode.INTEGER.value) {
                                int[] arrayDataInt = (int[])ndObject[1];
                                j = 0;
                                while (j < arrayDataInt.length) {
                                    flatArrayDouble[flatArrayIndex++] = arrayDataInt[j];
                                    ++j;
                                }
                            } else if (dataTypeCodeInt == RdataTypeCode.RAW.value) {
                                byte[] arrayDataByte = (byte[])ndObject[1];
                                j = 0;
                                while (j < arrayDataByte.length) {
                                    flatArrayDouble[flatArrayIndex++] = arrayDataByte[j];
                                    ++j;
                                }
                            } else {
                                throw new RuntimeException(String.format("The R data type code 0x%X is unsupported when converting a collection of arrays to a numeric n-dimensional array.", dataTypeCodeInt));
                            }
                            ++i3;
                        }
                        break;
                    }
                }
                flatArray = flatArrayDouble;
                break;
            }
            case INTEGER: {
                int dataTypeCodeInt;
                int[] flatArrayInt = new int[flatArrayLength];
                switch (this.arrayOrder) {
                    case ROW_MAJOR: {
                        int i4 = 0;
                        while (i4 < objects.length) {
                            int j;
                            Object[] ndObject = (Object[])objects[i4];
                            dataTypeCodeInt = compositeTypes[i4] & 0xFF;
                            if (dataTypeCodeInt == RdataTypeCode.INTEGER.value) {
                                int[] arrayDataInt = (int[])ndObject[1];
                                j = 0;
                                while (j < arrayDataInt.length) {
                                    flatArrayInt[flatArrayIndex + j * objects.length] = arrayDataInt[j];
                                    ++j;
                                }
                                ++flatArrayIndex;
                            } else if (dataTypeCodeInt == RdataTypeCode.RAW.value) {
                                byte[] arrayDataByte = (byte[])ndObject[1];
                                j = 0;
                                while (j < arrayDataByte.length) {
                                    flatArrayInt[flatArrayIndex + j * objects.length] = arrayDataByte[j];
                                    ++j;
                                }
                                ++flatArrayIndex;
                            } else {
                                throw new RuntimeException(String.format("The R data type code 0x%X is unsupported when converting a collection of arrays to an integer n-dimensional array.", dataTypeCodeInt));
                            }
                            ++i4;
                        }
                        break;
                    }
                    case COLUMN_MAJOR: 
                    case COLUMN_MINOR: {
                        int i5 = 0;
                        while (i5 < objects.length) {
                            int j;
                            Object[] ndObject = (Object[])objects[i5];
                            dataTypeCodeInt = compositeTypes[i5] & 0xFF;
                            if (dataTypeCodeInt == RdataTypeCode.INTEGER.value) {
                                int[] arrayDataInt = (int[])ndObject[1];
                                j = 0;
                                while (j < arrayDataInt.length) {
                                    flatArrayInt[flatArrayIndex++] = arrayDataInt[j];
                                    ++j;
                                }
                            } else if (dataTypeCodeInt == RdataTypeCode.RAW.value) {
                                byte[] arrayDataByte = (byte[])ndObject[1];
                                j = 0;
                                while (j < arrayDataByte.length) {
                                    flatArrayInt[flatArrayIndex++] = arrayDataByte[j];
                                    ++j;
                                }
                            } else {
                                throw new RuntimeException(String.format("The R data type code 0x%X is unsupported when converting a collection of arrays to an integer n-dimensional array.", dataTypeCodeInt));
                            }
                            ++i5;
                        }
                        break;
                    }
                }
                flatArray = flatArrayInt;
                break;
            }
            case CHARACTER: {
                String[] flatArrayString = new String[flatArrayLength];
                switch (this.arrayOrder) {
                    case ROW_MAJOR: {
                        int i6 = 0;
                        while (i6 < objects.length) {
                            Object[] ndObject = (Object[])objects[i6];
                            String[] arrayDataString = (String[])ndObject[1];
                            int j = 0;
                            while (j < arrayDataString.length) {
                                flatArrayString[flatArrayIndex + j * objects.length] = arrayDataString[j];
                                ++j;
                            }
                            ++flatArrayIndex;
                            ++i6;
                        }
                        break;
                    }
                    case COLUMN_MAJOR: 
                    case COLUMN_MINOR: {
                        int i7 = 0;
                        while (i7 < objects.length) {
                            Object[] ndObject = (Object[])objects[i7];
                            String[] arrayDataString = (String[])ndObject[1];
                            int j = 0;
                            while (j < arrayDataString.length) {
                                flatArrayString[flatArrayIndex++] = arrayDataString[j];
                                ++j;
                            }
                            ++i7;
                        }
                        break;
                    }
                }
                flatArray = flatArrayString;
                break;
            }
            case LOGICAL: {
                boolean[] flatArrayBoolean = new boolean[flatArrayLength];
                switch (this.arrayOrder) {
                    case ROW_MAJOR: {
                        int i8 = 0;
                        while (i8 < objects.length) {
                            Object[] ndObject = (Object[])objects[i8];
                            boolean[] arrayDataBoolean = (boolean[])ndObject[1];
                            int j = 0;
                            while (j < arrayDataBoolean.length) {
                                flatArrayBoolean[flatArrayIndex + j * objects.length] = arrayDataBoolean[j];
                                ++j;
                            }
                            ++flatArrayIndex;
                            ++i8;
                        }
                        break;
                    }
                    case COLUMN_MAJOR: 
                    case COLUMN_MINOR: {
                        int i9 = 0;
                        while (i9 < objects.length) {
                            Object[] ndObject = (Object[])objects[i9];
                            boolean[] arrayDataBoolean = (boolean[])ndObject[1];
                            int j = 0;
                            while (j < arrayDataBoolean.length) {
                                flatArrayBoolean[flatArrayIndex++] = arrayDataBoolean[j];
                                ++j;
                            }
                            ++i9;
                        }
                        break;
                    }
                }
                flatArray = flatArrayBoolean;
                break;
            }
            case RAW: {
                byte[] flatArrayByte = new byte[flatArrayLength];
                switch (this.arrayOrder) {
                    case ROW_MAJOR: {
                        int i10 = 0;
                        while (i10 < objects.length) {
                            Object[] ndObject = (Object[])objects[i10];
                            byte[] arrayDataByte = (byte[])ndObject[1];
                            int j = 0;
                            while (j < arrayDataByte.length) {
                                flatArrayByte[flatArrayIndex + j * objects.length] = arrayDataByte[j];
                                ++j;
                            }
                            ++flatArrayIndex;
                            ++i10;
                        }
                        break;
                    }
                    case COLUMN_MAJOR: 
                    case COLUMN_MINOR: {
                        int i11 = 0;
                        while (i11 < objects.length) {
                            Object[] ndObject = (Object[])objects[i11];
                            byte[] arrayDataByte = (byte[])ndObject[1];
                            int j = 0;
                            while (j < arrayDataByte.length) {
                                flatArrayByte[flatArrayIndex++] = arrayDataByte[j];
                                ++j;
                            }
                            ++i11;
                        }
                        break;
                    }
                }
                flatArray = flatArrayByte;
                break;
            }
            default: {
                throw new RuntimeException(String.format("The R data type code %s is unsupported when converting collections to n-dimensional arrays.", new Object[]{maybeNdimensionalArray.getTypeCode()}));
            }
        }
        this.value = new Object[]{this.dimensions, flatArray};
        this.rDataTypeCode = maybeNdimensionalArray.getTypeCode();
        this.rDataStructureCode = RdataStructureCode.ND_ARRAY;
    }

    private void convertCollectionToDataFrame(MaybeRowMajorDataFrame maybeRowMajorDataFrame, Object[] lists) {
        int[] compositeTypes = maybeRowMajorDataFrame.getCompositeTypes();
        String[] names = maybeRowMajorDataFrame.getNames();
        Object[] columns = new Object[compositeTypes.length];
        int i = 0;
        while (i < compositeTypes.length) {
            int typeCode = compositeTypes[i] & 0xFF;
            compositeTypes[i] = RdataStructureCode.VECTOR.value | typeCode;
            if (typeCode == RdataTypeCode.NUMERIC.value) {
                columns[i] = new double[lists.length];
            } else if (typeCode == RdataTypeCode.INTEGER.value) {
                columns[i] = new int[lists.length];
            } else if (typeCode == RdataTypeCode.CHARACTER.value) {
                columns[i] = new String[lists.length];
            } else if (typeCode == RdataTypeCode.LOGICAL.value) {
                columns[i] = new boolean[lists.length];
            } else if (typeCode == RdataTypeCode.RAW.value) {
                columns[i] = new byte[lists.length];
            } else {
                throw new RuntimeException(String.format("The R data type code 0x%X is not supported for a data frame column structure.", typeCode));
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < lists.length) {
            Object[] list = (Object[])lists[i2];
            Object[] values = (Object[])list[1];
            int j = 0;
            while (j < values.length) {
                int typeCode = compositeTypes[j] & 0xFF;
                if (typeCode == RdataTypeCode.NUMERIC.value) {
                    double[] d = (double[])columns[j];
                    d[i2] = ((Number)values[j]).doubleValue();
                } else if (typeCode == RdataTypeCode.INTEGER.value) {
                    int[] n = (int[])columns[j];
                    n[i2] = ((Number)values[j]).intValue();
                } else if (typeCode == RdataTypeCode.CHARACTER.value) {
                    String[] s = (String[])columns[j];
                    s[i2] = (String)values[j];
                } else if (typeCode == RdataTypeCode.LOGICAL.value) {
                    boolean[] z = (boolean[])columns[j];
                    z[i2] = (Boolean)values[j];
                } else if (typeCode == RdataTypeCode.RAW.value) {
                    byte[] b = (byte[])columns[j];
                    b[i2] = (Byte)values[j];
                }
                ++j;
            }
            ++i2;
        }
        this.rDataTypeCode = RdataTypeCode.OTHER;
        this.rDataStructureCode = RdataStructureCode.DATA_FRAME;
        this.value = new Object[]{compositeTypes, columns, names};
    }

    private void convertMap() {
        Map m = (Map)this.value;
        String[] names = new String[m.size()];
        try {
            m.keySet().toArray(names);
        }
        catch (ArrayStoreException e) {
            throw new RuntimeException("Map keys must be string types.");
        }
        Iterator iter = m.values().iterator();
        int[] types = new int[m.size()];
        Object[] objects = new Object[m.size()];
        this.isNamedListOfScalars = true;
        boolean isDataFrame = m.size() > 1;
        int vectorLength = -1;
        int i = 0;
        while (i < m.size()) {
            JavaToR j2r = new JavaToR(iter.next(), this.arrayOrder);
            types[i] = j2r.getRdataCompositeCode();
            objects[i] = j2r.getValueObject();
            if (this.isNamedListOfScalars) {
                boolean bl = this.isNamedListOfScalars = j2r.getRdataStructureCode() == RdataStructureCode.SCALAR;
            }
            if (isDataFrame) {
                boolean bl = isDataFrame = j2r.getRdataStructureCode() == RdataStructureCode.VECTOR;
                if (isDataFrame) {
                    if (vectorLength != -1) {
                        isDataFrame = vectorLength == Array.getLength(objects[i]);
                    } else {
                        vectorLength = Array.getLength(objects[i]);
                    }
                }
            }
            ++i;
        }
        this.rDataTypeCode = RdataTypeCode.OTHER;
        this.rDataStructureCode = isDataFrame ? RdataStructureCode.DATA_FRAME : RdataStructureCode.NAMED_LIST;
        this.isNamedListOfScalars &= !isDataFrame;
        this.value = new Object[]{types, objects, names};
    }

    private void convertNdimensionalBooleanArray() {
        int flatArrayLength = this.dimensions[0];
        int i = 1;
        while (i < this.dimensions.length) {
            flatArrayLength *= this.dimensions[i];
            ++i;
        }
        boolean[] flatArray = new boolean[flatArrayLength];
        int currentFlatArrayIndex = 0;
        int subarrayLength = this.dimensions[this.dimensions.length - 1];
        int subarrayCount = 0;
        if (subarrayLength != 0) {
            subarrayCount = flatArrayLength / subarrayLength;
        }
        int[] currentSubarrayIndex = new int[this.dimensions.length - 1];
        int rowCount = this.dimensions[this.dimensions.length - 2];
        int columnCount = this.dimensions[this.dimensions.length - 1];
        int matrixIndex = 0;
        int i2 = 0;
        while (i2 < subarrayCount) {
            Object o = this.value;
            int j = 0;
            while (j < currentSubarrayIndex.length - 1) {
                o = Array.get(o, currentSubarrayIndex[j]);
                ++j;
            }
            JavaToR j2r = new JavaToR(Array.get(o, currentSubarrayIndex[currentSubarrayIndex.length - 1]), this.arrayOrder);
            boolean[] subarray = j2r.getValueBooleanArray1d();
            if (j2r.rDataExceptionCode != RdataExceptionCode.NONE) {
                this.rDataExceptionCode = j2r.rDataExceptionCode;
            }
            block0 : switch (this.arrayOrder) {
                case ROW_MAJOR: {
                    int j2 = 0;
                    while (j2 < subarrayLength) {
                        flatArray[currentFlatArrayIndex + subarrayCount * j2] = subarray[j2];
                        ++j2;
                    }
                    ++currentFlatArrayIndex;
                    j2 = 0;
                    while (j2 < currentSubarrayIndex.length) {
                        if (currentSubarrayIndex[j2] < this.dimensions[j2] - 1) {
                            int n = j2;
                            currentSubarrayIndex[n] = currentSubarrayIndex[n] + 1;
                            break block0;
                        }
                        currentSubarrayIndex[j2] = 0;
                        ++j2;
                    }
                    break;
                }
                case COLUMN_MAJOR: {
                    int j2 = 0;
                    while (j2 < subarrayLength) {
                        flatArray[currentFlatArrayIndex++] = subarray[j2];
                        ++j2;
                    }
                    j2 = currentSubarrayIndex.length - 1;
                    while (j2 > -1) {
                        if (currentSubarrayIndex[j2] < this.dimensions[j2] - 1) {
                            int n = j2;
                            currentSubarrayIndex[n] = currentSubarrayIndex[n] + 1;
                            break block0;
                        }
                        currentSubarrayIndex[j2] = 0;
                        --j2;
                    }
                    break;
                }
                case COLUMN_MINOR: {
                    int j2 = 0;
                    while (j2 < columnCount) {
                        flatArray[currentFlatArrayIndex + rowCount * j2] = subarray[j2];
                        ++j2;
                    }
                    currentFlatArrayIndex = (i2 + 1) % rowCount == 0 ? ++matrixIndex * rowCount * columnCount : ++currentFlatArrayIndex;
                    j2 = currentSubarrayIndex.length - 1;
                    while (j2 > -1) {
                        if (currentSubarrayIndex[j2] < this.dimensions[j2] - 1) {
                            int n = j2;
                            currentSubarrayIndex[n] = currentSubarrayIndex[n] + 1;
                            break block0;
                        }
                        currentSubarrayIndex[j2] = 0;
                        --j2;
                    }
                    break;
                }
            }
            ++i2;
        }
        switch (this.arrayOrder) {
            case ROW_MAJOR: {
                break;
            }
            case COLUMN_MAJOR: {
                Utility.reverseArray(this.dimensions);
                break;
            }
            case COLUMN_MINOR: {
                int swap = this.dimensions[this.dimensions.length - 1];
                this.dimensions[this.dimensions.length - 1] = this.dimensions[this.dimensions.length - 2];
                this.dimensions[this.dimensions.length - 2] = swap;
                Utility.reverseArray(this.dimensions);
            }
        }
        this.value = new Object[]{this.dimensions, flatArray};
    }

    private void convertNdimensionalByteArray() {
        int flatArrayLength = this.dimensions[0];
        int i = 1;
        while (i < this.dimensions.length) {
            flatArrayLength *= this.dimensions[i];
            ++i;
        }
        byte[] flatArray = new byte[flatArrayLength];
        int currentFlatArrayIndex = 0;
        int subarrayLength = this.dimensions[this.dimensions.length - 1];
        int subarrayCount = 0;
        if (subarrayLength != 0) {
            subarrayCount = flatArrayLength / subarrayLength;
        }
        int[] currentSubarrayIndex = new int[this.dimensions.length - 1];
        int rowCount = this.dimensions[this.dimensions.length - 2];
        int columnCount = this.dimensions[this.dimensions.length - 1];
        int matrixIndex = 0;
        int i2 = 0;
        while (i2 < subarrayCount) {
            Object o = this.value;
            int j = 0;
            while (j < currentSubarrayIndex.length - 1) {
                o = Array.get(o, currentSubarrayIndex[j]);
                ++j;
            }
            JavaToR j2r = new JavaToR(Array.get(o, currentSubarrayIndex[currentSubarrayIndex.length - 1]), this.arrayOrder);
            byte[] subarray = j2r.getValueByteArray1d();
            if (j2r.rDataExceptionCode != RdataExceptionCode.NONE) {
                this.rDataExceptionCode = j2r.rDataExceptionCode;
            }
            block0 : switch (this.arrayOrder) {
                case ROW_MAJOR: {
                    int j2 = 0;
                    while (j2 < subarrayLength) {
                        flatArray[currentFlatArrayIndex + subarrayCount * j2] = subarray[j2];
                        ++j2;
                    }
                    ++currentFlatArrayIndex;
                    j2 = 0;
                    while (j2 < currentSubarrayIndex.length) {
                        if (currentSubarrayIndex[j2] < this.dimensions[j2] - 1) {
                            int n = j2;
                            currentSubarrayIndex[n] = currentSubarrayIndex[n] + 1;
                            break block0;
                        }
                        currentSubarrayIndex[j2] = 0;
                        ++j2;
                    }
                    break;
                }
                case COLUMN_MAJOR: {
                    int j2 = 0;
                    while (j2 < subarrayLength) {
                        flatArray[currentFlatArrayIndex++] = subarray[j2];
                        ++j2;
                    }
                    j2 = currentSubarrayIndex.length - 1;
                    while (j2 > -1) {
                        if (currentSubarrayIndex[j2] < this.dimensions[j2] - 1) {
                            int n = j2;
                            currentSubarrayIndex[n] = currentSubarrayIndex[n] + 1;
                            break block0;
                        }
                        currentSubarrayIndex[j2] = 0;
                        --j2;
                    }
                    break;
                }
                case COLUMN_MINOR: {
                    int j2 = 0;
                    while (j2 < columnCount) {
                        flatArray[currentFlatArrayIndex + rowCount * j2] = subarray[j2];
                        ++j2;
                    }
                    currentFlatArrayIndex = (i2 + 1) % rowCount == 0 ? ++matrixIndex * rowCount * columnCount : ++currentFlatArrayIndex;
                    j2 = currentSubarrayIndex.length - 1;
                    while (j2 > -1) {
                        if (currentSubarrayIndex[j2] < this.dimensions[j2] - 1) {
                            int n = j2;
                            currentSubarrayIndex[n] = currentSubarrayIndex[n] + 1;
                            break block0;
                        }
                        currentSubarrayIndex[j2] = 0;
                        --j2;
                    }
                    break;
                }
            }
            ++i2;
        }
        switch (this.arrayOrder) {
            case ROW_MAJOR: {
                break;
            }
            case COLUMN_MAJOR: {
                Utility.reverseArray(this.dimensions);
                break;
            }
            case COLUMN_MINOR: {
                int swap = this.dimensions[this.dimensions.length - 1];
                this.dimensions[this.dimensions.length - 1] = this.dimensions[this.dimensions.length - 2];
                this.dimensions[this.dimensions.length - 2] = swap;
                Utility.reverseArray(this.dimensions);
            }
        }
        this.value = new Object[]{this.dimensions, flatArray};
    }

    private void convertNdimensionalDoubleArray() {
        int flatArrayLength = this.dimensions[0];
        int i = 1;
        while (i < this.dimensions.length) {
            flatArrayLength *= this.dimensions[i];
            ++i;
        }
        double[] flatArray = new double[flatArrayLength];
        int currentFlatArrayIndex = 0;
        int subarrayLength = this.dimensions[this.dimensions.length - 1];
        int subarrayCount = 0;
        if (subarrayLength != 0) {
            subarrayCount = flatArrayLength / subarrayLength;
        }
        int[] currentSubarrayIndex = new int[this.dimensions.length - 1];
        int rowCount = this.dimensions[this.dimensions.length - 2];
        int columnCount = this.dimensions[this.dimensions.length - 1];
        int matrixIndex = 0;
        int i2 = 0;
        while (i2 < subarrayCount) {
            Object o = this.value;
            int j = 0;
            while (j < currentSubarrayIndex.length - 1) {
                o = Array.get(o, currentSubarrayIndex[j]);
                ++j;
            }
            JavaToR j2r = new JavaToR(Array.get(o, currentSubarrayIndex[currentSubarrayIndex.length - 1]), this.arrayOrder);
            double[] subarray = j2r.getValueDoubleArray1d();
            if (j2r.rDataExceptionCode != RdataExceptionCode.NONE) {
                this.rDataExceptionCode = j2r.rDataExceptionCode;
            }
            block0 : switch (this.arrayOrder) {
                case ROW_MAJOR: {
                    int j2 = 0;
                    while (j2 < subarrayLength) {
                        flatArray[currentFlatArrayIndex + subarrayCount * j2] = subarray[j2];
                        ++j2;
                    }
                    ++currentFlatArrayIndex;
                    j2 = 0;
                    while (j2 < currentSubarrayIndex.length) {
                        if (currentSubarrayIndex[j2] < this.dimensions[j2] - 1) {
                            int n = j2;
                            currentSubarrayIndex[n] = currentSubarrayIndex[n] + 1;
                            break block0;
                        }
                        currentSubarrayIndex[j2] = 0;
                        ++j2;
                    }
                    break;
                }
                case COLUMN_MAJOR: {
                    int j2 = 0;
                    while (j2 < subarrayLength) {
                        flatArray[currentFlatArrayIndex++] = subarray[j2];
                        ++j2;
                    }
                    j2 = currentSubarrayIndex.length - 1;
                    while (j2 > -1) {
                        if (currentSubarrayIndex[j2] < this.dimensions[j2] - 1) {
                            int n = j2;
                            currentSubarrayIndex[n] = currentSubarrayIndex[n] + 1;
                            break block0;
                        }
                        currentSubarrayIndex[j2] = 0;
                        --j2;
                    }
                    break;
                }
                case COLUMN_MINOR: {
                    int j2 = 0;
                    while (j2 < columnCount) {
                        flatArray[currentFlatArrayIndex + rowCount * j2] = subarray[j2];
                        ++j2;
                    }
                    currentFlatArrayIndex = (i2 + 1) % rowCount == 0 ? ++matrixIndex * rowCount * columnCount : ++currentFlatArrayIndex;
                    j2 = currentSubarrayIndex.length - 1;
                    while (j2 > -1) {
                        if (currentSubarrayIndex[j2] < this.dimensions[j2] - 1) {
                            int n = j2;
                            currentSubarrayIndex[n] = currentSubarrayIndex[n] + 1;
                            break block0;
                        }
                        currentSubarrayIndex[j2] = 0;
                        --j2;
                    }
                    break;
                }
            }
            ++i2;
        }
        switch (this.arrayOrder) {
            case ROW_MAJOR: {
                break;
            }
            case COLUMN_MAJOR: {
                Utility.reverseArray(this.dimensions);
                break;
            }
            case COLUMN_MINOR: {
                int swap = this.dimensions[this.dimensions.length - 1];
                this.dimensions[this.dimensions.length - 1] = this.dimensions[this.dimensions.length - 2];
                this.dimensions[this.dimensions.length - 2] = swap;
                Utility.reverseArray(this.dimensions);
            }
        }
        this.value = new Object[]{this.dimensions, flatArray};
    }

    private void convertNdimensionalIntArray() {
        int flatArrayLength = this.dimensions[0];
        int i = 1;
        while (i < this.dimensions.length) {
            flatArrayLength *= this.dimensions[i];
            ++i;
        }
        int[] flatArray = new int[flatArrayLength];
        int currentFlatArrayIndex = 0;
        int subarrayLength = this.dimensions[this.dimensions.length - 1];
        int subarrayCount = 0;
        if (subarrayLength != 0) {
            subarrayCount = flatArrayLength / subarrayLength;
        }
        int[] currentSubarrayIndex = new int[this.dimensions.length - 1];
        int rowCount = this.dimensions[this.dimensions.length - 2];
        int columnCount = this.dimensions[this.dimensions.length - 1];
        int matrixIndex = 0;
        int i2 = 0;
        while (i2 < subarrayCount) {
            Object o = this.value;
            int j = 0;
            while (j < currentSubarrayIndex.length - 1) {
                o = Array.get(o, currentSubarrayIndex[j]);
                ++j;
            }
            JavaToR j2r = new JavaToR(Array.get(o, currentSubarrayIndex[currentSubarrayIndex.length - 1]), this.arrayOrder);
            int[] subarray = j2r.getValueIntArray1d();
            if (j2r.rDataExceptionCode != RdataExceptionCode.NONE) {
                this.rDataExceptionCode = j2r.rDataExceptionCode;
            }
            block0 : switch (this.arrayOrder) {
                case ROW_MAJOR: {
                    int j2 = 0;
                    while (j2 < subarrayLength) {
                        flatArray[currentFlatArrayIndex + subarrayCount * j2] = subarray[j2];
                        ++j2;
                    }
                    ++currentFlatArrayIndex;
                    j2 = 0;
                    while (j2 < currentSubarrayIndex.length) {
                        if (currentSubarrayIndex[j2] < this.dimensions[j2] - 1) {
                            int n = j2;
                            currentSubarrayIndex[n] = currentSubarrayIndex[n] + 1;
                            break block0;
                        }
                        currentSubarrayIndex[j2] = 0;
                        ++j2;
                    }
                    break;
                }
                case COLUMN_MAJOR: {
                    int j2 = 0;
                    while (j2 < subarrayLength) {
                        flatArray[currentFlatArrayIndex++] = subarray[j2];
                        ++j2;
                    }
                    j2 = currentSubarrayIndex.length - 1;
                    while (j2 > -1) {
                        if (currentSubarrayIndex[j2] < this.dimensions[j2] - 1) {
                            int n = j2;
                            currentSubarrayIndex[n] = currentSubarrayIndex[n] + 1;
                            break block0;
                        }
                        currentSubarrayIndex[j2] = 0;
                        --j2;
                    }
                    break;
                }
                case COLUMN_MINOR: {
                    int j2 = 0;
                    while (j2 < columnCount) {
                        flatArray[currentFlatArrayIndex + rowCount * j2] = subarray[j2];
                        ++j2;
                    }
                    currentFlatArrayIndex = (i2 + 1) % rowCount == 0 ? ++matrixIndex * rowCount * columnCount : ++currentFlatArrayIndex;
                    j2 = currentSubarrayIndex.length - 1;
                    while (j2 > -1) {
                        if (currentSubarrayIndex[j2] < this.dimensions[j2] - 1) {
                            int n = j2;
                            currentSubarrayIndex[n] = currentSubarrayIndex[n] + 1;
                            break block0;
                        }
                        currentSubarrayIndex[j2] = 0;
                        --j2;
                    }
                    break;
                }
            }
            ++i2;
        }
        switch (this.arrayOrder) {
            case ROW_MAJOR: {
                break;
            }
            case COLUMN_MAJOR: {
                Utility.reverseArray(this.dimensions);
                break;
            }
            case COLUMN_MINOR: {
                int swap = this.dimensions[this.dimensions.length - 1];
                this.dimensions[this.dimensions.length - 1] = this.dimensions[this.dimensions.length - 2];
                this.dimensions[this.dimensions.length - 2] = swap;
                Utility.reverseArray(this.dimensions);
            }
        }
        this.value = new Object[]{this.dimensions, flatArray};
    }

    private void convertNdimensionalStringArray() {
        int flatArrayLength = this.dimensions[0];
        int i = 1;
        while (i < this.dimensions.length) {
            flatArrayLength *= this.dimensions[i];
            ++i;
        }
        String[] flatArray = new String[flatArrayLength];
        int currentFlatArrayIndex = 0;
        int subarrayLength = this.dimensions[this.dimensions.length - 1];
        int subarrayCount = 0;
        if (subarrayLength != 0) {
            subarrayCount = flatArrayLength / subarrayLength;
        }
        int[] currentSubarrayIndex = new int[this.dimensions.length - 1];
        int rowCount = this.dimensions[this.dimensions.length - 2];
        int columnCount = this.dimensions[this.dimensions.length - 1];
        int matrixIndex = 0;
        int i2 = 0;
        while (i2 < subarrayCount) {
            Object o = this.value;
            int j = 0;
            while (j < currentSubarrayIndex.length - 1) {
                o = Array.get(o, currentSubarrayIndex[j]);
                ++j;
            }
            JavaToR j2r = new JavaToR(Array.get(o, currentSubarrayIndex[currentSubarrayIndex.length - 1]), this.arrayOrder);
            String[] subarray = j2r.getValueStringArray1d();
            if (j2r.rDataExceptionCode != RdataExceptionCode.NONE) {
                this.rDataExceptionCode = j2r.rDataExceptionCode;
            }
            block0 : switch (this.arrayOrder) {
                case ROW_MAJOR: {
                    int j2 = 0;
                    while (j2 < subarrayLength) {
                        flatArray[currentFlatArrayIndex + subarrayCount * j2] = subarray[j2];
                        ++j2;
                    }
                    ++currentFlatArrayIndex;
                    j2 = 0;
                    while (j2 < currentSubarrayIndex.length) {
                        if (currentSubarrayIndex[j2] < this.dimensions[j2] - 1) {
                            int n = j2;
                            currentSubarrayIndex[n] = currentSubarrayIndex[n] + 1;
                            break block0;
                        }
                        currentSubarrayIndex[j2] = 0;
                        ++j2;
                    }
                    break;
                }
                case COLUMN_MAJOR: {
                    int j2 = 0;
                    while (j2 < subarrayLength) {
                        flatArray[currentFlatArrayIndex++] = subarray[j2];
                        ++j2;
                    }
                    j2 = currentSubarrayIndex.length - 1;
                    while (j2 > -1) {
                        if (currentSubarrayIndex[j2] < this.dimensions[j2] - 1) {
                            int n = j2;
                            currentSubarrayIndex[n] = currentSubarrayIndex[n] + 1;
                            break block0;
                        }
                        currentSubarrayIndex[j2] = 0;
                        --j2;
                    }
                    break;
                }
                case COLUMN_MINOR: {
                    int j2 = 0;
                    while (j2 < columnCount) {
                        flatArray[currentFlatArrayIndex + rowCount * j2] = subarray[j2];
                        ++j2;
                    }
                    currentFlatArrayIndex = (i2 + 1) % rowCount == 0 ? ++matrixIndex * rowCount * columnCount : ++currentFlatArrayIndex;
                    j2 = currentSubarrayIndex.length - 1;
                    while (j2 > -1) {
                        if (currentSubarrayIndex[j2] < this.dimensions[j2] - 1) {
                            int n = j2;
                            currentSubarrayIndex[n] = currentSubarrayIndex[n] + 1;
                            break block0;
                        }
                        currentSubarrayIndex[j2] = 0;
                        --j2;
                    }
                    break;
                }
            }
            ++i2;
        }
        switch (this.arrayOrder) {
            case ROW_MAJOR: {
                break;
            }
            case COLUMN_MAJOR: {
                Utility.reverseArray(this.dimensions);
                break;
            }
            case COLUMN_MINOR: {
                int swap = this.dimensions[this.dimensions.length - 1];
                this.dimensions[this.dimensions.length - 1] = this.dimensions[this.dimensions.length - 2];
                this.dimensions[this.dimensions.length - 2] = swap;
                Utility.reverseArray(this.dimensions);
            }
        }
        this.value = new Object[]{this.dimensions, flatArray};
    }

    private void convertScriptObjectMirror() {
        ScriptObjectMirror som = (ScriptObjectMirror)this.value;
        if (som.isArray()) {
            this.initializeFrom(new JavaToR((Object)som.values(), this.arrayOrder));
        } else if (som.isFunction() || som.isStrictFunction()) {
            this.rDataTypeCode = RdataTypeCode.NULL;
            this.rDataStructureCode = RdataStructureCode.SCALAR;
            this.rDataExceptionCode = RdataExceptionCode.NONE;
            this.value = null;
        } else {
            this.convertMap();
        }
    }

    private void convertSimpleStructure(Class<?> cls) {
        if (cls.isPrimitive()) {
            if (cls.equals(Double.TYPE)) {
                this.rDataTypeCode = RdataTypeCode.NUMERIC;
                if (this.rDataStructureCode == RdataStructureCode.ND_ARRAY) {
                    this.convertNdimensionalDoubleArray();
                }
                return;
            }
            if (cls.equals(Integer.TYPE)) {
                this.rDataTypeCode = RdataTypeCode.INTEGER;
                if (this.rDataStructureCode == RdataStructureCode.ND_ARRAY) {
                    this.convertNdimensionalIntArray();
                }
                return;
            }
            if (cls.equals(Boolean.TYPE)) {
                this.rDataTypeCode = RdataTypeCode.LOGICAL;
                if (this.rDataStructureCode == RdataStructureCode.ND_ARRAY) {
                    this.convertNdimensionalBooleanArray();
                }
                return;
            }
            if (cls.equals(Byte.TYPE)) {
                this.rDataTypeCode = RdataTypeCode.RAW;
                if (this.rDataStructureCode == RdataStructureCode.ND_ARRAY) {
                    this.convertNdimensionalByteArray();
                }
                return;
            }
            if (cls.equals(Float.TYPE)) {
                this.rDataTypeCode = RdataTypeCode.NUMERIC;
                if (this.rDataStructureCode == RdataStructureCode.VECTOR) {
                    this.value = this.coerceToDoubleArray1D((float[])this.value);
                } else if (this.rDataStructureCode == RdataStructureCode.ND_ARRAY) {
                    this.convertNdimensionalDoubleArray();
                }
                return;
            }
            if (cls.equals(Long.TYPE)) {
                this.rDataTypeCode = RdataTypeCode.NUMERIC;
                if (this.rDataStructureCode == RdataStructureCode.VECTOR) {
                    this.value = this.coerceToDoubleArray1D((long[])this.value);
                } else if (this.rDataStructureCode == RdataStructureCode.ND_ARRAY) {
                    this.convertNdimensionalDoubleArray();
                }
                return;
            }
            if (cls.equals(Short.TYPE)) {
                this.rDataTypeCode = RdataTypeCode.INTEGER;
                if (this.rDataStructureCode == RdataStructureCode.VECTOR) {
                    this.value = this.coerceToIntegerArray1D((short[])this.value);
                } else if (this.rDataStructureCode == RdataStructureCode.ND_ARRAY) {
                    this.convertNdimensionalIntArray();
                }
                return;
            }
            if (cls.equals(Character.TYPE)) {
                this.rDataTypeCode = RdataTypeCode.CHARACTER;
                if (this.rDataStructureCode == RdataStructureCode.SCALAR) {
                    this.value = Character.toString(((Character)this.value).charValue());
                } else if (this.rDataStructureCode == RdataStructureCode.VECTOR) {
                    this.value = this.coerceToStringArray1D((char[])this.value);
                } else if (this.rDataStructureCode == RdataStructureCode.ND_ARRAY) {
                    this.convertNdimensionalStringArray();
                }
                return;
            }
        }
        if (Number.class.isAssignableFrom(cls)) {
            if (cls.equals(Double.class)) {
                this.rDataTypeCode = RdataTypeCode.NUMERIC;
                if (this.rDataStructureCode == RdataStructureCode.VECTOR) {
                    this.value = this.unboxArray1D((Double[])this.value);
                } else if (this.rDataStructureCode == RdataStructureCode.ND_ARRAY) {
                    this.convertNdimensionalDoubleArray();
                }
                return;
            }
            if (cls.equals(Integer.class)) {
                this.rDataTypeCode = RdataTypeCode.INTEGER;
                if (this.rDataStructureCode == RdataStructureCode.VECTOR) {
                    this.value = this.unboxArray1D((Integer[])this.value);
                } else if (this.rDataStructureCode == RdataStructureCode.ND_ARRAY) {
                    this.convertNdimensionalIntArray();
                }
                return;
            }
            if (cls.equals(Byte.class)) {
                this.rDataTypeCode = RdataTypeCode.RAW;
                if (this.rDataStructureCode == RdataStructureCode.VECTOR) {
                    this.value = this.unboxArray1D((Byte[])this.value);
                } else if (this.rDataStructureCode == RdataStructureCode.ND_ARRAY) {
                    this.convertNdimensionalByteArray();
                }
                return;
            }
            if (cls.equals(Float.class)) {
                this.rDataTypeCode = RdataTypeCode.NUMERIC;
                if (this.rDataStructureCode == RdataStructureCode.SCALAR) {
                    this.value = ((Float)this.value).doubleValue();
                } else if (this.rDataStructureCode == RdataStructureCode.VECTOR) {
                    this.value = this.coerceToDoubleArray1D((Float[])this.value);
                } else if (this.rDataStructureCode == RdataStructureCode.ND_ARRAY) {
                    this.convertNdimensionalDoubleArray();
                }
                return;
            }
            if (cls.equals(Long.class)) {
                this.rDataTypeCode = RdataTypeCode.NUMERIC;
                if (this.rDataStructureCode == RdataStructureCode.SCALAR) {
                    this.value = ((Long)this.value).doubleValue();
                } else if (this.rDataStructureCode == RdataStructureCode.VECTOR) {
                    this.value = this.coerceToDoubleArray1D((Long[])this.value);
                } else if (this.rDataStructureCode == RdataStructureCode.ND_ARRAY) {
                    this.convertNdimensionalDoubleArray();
                }
                return;
            }
            if (cls.equals(Short.class)) {
                this.rDataTypeCode = RdataTypeCode.INTEGER;
                if (this.rDataStructureCode == RdataStructureCode.SCALAR) {
                    this.value = ((Short)this.value).intValue();
                } else if (this.rDataStructureCode == RdataStructureCode.VECTOR) {
                    this.value = this.coerceToIntegerArray1D((Short[])this.value);
                } else if (this.rDataStructureCode == RdataStructureCode.ND_ARRAY) {
                    this.convertNdimensionalIntArray();
                }
                return;
            }
            if (cls.equals(BigDecimal.class)) {
                this.rDataTypeCode = RdataTypeCode.NUMERIC;
                if (this.rDataStructureCode == RdataStructureCode.SCALAR) {
                    this.value = ((BigDecimal)this.value).doubleValue();
                } else if (this.rDataStructureCode == RdataStructureCode.VECTOR) {
                    this.value = this.coerceToDoubleArray1D((BigDecimal[])this.value);
                } else if (this.rDataStructureCode == RdataStructureCode.ND_ARRAY) {
                    this.convertNdimensionalDoubleArray();
                }
                return;
            }
            if (cls.equals(BigInteger.class)) {
                this.rDataTypeCode = RdataTypeCode.NUMERIC;
                if (this.rDataStructureCode == RdataStructureCode.SCALAR) {
                    this.value = ((BigInteger)this.value).doubleValue();
                } else if (this.rDataStructureCode == RdataStructureCode.VECTOR) {
                    this.value = this.coerceToDoubleArray1D((BigInteger[])this.value);
                } else if (this.rDataStructureCode == RdataStructureCode.ND_ARRAY) {
                    this.convertNdimensionalDoubleArray();
                }
                return;
            }
        }
        if (cls.equals(String.class)) {
            this.rDataTypeCode = RdataTypeCode.CHARACTER;
            if (this.rDataStructureCode == RdataStructureCode.ND_ARRAY) {
                this.convertNdimensionalStringArray();
            }
            return;
        }
        if (cls.equals(Boolean.class)) {
            this.rDataTypeCode = RdataTypeCode.LOGICAL;
            if (this.rDataStructureCode == RdataStructureCode.VECTOR) {
                this.value = this.unboxArray1D((Boolean[])this.value);
            } else if (this.rDataStructureCode == RdataStructureCode.ND_ARRAY) {
                this.convertNdimensionalBooleanArray();
            }
            return;
        }
        if (cls.equals(Character.class)) {
            this.rDataTypeCode = RdataTypeCode.CHARACTER;
            if (this.rDataStructureCode == RdataStructureCode.SCALAR) {
                this.value = ((Character)this.value).toString();
            } else if (this.rDataStructureCode == RdataStructureCode.VECTOR) {
                this.value = this.coerceToStringArray1D((Character[])this.value);
            } else if (this.rDataStructureCode == RdataStructureCode.ND_ARRAY) {
                this.convertNdimensionalStringArray();
            }
            return;
        }
        this.rDataTypeCode = RdataTypeCode.UNSUPPORTED;
    }

    public ArrayOrder getArrayOrder() {
        return this.arrayOrder;
    }

    public int[] getDimensions() {
        return this.dimensions;
    }

    public int getRdataCompositeCode() {
        return this.rDataTypeCode.value | this.rDataStructureCode.value | this.rDataExceptionCode.value | this.rDataUserDefinedCode;
    }

    public RdataExceptionCode getRdataExceptionCode() {
        return this.rDataExceptionCode;
    }

    public RdataStructureCode getRdataStructureCode() {
        return this.rDataStructureCode;
    }

    public RdataTypeCode getRdataTypeCode() {
        return this.rDataTypeCode;
    }

    public int getRdataUserDefinedCode() {
        return this.rDataUserDefinedCode;
    }

    public boolean getValueBoolean() {
        return (Boolean)this.value;
    }

    public boolean[] getValueBooleanArray1d() {
        return (boolean[])this.value;
    }

    public byte getValueByte() {
        return (Byte)this.value;
    }

    public byte[] getValueByteArray1d() {
        return (byte[])this.value;
    }

    public double getValueDouble() {
        return (Double)this.value;
    }

    public double[] getValueDoubleArray1d() {
        return (double[])this.value;
    }

    public int getValueInt() {
        return (Integer)this.value;
    }

    public int[] getValueIntArray1d() {
        return (int[])this.value;
    }

    public Object getValueObject() {
        return this.value;
    }

    public Object[] getValueObjectArray1d() {
        return (Object[])this.value;
    }

    public String getValueString() {
        return this.value.toString();
    }

    public String[] getValueStringArray1d() {
        return (String[])this.value;
    }

    public int initialize(Object value) {
        return this.initialize(value, ArrayOrder.ROW_MAJOR);
    }

    public int initialize(Object value, ArrayOrder arrayOrder) {
        this.arrayOrder = arrayOrder;
        this.dimensions = null;
        this.isNamedListOfScalars = false;
        this.rDataExceptionCode = RdataExceptionCode.NONE;
        this.rDataTypeCode = RdataTypeCode.UNSUPPORTED;
        this.rDataStructureCode = RdataStructureCode.SCALAR;
        this.rDataUserDefinedCode = 0;
        this.value = value;
        if (value == null) {
            this.rDataTypeCode = RdataTypeCode.NULL;
            this.rDataStructureCode = RdataStructureCode.SCALAR;
            return this.getRdataCompositeCode();
        }
        Class<?> cls = value.getClass();
        if (cls.isArray()) {
            this.dimensions = Utility.getRectangularArrayDimensions(value);
            if (this.dimensions == null) {
                this.value = Arrays.asList((Object[])value);
                this.convertCollection();
                return this.getRdataCompositeCode();
            }
            this.rDataStructureCode = this.dimensions.length == 1 ? RdataStructureCode.VECTOR : RdataStructureCode.ND_ARRAY;
            this.convertSimpleStructure(Utility.getArrayBaseComponentType(cls));
            if (this.rDataTypeCode != RdataTypeCode.UNSUPPORTED) {
                return this.getRdataCompositeCode();
            }
            this.dimensions = null;
            this.value = Arrays.asList((Object[])value);
            this.convertCollection();
            return this.getRdataCompositeCode();
        }
        this.rDataStructureCode = RdataStructureCode.SCALAR;
        this.convertSimpleStructure(cls);
        if (this.rDataTypeCode != RdataTypeCode.UNSUPPORTED) {
            return this.getRdataCompositeCode();
        }
        if (Map.class.isAssignableFrom(cls)) {
            if (ScriptObjectMirror.class.isAssignableFrom(cls)) {
                this.convertScriptObjectMirror();
            } else {
                this.convertMap();
            }
            return this.getRdataCompositeCode();
        }
        if (Collection.class.isAssignableFrom(cls)) {
            this.convertCollection();
            return this.getRdataCompositeCode();
        }
        if (Throwable.class.isAssignableFrom(cls)) {
            this.rDataTypeCode = RdataTypeCode.OTHER;
            this.rDataExceptionCode = RdataExceptionCode.EXCEPTION;
            return this.getRdataCompositeCode();
        }
        throw new RuntimeException(String.format("Java class '%s' cannot be converted to an R object.", cls.getName()));
    }

    public int initialize(Object value, int rDataUserDefinedCode) {
        if (rDataUserDefinedCode < 0x1000000) {
            throw new RuntimeException("User defined data codes are between 0x01000000 and 0x7FFFFFFF.");
        }
        this.arrayOrder = ArrayOrder.ROW_MAJOR;
        this.dimensions = null;
        this.isNamedListOfScalars = false;
        this.rDataExceptionCode = RdataExceptionCode.NONE;
        this.rDataTypeCode = RdataTypeCode.OTHER;
        this.rDataStructureCode = RdataStructureCode.USER_DEFINED;
        this.rDataUserDefinedCode = rDataUserDefinedCode;
        this.value = value;
        return this.getRdataCompositeCode();
    }

    public int initializeFrom(JavaToR j2r) {
        this.arrayOrder = j2r.arrayOrder;
        this.dimensions = j2r.dimensions;
        this.isNamedListOfScalars = j2r.isNamedListOfScalars;
        this.rDataExceptionCode = j2r.rDataExceptionCode;
        this.rDataTypeCode = j2r.rDataTypeCode;
        this.rDataStructureCode = j2r.rDataStructureCode;
        this.rDataUserDefinedCode = j2r.rDataUserDefinedCode;
        this.value = j2r.value;
        return this.getRdataCompositeCode();
    }

    private boolean[] unboxArray1D(Boolean[] a) {
        if (a == null) {
            return null;
        }
        boolean[] b = new boolean[a.length];
        int i = 0;
        while (i < b.length) {
            if (a[i] == null) {
                b[i] = false;
                this.rDataExceptionCode = RdataExceptionCode.WARNING_MISSING_LOGICAL_VALUES;
            } else {
                b[i] = a[i];
            }
            ++i;
        }
        return b;
    }

    private byte[] unboxArray1D(Byte[] a) {
        if (a == null) {
            return null;
        }
        byte[] b = new byte[a.length];
        int i = 0;
        while (i < b.length) {
            if (a[i] == null) {
                b[i] = 0;
                this.rDataExceptionCode = RdataExceptionCode.WARNING_MISSING_RAW_VALUES;
            } else {
                b[i] = a[i];
            }
            ++i;
        }
        return b;
    }

    private double[] unboxArray1D(Double[] a) {
        if (a == null) {
            return null;
        }
        double[] b = new double[a.length];
        int i = 0;
        while (i < b.length) {
            b[i] = a[i] == null ? NA_DOUBLE : a[i];
            ++i;
        }
        return b;
    }

    private int[] unboxArray1D(Integer[] a) {
        if (a == null) {
            return null;
        }
        int[] b = new int[a.length];
        int i = 0;
        while (i < b.length) {
            b[i] = a[i] == null ? Integer.MIN_VALUE : a[i];
            ++i;
        }
        return b;
    }

    public static enum ArrayOrder {
        COLUMN_MAJOR,
        COLUMN_MINOR,
        ROW_MAJOR;

    }

    private class MaybeNdimensionalArray {
        private int[] subarrayDimensions;
        private RdataTypeCode typeCode;
        private boolean value = false;

        MaybeNdimensionalArray(int collectionSize, JavaToR j2r) {
            if (collectionSize == 0) {
                return;
            }
            switch (j2r.getRdataStructureCode()) {
                case VECTOR: 
                case ND_ARRAY: {
                    this.value = true;
                    break;
                }
                default: {
                    return;
                }
            }
            this.subarrayDimensions = j2r.getDimensions();
            this.typeCode = j2r.getRdataTypeCode();
        }

        int[] getSubarrayDimensions() {
            return this.subarrayDimensions;
        }

        RdataTypeCode getTypeCode() {
            return this.typeCode;
        }

        boolean getValue() {
            return this.value;
        }

        boolean update(JavaToR j2r) {
            if (!this.value) {
                return false;
            }
            switch (j2r.getRdataStructureCode()) {
                case VECTOR: 
                case ND_ARRAY: {
                    this.value = Arrays.equals(this.subarrayDimensions, j2r.getDimensions());
                    break;
                }
                default: {
                    this.value = false;
                }
            }
            if (!this.value) {
                return false;
            }
            if (this.typeCode != j2r.getRdataTypeCode() && (this.typeCode != RdataTypeCode.NUMERIC || j2r.getRdataTypeCode() != RdataTypeCode.INTEGER && j2r.getRdataTypeCode() != RdataTypeCode.RAW)) {
                if ((this.typeCode == RdataTypeCode.INTEGER || this.typeCode == RdataTypeCode.RAW) && j2r.getRdataTypeCode() == RdataTypeCode.NUMERIC) {
                    this.typeCode = RdataTypeCode.NUMERIC;
                } else if (this.typeCode != RdataTypeCode.INTEGER || j2r.getRdataTypeCode() != RdataTypeCode.RAW) {
                    if (this.typeCode == RdataTypeCode.RAW && j2r.getRdataTypeCode() == RdataTypeCode.INTEGER) {
                        this.typeCode = RdataTypeCode.INTEGER;
                    } else {
                        this.value = false;
                    }
                }
            }
            return this.value;
        }
    }

    private class MaybeRowMajorDataFrame {
        final int compositeTypeScalarCharacter;
        final int compositeTypeScalarInteger;
        final int compositeTypeScalarNull;
        final int compositeTypeScalarNumeric;
        final int compositeTypeScalarRaw;
        private int[] compositeTypes;
        private String[] names;
        private boolean value;

        MaybeRowMajorDataFrame(JavaToR j2r) {
            this.compositeTypeScalarCharacter = RdataStructureCode.SCALAR.value | RdataTypeCode.CHARACTER.value;
            this.compositeTypeScalarInteger = RdataStructureCode.SCALAR.value | RdataTypeCode.INTEGER.value;
            this.compositeTypeScalarNull = RdataStructureCode.SCALAR.value | RdataTypeCode.NULL.value;
            this.compositeTypeScalarNumeric = RdataStructureCode.SCALAR.value | RdataTypeCode.NUMERIC.value;
            this.compositeTypeScalarRaw = RdataStructureCode.SCALAR.value | RdataTypeCode.RAW.value;
            this.value = false;
            if (!j2r.isNamedListOfScalars) {
                return;
            }
            this.value = true;
            Object[] o = j2r.getValueObjectArray1d();
            this.compositeTypes = (int[])o[0];
            this.compositeTypes = Arrays.stream(this.compositeTypes).map(i -> {
                if (i == this.compositeTypeScalarNull) {
                    return this.compositeTypeScalarCharacter;
                }
                return i;
            }).toArray();
            this.names = (String[])o[2];
        }

        int[] getCompositeTypes() {
            return this.compositeTypes;
        }

        String[] getNames() {
            return this.names;
        }

        boolean getValue() {
            return this.value;
        }

        boolean update(JavaToR j2r) {
            if (!this.value) {
                return false;
            }
            this.value = false;
            if (!j2r.isNamedListOfScalars) {
                return false;
            }
            Object[] o = j2r.getValueObjectArray1d();
            int[] currentCompositeTypes = (int[])o[0];
            if (currentCompositeTypes.length != this.compositeTypes.length) {
                return false;
            }
            int i = 0;
            while (i < currentCompositeTypes.length) {
                if (currentCompositeTypes[i] != this.compositeTypes[i] && (this.compositeTypes[i] != this.compositeTypeScalarNumeric || currentCompositeTypes[i] != this.compositeTypeScalarInteger && currentCompositeTypes[i] != this.compositeTypeScalarRaw)) {
                    if ((this.compositeTypes[i] == this.compositeTypeScalarInteger || this.compositeTypes[i] == this.compositeTypeScalarRaw) && currentCompositeTypes[i] == this.compositeTypeScalarNumeric) {
                        this.compositeTypes[i] = this.compositeTypeScalarNumeric;
                    } else if (this.compositeTypes[i] != this.compositeTypeScalarInteger || currentCompositeTypes[i] != this.compositeTypeScalarRaw) {
                        if (this.compositeTypes[i] == this.compositeTypeScalarRaw && currentCompositeTypes[i] == this.compositeTypeScalarInteger) {
                            this.compositeTypes[i] = this.compositeTypeScalarInteger;
                        } else if (this.compositeTypes[i] != this.compositeTypeScalarCharacter || currentCompositeTypes[i] != this.compositeTypeScalarNull) {
                            return false;
                        }
                    }
                }
                ++i;
            }
            if (!Arrays.equals(this.names, (String[])o[2])) {
                return false;
            }
            this.value = true;
            return true;
        }
    }

    public static enum RdataExceptionCode {
        NONE(0),
        EXCEPTION(65536),
        WARNING_MISSING_LOGICAL_VALUES(655360),
        WARNING_MISSING_RAW_VALUES(720896);

        final int value;

        private RdataExceptionCode(int value) {
            this.value = value;
        }
    }

    public static enum RdataStructureCode {
        SCALAR(0),
        VECTOR(256),
        ND_ARRAY(512),
        DATA_FRAME(768),
        LIST(1024),
        NAMED_LIST(1280),
        USER_DEFINED(65280);

        final int value;

        private RdataStructureCode(int value) {
            this.value = value;
        }
    }

    public static enum RdataTypeCode {
        NULL(0),
        NUMERIC(1),
        INTEGER(2),
        CHARACTER(3),
        LOGICAL(4),
        RAW(5),
        OTHER(254),
        UNSUPPORTED(255);

        final int value;

        private RdataTypeCode(int value) {
            this.value = value;
        }
    }
}

