// Generated by rstantools.  Do not edit by hand.

/*
    jfa is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    jfa is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with jfa.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#ifndef USE_STANC3
#define USE_STANC3
#endif
#include <rstan/rstaninc.hpp>
// Code generated by stanc v2.26.1-4-gd72b68b7-dirty
#include <stan/model/model_header.hpp>
namespace model_pp_taint_namespace {
inline void validate_positive_index(const char* var_name, const char* expr,
                                    int val) {
  if (val < 1) {
    std::stringstream msg;
    msg << "Found dimension size less than one in simplex declaration"
        << "; variable=" << var_name << "; dimension size expression=" << expr
        << "; expression value=" << val;
    std::string msg_str(msg.str());
    throw std::invalid_argument(msg_str.c_str());
  }
}
inline void validate_unit_vector_index(const char* var_name, const char* expr,
                                       int val) {
  if (val <= 1) {
    std::stringstream msg;
    if (val == 1) {
      msg << "Found dimension size one in unit vector declaration."
          << " One-dimensional unit vector is discrete"
          << " but the target distribution must be continuous."
          << " variable=" << var_name << "; dimension size expression=" << expr;
    } else {
      msg << "Found dimension size less than one in unit vector declaration"
          << "; variable=" << var_name << "; dimension size expression=" << expr
          << "; expression value=" << val;
    }
    std::string msg_str(msg.str());
    throw std::invalid_argument(msg_str.c_str());
  }
}
using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using std::pow;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::model_base_crtp;
using stan::model::rvalue;
using stan::model::cons_list;
using stan::model::index_uni;
using stan::model::index_max;
using stan::model::index_min;
using stan::model::index_min_max;
using stan::model::index_multi;
using stan::model::index_omni;
using stan::model::nil_index_list;
using namespace stan::math;
using stan::math::pow; 
stan::math::profile_map profiles__;
static int current_statement__= 0;
static const std::vector<string> locations_array__ = {" (found before start of program)",
                                                      " (in 'pp_taint', line 34, column 2 to column 29)",
                                                      " (in 'pp_taint', line 35, column 2 to column 19)",
                                                      " (in 'pp_taint', line 36, column 2 to column 19)",
                                                      " (in 'pp_taint', line 37, column 2 to column 22)",
                                                      " (in 'pp_taint', line 38, column 2 to column 38)",
                                                      " (in 'pp_taint', line 39, column 2 to column 29)",
                                                      " (in 'pp_taint', line 58, column 4 to column 29)",
                                                      " (in 'pp_taint', line 57, column 32 to line 59, column 3)",
                                                      " (in 'pp_taint', line 57, column 9 to line 59, column 3)",
                                                      " (in 'pp_taint', line 56, column 4 to column 28)",
                                                      " (in 'pp_taint', line 55, column 26 to line 57, column 3)",
                                                      " (in 'pp_taint', line 55, column 9 to line 59, column 3)",
                                                      " (in 'pp_taint', line 54, column 4 to column 33)",
                                                      " (in 'pp_taint', line 53, column 22 to line 55, column 3)",
                                                      " (in 'pp_taint', line 53, column 9 to line 59, column 3)",
                                                      " (in 'pp_taint', line 52, column 4 to column 30)",
                                                      " (in 'pp_taint', line 51, column 27 to line 53, column 3)",
                                                      " (in 'pp_taint', line 51, column 9 to line 59, column 3)",
                                                      " (in 'pp_taint', line 50, column 4 to column 31)",
                                                      " (in 'pp_taint', line 49, column 28 to line 51, column 3)",
                                                      " (in 'pp_taint', line 49, column 9 to line 59, column 3)",
                                                      " (in 'pp_taint', line 48, column 4 to column 30)",
                                                      " (in 'pp_taint', line 47, column 27 to line 49, column 3)",
                                                      " (in 'pp_taint', line 47, column 9 to line 59, column 3)",
                                                      " (in 'pp_taint', line 46, column 4 to column 29)",
                                                      " (in 'pp_taint', line 45, column 26 to line 47, column 3)",
                                                      " (in 'pp_taint', line 45, column 9 to line 59, column 3)",
                                                      " (in 'pp_taint', line 44, column 4 to column 28)",
                                                      " (in 'pp_taint', line 43, column 18 to line 45, column 3)",
                                                      " (in 'pp_taint', line 43, column 2 to line 59, column 3)",
                                                      " (in 'pp_taint', line 60, column 2 to column 22)",
                                                      " (in 'pp_taint', line 61, column 2 to column 22)",
                                                      " (in 'pp_taint', line 62, column 2 to column 24)",
                                                      " (in 'pp_taint', line 64, column 2 to column 43)",
                                                      " (in 'pp_taint', line 65, column 2 to column 30)",
                                                      " (in 'pp_taint', line 68, column 4 to column 48)",
                                                      " (in 'pp_taint', line 67, column 22 to line 69, column 3)",
                                                      " (in 'pp_taint', line 67, column 2 to line 69, column 3)",
                                                      " (in 'pp_taint', line 17, column 2 to column 17)",
                                                      " (in 'pp_taint', line 18, column 2 to column 17)",
                                                      " (in 'pp_taint', line 19, column 8 to column 9)",
                                                      " (in 'pp_taint', line 19, column 2 to column 26)",
                                                      " (in 'pp_taint', line 20, column 8 to column 9)",
                                                      " (in 'pp_taint', line 20, column 2 to column 36)",
                                                      " (in 'pp_taint', line 21, column 2 to column 22)",
                                                      " (in 'pp_taint', line 22, column 2 to column 21)",
                                                      " (in 'pp_taint', line 23, column 2 to column 17)",
                                                      " (in 'pp_taint', line 24, column 2 to column 18)",
                                                      " (in 'pp_taint', line 25, column 2 to column 19)",
                                                      " (in 'pp_taint', line 26, column 2 to column 20)",
                                                      " (in 'pp_taint', line 27, column 2 to column 19)",
                                                      " (in 'pp_taint', line 28, column 2 to column 14)",
                                                      " (in 'pp_taint', line 29, column 2 to column 18)",
                                                      " (in 'pp_taint', line 30, column 2 to column 24)",
                                                      " (in 'pp_taint', line 31, column 2 to column 21)",
                                                      " (in 'pp_taint', line 38, column 27 to column 28)",
                                                      " (in 'pp_taint', line 39, column 18 to column 19)"};
#include <stan_meta_header.hpp>
class model_pp_taint final : public model_base_crtp<model_pp_taint> {
private:
  int S;
  int n;
  std::vector<int> s;
  std::vector<double> t;
  double alpha;
  double beta;
  int beta_prior;
  int gamma_prior;
  int normal_prior;
  int uniform_prior;
  int cauchy_prior;
  int t_prior;
  int chisq_prior;
  int exponential_prior;
  int use_likelihood;
 
public:
  ~model_pp_taint() { }
  
  inline std::string model_name() const final { return "model_pp_taint"; }
  inline std::vector<std::string> model_compile_info() const noexcept {
    return std::vector<std::string>{"stanc_version = stanc3 v2.26.1-4-gd72b68b7-dirty", "stancflags = "};
  }
  
  
  model_pp_taint(stan::io::var_context& context__,
                 unsigned int random_seed__ = 0,
                 std::ostream* pstream__ = nullptr) : model_base_crtp(0) {
    using local_scalar_t__ = double ;
    boost::ecuyer1988 base_rng__ = 
        stan::services::util::create_rng(random_seed__, 0);
    (void) base_rng__;  // suppress unused var warning
    static const char* function__ = "model_pp_taint_namespace::model_pp_taint";
    (void) function__;  // suppress unused var warning
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    (void) DUMMY_VAR__;  // suppress unused var warning
    
    try {
      int pos__;
      pos__ = std::numeric_limits<int>::min();
      
      pos__ = 1;
      current_statement__ = 39;
      context__.validate_dims("data initialization","S","int",
          context__.to_vec());
      S = std::numeric_limits<int>::min();
      
      current_statement__ = 39;
      S = context__.vals_i("S")[(1 - 1)];
      current_statement__ = 39;
      current_statement__ = 39;
      check_greater_or_equal(function__, "S", S, 1);
      current_statement__ = 40;
      context__.validate_dims("data initialization","n","int",
          context__.to_vec());
      n = std::numeric_limits<int>::min();
      
      current_statement__ = 40;
      n = context__.vals_i("n")[(1 - 1)];
      current_statement__ = 40;
      current_statement__ = 40;
      check_greater_or_equal(function__, "n", n, 0);
      current_statement__ = 41;
      validate_non_negative_index("s", "n", n);
      current_statement__ = 42;
      context__.validate_dims("data initialization","s","int",
          context__.to_vec(n));
      s = std::vector<int>(n, std::numeric_limits<int>::min());
      
      current_statement__ = 42;
      assign(s, nil_index_list(), context__.vals_i("s"),
        "assigning variable s");
      current_statement__ = 42;
      for (int sym1__ = 1; sym1__ <= n; ++sym1__) {
        current_statement__ = 42;
        current_statement__ = 42;
        check_greater_or_equal(function__, "s[sym1__]", s[(sym1__ - 1)], 1);}
      current_statement__ = 43;
      validate_non_negative_index("t", "n", n);
      current_statement__ = 44;
      context__.validate_dims("data initialization","t","double",
          context__.to_vec(n));
      t = std::vector<double>(n, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 44;
      assign(t, nil_index_list(), context__.vals_r("t"),
        "assigning variable t");
      current_statement__ = 44;
      for (int sym1__ = 1; sym1__ <= n; ++sym1__) {
        current_statement__ = 44;
        current_statement__ = 44;
        check_greater_or_equal(function__, "t[sym1__]", t[(sym1__ - 1)], 0);}
      current_statement__ = 44;
      for (int sym1__ = 1; sym1__ <= n; ++sym1__) {
        current_statement__ = 44;
        current_statement__ = 44;
        check_less_or_equal(function__, "t[sym1__]", t[(sym1__ - 1)], 1);}
      current_statement__ = 45;
      context__.validate_dims("data initialization","alpha","double",
          context__.to_vec());
      alpha = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 45;
      alpha = context__.vals_r("alpha")[(1 - 1)];
      current_statement__ = 45;
      current_statement__ = 45;
      check_greater_or_equal(function__, "alpha", alpha, 0);
      current_statement__ = 46;
      context__.validate_dims("data initialization","beta","double",
          context__.to_vec());
      beta = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 46;
      beta = context__.vals_r("beta")[(1 - 1)];
      current_statement__ = 46;
      current_statement__ = 46;
      check_greater_or_equal(function__, "beta", beta, 0);
      current_statement__ = 47;
      context__.validate_dims("data initialization","beta_prior","int",
          context__.to_vec());
      beta_prior = std::numeric_limits<int>::min();
      
      current_statement__ = 47;
      beta_prior = context__.vals_i("beta_prior")[(1 - 1)];
      current_statement__ = 48;
      context__.validate_dims("data initialization","gamma_prior","int",
          context__.to_vec());
      gamma_prior = std::numeric_limits<int>::min();
      
      current_statement__ = 48;
      gamma_prior = context__.vals_i("gamma_prior")[(1 - 1)];
      current_statement__ = 49;
      context__.validate_dims("data initialization","normal_prior","int",
          context__.to_vec());
      normal_prior = std::numeric_limits<int>::min();
      
      current_statement__ = 49;
      normal_prior = context__.vals_i("normal_prior")[(1 - 1)];
      current_statement__ = 50;
      context__.validate_dims("data initialization","uniform_prior","int",
          context__.to_vec());
      uniform_prior = std::numeric_limits<int>::min();
      
      current_statement__ = 50;
      uniform_prior = context__.vals_i("uniform_prior")[(1 - 1)];
      current_statement__ = 51;
      context__.validate_dims("data initialization","cauchy_prior","int",
          context__.to_vec());
      cauchy_prior = std::numeric_limits<int>::min();
      
      current_statement__ = 51;
      cauchy_prior = context__.vals_i("cauchy_prior")[(1 - 1)];
      current_statement__ = 52;
      context__.validate_dims("data initialization","t_prior","int",
          context__.to_vec());
      t_prior = std::numeric_limits<int>::min();
      
      current_statement__ = 52;
      t_prior = context__.vals_i("t_prior")[(1 - 1)];
      current_statement__ = 53;
      context__.validate_dims("data initialization","chisq_prior","int",
          context__.to_vec());
      chisq_prior = std::numeric_limits<int>::min();
      
      current_statement__ = 53;
      chisq_prior = context__.vals_i("chisq_prior")[(1 - 1)];
      current_statement__ = 54;
      context__.validate_dims("data initialization","exponential_prior",
          "int",context__.to_vec());
      exponential_prior = std::numeric_limits<int>::min();
      
      current_statement__ = 54;
      exponential_prior = context__.vals_i("exponential_prior")[(1 - 1)];
      current_statement__ = 55;
      context__.validate_dims("data initialization","use_likelihood","int",
          context__.to_vec());
      use_likelihood = std::numeric_limits<int>::min();
      
      current_statement__ = 55;
      use_likelihood = context__.vals_i("use_likelihood")[(1 - 1)];
      current_statement__ = 56;
      validate_non_negative_index("theta_s", "S", S);
      current_statement__ = 57;
      validate_non_negative_index("kappa_s", "S", S);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    num_params_r__ = 0U;
    
    try {
      num_params_r__ += 1;
      num_params_r__ += 1;
      num_params_r__ += 1;
      num_params_r__ += 1;
      num_params_r__ += S;
      num_params_r__ += S;
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
  }
  template <bool propto__, bool jacobian__, typename VecR, typename VecI, stan::require_vector_like_t<VecR>* = nullptr, stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline stan::scalar_type_t<VecR> log_prob_impl(VecR& params_r__,
                                                 VecI& params_i__,
                                                 std::ostream* pstream__ = nullptr) const {
    using T__ = stan::scalar_type_t<VecR>;
    using local_scalar_t__ = T__;
    T__ lp__(0.0);
    stan::math::accumulator<T__> lp_accum__;
    static const char* function__ = "model_pp_taint_namespace::log_prob";
(void) function__;  // suppress unused var warning
    stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    (void) DUMMY_VAR__;  // suppress unused var warning
    
    try {
      local_scalar_t__ phi;
      phi = DUMMY_VAR__;
      
      current_statement__ = 1;
      phi = in__.scalar();
      current_statement__ = 1;
      if (jacobian__) {
        current_statement__ = 1;
        phi = stan::math::lub_constrain(phi, 0, 1, lp__);
      } else {
        current_statement__ = 1;
        phi = stan::math::lub_constrain(phi, 0, 1);
      }
      local_scalar_t__ nu;
      nu = DUMMY_VAR__;
      
      current_statement__ = 2;
      nu = in__.scalar();
      current_statement__ = 2;
      if (jacobian__) {
        current_statement__ = 2;
        nu = stan::math::lb_constrain(nu, 1, lp__);
      } else {
        current_statement__ = 2;
        nu = stan::math::lb_constrain(nu, 1);
      }
      local_scalar_t__ mu;
      mu = DUMMY_VAR__;
      
      current_statement__ = 3;
      mu = in__.scalar();
      current_statement__ = 3;
      if (jacobian__) {
        current_statement__ = 3;
        mu = stan::math::lb_constrain(mu, 1, lp__);
      } else {
        current_statement__ = 3;
        mu = stan::math::lb_constrain(mu, 1);
      }
      local_scalar_t__ sigma;
      sigma = DUMMY_VAR__;
      
      current_statement__ = 4;
      sigma = in__.scalar();
      current_statement__ = 4;
      if (jacobian__) {
        current_statement__ = 4;
        sigma = stan::math::lb_constrain(sigma, 0, lp__);
      } else {
        current_statement__ = 4;
        sigma = stan::math::lb_constrain(sigma, 0);
      }
      Eigen::Matrix<local_scalar_t__, -1, 1> theta_s;
      theta_s = Eigen::Matrix<local_scalar_t__, -1, 1>(S);
      stan::math::fill(theta_s, DUMMY_VAR__);
      
      current_statement__ = 5;
      theta_s = in__.vector(S);
      current_statement__ = 5;
      for (int sym1__ = 1; sym1__ <= S; ++sym1__) {
        current_statement__ = 5;
        if (jacobian__) {
          current_statement__ = 5;
          assign(theta_s, cons_list(index_uni(sym1__), nil_index_list()),
            stan::math::lub_constrain(theta_s[(sym1__ - 1)], 0, 1, lp__),
            "assigning variable theta_s");
        } else {
          current_statement__ = 5;
          assign(theta_s, cons_list(index_uni(sym1__), nil_index_list()),
            stan::math::lub_constrain(theta_s[(sym1__ - 1)], 0, 1),
            "assigning variable theta_s");
        }}
      Eigen::Matrix<local_scalar_t__, -1, 1> kappa_s;
      kappa_s = Eigen::Matrix<local_scalar_t__, -1, 1>(S);
      stan::math::fill(kappa_s, DUMMY_VAR__);
      
      current_statement__ = 6;
      kappa_s = in__.vector(S);
      current_statement__ = 6;
      for (int sym1__ = 1; sym1__ <= S; ++sym1__) {
        current_statement__ = 6;
        if (jacobian__) {
          current_statement__ = 6;
          assign(kappa_s, cons_list(index_uni(sym1__), nil_index_list()),
            stan::math::lb_constrain(kappa_s[(sym1__ - 1)], 1, lp__),
            "assigning variable kappa_s");
        } else {
          current_statement__ = 6;
          assign(kappa_s, cons_list(index_uni(sym1__), nil_index_list()),
            stan::math::lb_constrain(kappa_s[(sym1__ - 1)], 1),
            "assigning variable kappa_s");
        }}
      {
        current_statement__ = 30;
        if (beta_prior) {
          current_statement__ = 28;
          lp_accum__.add(beta_lpdf<propto__>(phi, alpha, beta));
        } else {
          current_statement__ = 27;
          if (gamma_prior) {
            current_statement__ = 25;
            lp_accum__.add(gamma_lpdf<propto__>(phi, alpha, beta));
          } else {
            current_statement__ = 24;
            if (normal_prior) {
              current_statement__ = 22;
              lp_accum__.add(normal_lpdf<propto__>(phi, alpha, beta));
            } else {
              current_statement__ = 21;
              if (uniform_prior) {
                current_statement__ = 19;
                lp_accum__.add(uniform_lpdf<propto__>(phi, alpha, beta));
              } else {
                current_statement__ = 18;
                if (cauchy_prior) {
                  current_statement__ = 16;
                  lp_accum__.add(cauchy_lpdf<propto__>(phi, alpha, beta));
                } else {
                  current_statement__ = 15;
                  if (t_prior) {
                    current_statement__ = 13;
                    lp_accum__.add(student_t_lpdf<propto__>(phi, alpha, 0, 1));
                  } else {
                    current_statement__ = 12;
                    if (chisq_prior) {
                      current_statement__ = 10;
                      lp_accum__.add(chi_square_lpdf<propto__>(phi, alpha));
                    } else {
                      current_statement__ = 9;
                      if (exponential_prior) {
                        current_statement__ = 7;
                        lp_accum__.add(exponential_lpdf<propto__>(phi, alpha));
                      } 
                    }
                  }
                }
              }
            }
          }
        }
        current_statement__ = 31;
        lp_accum__.add(pareto_lpdf<propto__>(nu, 1, 1.5));
        current_statement__ = 32;
        lp_accum__.add(normal_lpdf<propto__>(mu, 1, 100));
        current_statement__ = 33;
        lp_accum__.add(normal_lpdf<propto__>(sigma, 0, 10));
        current_statement__ = 34;
        lp_accum__.add(
          beta_lpdf<propto__>(theta_s, (phi * nu), ((1 - phi) * nu)));
        current_statement__ = 35;
        lp_accum__.add(normal_lpdf<propto__>(kappa_s, mu, sigma));
        current_statement__ = 38;
        if (use_likelihood) {
          current_statement__ = 36;
          lp_accum__.add(
            beta_proportion_lpdf<propto__>(t,
              rvalue(theta_s, cons_list(index_multi(s), nil_index_list()),
                "theta_s"),
              rvalue(kappa_s, cons_list(index_multi(s), nil_index_list()),
                "kappa_s")));
        } 
      }
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    lp_accum__.add(lp__);
    return lp_accum__.sum();
    } // log_prob_impl() 
    
  template <typename RNG, typename VecR, typename VecI, typename VecVar, stan::require_vector_like_vt<std::is_floating_point, VecR>* = nullptr, stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr, stan::require_std_vector_vt<std::is_floating_point, VecVar>* = nullptr>
  inline void write_array_impl(RNG& base_rng__, VecR& params_r__,
                               VecI& params_i__, VecVar& vars__,
                               const bool emit_transformed_parameters__ = true,
                               const bool emit_generated_quantities__ = true,
                               std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    vars__.resize(0);
    stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
    static const char* function__ = "model_pp_taint_namespace::write_array";
(void) function__;  // suppress unused var warning
    (void) function__;  // suppress unused var warning
    double lp__ = 0.0;
    (void) lp__;  // dummy to suppress unused var warning
    stan::math::accumulator<double> lp_accum__;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    (void) DUMMY_VAR__;  // suppress unused var warning
    
    try {
      double phi;
      phi = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 1;
      phi = in__.scalar();
      current_statement__ = 1;
      phi = stan::math::lub_constrain(phi, 0, 1);
      double nu;
      nu = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 2;
      nu = in__.scalar();
      current_statement__ = 2;
      nu = stan::math::lb_constrain(nu, 1);
      double mu;
      mu = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 3;
      mu = in__.scalar();
      current_statement__ = 3;
      mu = stan::math::lb_constrain(mu, 1);
      double sigma;
      sigma = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 4;
      sigma = in__.scalar();
      current_statement__ = 4;
      sigma = stan::math::lb_constrain(sigma, 0);
      Eigen::Matrix<double, -1, 1> theta_s;
      theta_s = Eigen::Matrix<double, -1, 1>(S);
      stan::math::fill(theta_s, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 5;
      theta_s = in__.vector(S);
      current_statement__ = 5;
      for (int sym1__ = 1; sym1__ <= S; ++sym1__) {
        current_statement__ = 5;
        assign(theta_s, cons_list(index_uni(sym1__), nil_index_list()),
          stan::math::lub_constrain(theta_s[(sym1__ - 1)], 0, 1),
          "assigning variable theta_s");}
      Eigen::Matrix<double, -1, 1> kappa_s;
      kappa_s = Eigen::Matrix<double, -1, 1>(S);
      stan::math::fill(kappa_s, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 6;
      kappa_s = in__.vector(S);
      current_statement__ = 6;
      for (int sym1__ = 1; sym1__ <= S; ++sym1__) {
        current_statement__ = 6;
        assign(kappa_s, cons_list(index_uni(sym1__), nil_index_list()),
          stan::math::lb_constrain(kappa_s[(sym1__ - 1)], 1),
          "assigning variable kappa_s");}
      vars__.emplace_back(phi);
      vars__.emplace_back(nu);
      vars__.emplace_back(mu);
      vars__.emplace_back(sigma);
      for (int sym1__ = 1; sym1__ <= S; ++sym1__) {
        vars__.emplace_back(theta_s[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= S; ++sym1__) {
        vars__.emplace_back(kappa_s[(sym1__ - 1)]);}
      if (logical_negation((primitive_value(emit_transformed_parameters__) ||
            primitive_value(emit_generated_quantities__)))) {
        return ;
      } 
      if (logical_negation(emit_generated_quantities__)) {
        return ;
      } 
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    } // write_array_impl() 
    
  template <typename VecVar, typename VecI, stan::require_std_vector_t<VecVar>* = nullptr, stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline void transform_inits_impl(const stan::io::var_context& context__,
                                   VecI& params_i__, VecVar& vars__,
                                   std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    vars__.clear();
    vars__.reserve(num_params_r__);
    
    try {
      int pos__;
      pos__ = std::numeric_limits<int>::min();
      
      pos__ = 1;
      double phi;
      phi = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 1;
      phi = context__.vals_r("phi")[(1 - 1)];
      double phi_free__;
      phi_free__ = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 1;
      phi_free__ = stan::math::lub_free(phi, 0, 1);
      double nu;
      nu = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 2;
      nu = context__.vals_r("nu")[(1 - 1)];
      double nu_free__;
      nu_free__ = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 2;
      nu_free__ = stan::math::lb_free(nu, 1);
      double mu;
      mu = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 3;
      mu = context__.vals_r("mu")[(1 - 1)];
      double mu_free__;
      mu_free__ = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 3;
      mu_free__ = stan::math::lb_free(mu, 1);
      double sigma;
      sigma = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 4;
      sigma = context__.vals_r("sigma")[(1 - 1)];
      double sigma_free__;
      sigma_free__ = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 4;
      sigma_free__ = stan::math::lb_free(sigma, 0);
      Eigen::Matrix<double, -1, 1> theta_s;
      theta_s = Eigen::Matrix<double, -1, 1>(S);
      stan::math::fill(theta_s, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> theta_s_flat__;
        current_statement__ = 5;
        assign(theta_s_flat__, nil_index_list(), context__.vals_r("theta_s"),
          "assigning variable theta_s_flat__");
        current_statement__ = 5;
        pos__ = 1;
        current_statement__ = 5;
        for (int sym1__ = 1; sym1__ <= S; ++sym1__) {
          current_statement__ = 5;
          assign(theta_s, cons_list(index_uni(sym1__), nil_index_list()),
            theta_s_flat__[(pos__ - 1)], "assigning variable theta_s");
          current_statement__ = 5;
          pos__ = (pos__ + 1);}
      }
      Eigen::Matrix<double, -1, 1> theta_s_free__;
      theta_s_free__ = Eigen::Matrix<double, -1, 1>(S);
      stan::math::fill(theta_s_free__, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 5;
      for (int sym1__ = 1; sym1__ <= S; ++sym1__) {
        current_statement__ = 5;
        assign(theta_s_free__,
          cons_list(index_uni(sym1__), nil_index_list()),
          stan::math::lub_free(theta_s[(sym1__ - 1)], 0, 1),
          "assigning variable theta_s_free__");}
      Eigen::Matrix<double, -1, 1> kappa_s;
      kappa_s = Eigen::Matrix<double, -1, 1>(S);
      stan::math::fill(kappa_s, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> kappa_s_flat__;
        current_statement__ = 6;
        assign(kappa_s_flat__, nil_index_list(), context__.vals_r("kappa_s"),
          "assigning variable kappa_s_flat__");
        current_statement__ = 6;
        pos__ = 1;
        current_statement__ = 6;
        for (int sym1__ = 1; sym1__ <= S; ++sym1__) {
          current_statement__ = 6;
          assign(kappa_s, cons_list(index_uni(sym1__), nil_index_list()),
            kappa_s_flat__[(pos__ - 1)], "assigning variable kappa_s");
          current_statement__ = 6;
          pos__ = (pos__ + 1);}
      }
      Eigen::Matrix<double, -1, 1> kappa_s_free__;
      kappa_s_free__ = Eigen::Matrix<double, -1, 1>(S);
      stan::math::fill(kappa_s_free__, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 6;
      for (int sym1__ = 1; sym1__ <= S; ++sym1__) {
        current_statement__ = 6;
        assign(kappa_s_free__,
          cons_list(index_uni(sym1__), nil_index_list()),
          stan::math::lb_free(kappa_s[(sym1__ - 1)], 1),
          "assigning variable kappa_s_free__");}
      vars__.emplace_back(phi_free__);
      vars__.emplace_back(nu_free__);
      vars__.emplace_back(mu_free__);
      vars__.emplace_back(sigma_free__);
      for (int sym1__ = 1; sym1__ <= S; ++sym1__) {
        vars__.emplace_back(theta_s_free__[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= S; ++sym1__) {
        vars__.emplace_back(kappa_s_free__[(sym1__ - 1)]);}
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    } // transform_inits_impl() 
    
  inline void get_param_names(std::vector<std::string>& names__) const {
    
    names__.clear();
    names__.emplace_back("phi");
    names__.emplace_back("nu");
    names__.emplace_back("mu");
    names__.emplace_back("sigma");
    names__.emplace_back("theta_s");
    names__.emplace_back("kappa_s");
    } // get_param_names() 
    
  inline void get_dims(std::vector<std::vector<size_t>>& dimss__) const {
    dimss__.clear();
    dimss__.emplace_back(std::vector<size_t>{});
    
    dimss__.emplace_back(std::vector<size_t>{});
    
    dimss__.emplace_back(std::vector<size_t>{});
    
    dimss__.emplace_back(std::vector<size_t>{});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(S)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(S)});
    
    } // get_dims() 
    
  inline void constrained_param_names(
                                      std::vector<std::string>& param_names__,
                                      bool emit_transformed_parameters__ = true,
                                      bool emit_generated_quantities__ = true) const
    final {
    
    param_names__.emplace_back(std::string() + "phi");
    param_names__.emplace_back(std::string() + "nu");
    param_names__.emplace_back(std::string() + "mu");
    param_names__.emplace_back(std::string() + "sigma");
    for (int sym1__ = 1; sym1__ <= S; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "theta_s" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= S; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "kappa_s" + '.' + std::to_string(sym1__));
      }}
    if (emit_transformed_parameters__) {
      
    }
    
    if (emit_generated_quantities__) {
      
    }
    
    } // constrained_param_names() 
    
  inline void unconstrained_param_names(
                                        std::vector<std::string>& param_names__,
                                        bool emit_transformed_parameters__ = true,
                                        bool emit_generated_quantities__ = true) const
    final {
    
    param_names__.emplace_back(std::string() + "phi");
    param_names__.emplace_back(std::string() + "nu");
    param_names__.emplace_back(std::string() + "mu");
    param_names__.emplace_back(std::string() + "sigma");
    for (int sym1__ = 1; sym1__ <= S; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "theta_s" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= S; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "kappa_s" + '.' + std::to_string(sym1__));
      }}
    if (emit_transformed_parameters__) {
      
    }
    
    if (emit_generated_quantities__) {
      
    }
    
    } // unconstrained_param_names() 
    
  inline std::string get_constrained_sizedtypes() const {
    stringstream s__;
    s__ << "[{\"name\":\"phi\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"nu\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"mu\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"sigma\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"theta_s\",\"type\":{\"name\":\"vector\",\"length\":" << S << "},\"block\":\"parameters\"},{\"name\":\"kappa_s\",\"type\":{\"name\":\"vector\",\"length\":" << S << "},\"block\":\"parameters\"}]";
    return s__.str();
    } // get_constrained_sizedtypes() 
    
  inline std::string get_unconstrained_sizedtypes() const {
    stringstream s__;
    s__ << "[{\"name\":\"phi\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"nu\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"mu\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"sigma\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"theta_s\",\"type\":{\"name\":\"vector\",\"length\":" << S << "},\"block\":\"parameters\"},{\"name\":\"kappa_s\",\"type\":{\"name\":\"vector\",\"length\":" << S << "},\"block\":\"parameters\"}]";
    return s__.str();
    } // get_unconstrained_sizedtypes() 
    
  
    // Begin method overload boilerplate
    template <typename RNG>
    inline void write_array(RNG& base_rng,
                            Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                            Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                            const bool emit_transformed_parameters = true,
                            const bool emit_generated_quantities = true,
                            std::ostream* pstream = nullptr) const {
      std::vector<double> vars_vec(vars.size());
      std::vector<int> params_i;
      write_array_impl(base_rng, params_r, params_i, vars_vec,
          emit_transformed_parameters, emit_generated_quantities, pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i) {
        vars.coeffRef(i) = vars_vec[i];
      }
    }
    template <typename RNG>
    inline void write_array(RNG& base_rng, std::vector<double>& params_r,
                            std::vector<int>& params_i,
                            std::vector<double>& vars,
                            bool emit_transformed_parameters = true,
                            bool emit_generated_quantities = true,
                            std::ostream* pstream = nullptr) const {
      write_array_impl(base_rng, params_r, params_i, vars, emit_transformed_parameters, emit_generated_quantities, pstream);
    }
    template <bool propto__, bool jacobian__, typename T_>
    inline T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
                       std::ostream* pstream = nullptr) const {
      Eigen::Matrix<int, -1, 1> params_i;
      return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
    }
    template <bool propto__, bool jacobian__, typename T__>
    inline T__ log_prob(std::vector<T__>& params_r,
                        std::vector<int>& params_i,
                        std::ostream* pstream = nullptr) const {
      return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
    }
  
    inline void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double, Eigen::Dynamic, 1>& params_r,
                         std::ostream* pstream = nullptr) const final {
      std::vector<double> params_r_vec(params_r.size());
      std::vector<int> params_i;
      transform_inits_impl(context, params_i, params_r_vec, pstream);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i) {
        params_r.coeffRef(i) = params_r_vec[i];
      }
    }
    inline void transform_inits(const stan::io::var_context& context,
                                std::vector<int>& params_i,
                                std::vector<double>& vars,
                                std::ostream* pstream = nullptr) const final {
      transform_inits_impl(context, params_i, vars, pstream);
    }        
};
}
using stan_model = model_pp_taint_namespace::model_pp_taint;
#ifndef USING_R
// Boilerplate
stan::model::model_base& new_model(
        stan::io::var_context& data_context,
        unsigned int seed,
        std::ostream* msg_stream) {
  stan_model* m = new stan_model(data_context, seed, msg_stream);
  return *m;
}
stan::math::profile_map& get_stan_profile_data() {
  return model_pp_taint_namespace::profiles__;
}
#endif
#endif
