% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jfa-methods.R
\name{jfa-methods}
\alias{jfa-methods}
\alias{print.jfaPrior}
\alias{print.summary.jfaPrior}
\alias{summary.jfaPrior}
\alias{predict.jfaPrior}
\alias{print.jfaPredict}
\alias{plot.jfaPrior}
\alias{plot.jfaPredict}
\alias{print.jfaPosterior}
\alias{print.summary.jfaPosterior}
\alias{summary.jfaPosterior}
\alias{predict.jfaPosterior}
\alias{plot.jfaPosterior}
\alias{print.jfaPlanning}
\alias{print.summary.jfaPlanning}
\alias{summary.jfaPlanning}
\alias{plot.jfaPlanning}
\alias{print.jfaSelection}
\alias{print.summary.jfaSelection}
\alias{summary.jfaSelection}
\alias{print.jfaEvaluation}
\alias{print.summary.jfaEvaluation}
\alias{summary.jfaEvaluation}
\alias{plot.jfaEvaluation}
\alias{print.jfaDistr}
\alias{print.summary.jfaDistr}
\alias{summary.jfaDistr}
\alias{plot.jfaDistr}
\alias{print.jfaRv}
\alias{plot.jfaRv}
\alias{print.jfaFairness}
\alias{print.summary.jfaFairness}
\alias{summary.jfaFairness}
\alias{plot.jfaFairness}
\alias{print.jfaFairnessSelection}
\alias{plot.jfaFairnessSelection}
\title{Methods for jfa objects}
\usage{
\method{print}{jfaPrior}(x, ...)

\method{print}{summary.jfaPrior}(x, digits = getOption("digits"), ...)

\method{summary}{jfaPrior}(object, digits = getOption("digits"), ...)

\method{predict}{jfaPrior}(object, n, cumulative = FALSE, ...)

\method{print}{jfaPredict}(x, ...)

\method{plot}{jfaPrior}(x, ...)

\method{plot}{jfaPredict}(x, ...)

\method{print}{jfaPosterior}(x, ...)

\method{print}{summary.jfaPosterior}(x, digits = getOption("digits"), ...)

\method{summary}{jfaPosterior}(object, digits = getOption("digits"), ...)

\method{predict}{jfaPosterior}(object, n, cumulative = FALSE, ...)

\method{plot}{jfaPosterior}(x, ...)

\method{print}{jfaPlanning}(x, ...)

\method{print}{summary.jfaPlanning}(x, digits = getOption("digits"), ...)

\method{summary}{jfaPlanning}(object, digits = getOption("digits"), ...)

\method{plot}{jfaPlanning}(x, ...)

\method{print}{jfaSelection}(x, ...)

\method{print}{summary.jfaSelection}(x, digits = getOption("digits"), ...)

\method{summary}{jfaSelection}(object, digits = getOption("digits"), ...)

\method{print}{jfaEvaluation}(x, digits = getOption("digits"), ...)

\method{print}{summary.jfaEvaluation}(x, digits = getOption("digits"), ...)

\method{summary}{jfaEvaluation}(object, digits = getOption("digits"), ...)

\method{plot}{jfaEvaluation}(x, type = c("estimates", "posterior", "sequential"), ...)

\method{print}{jfaDistr}(x, digits = getOption("digits"), ...)

\method{print}{summary.jfaDistr}(x, digits = getOption("digits"), ...)

\method{summary}{jfaDistr}(object, digits = getOption("digits"), ...)

\method{plot}{jfaDistr}(x, type = c("estimates", "robustness", "sequential"), ...)

\method{print}{jfaRv}(x, digits = getOption("digits"), ...)

\method{plot}{jfaRv}(x, ...)

\method{print}{jfaFairness}(x, digits = getOption("digits"), ...)

\method{print}{summary.jfaFairness}(x, digits = getOption("digits"), ...)

\method{summary}{jfaFairness}(object, digits = getOption("digits"), ...)

\method{plot}{jfaFairness}(x, type = c("estimates", "posterior", "robustness", "sequential"), ...)

\method{print}{jfaFairnessSelection}(x, ...)

\method{plot}{jfaFairnessSelection}(x, ...)
}
\arguments{
\item{...}{further arguments, currently ignored.}

\item{digits}{an integer specifying the number of digits to which output should be rounded. Used in \code{summary}.}

\item{object, x}{an object of class \code{jfaPrior}, \code{jfaPosterior}, \code{jfaPlanning}, \code{jfaSelection}, \code{jfaEvaluation}, \code{jfaDistr}, \code{jfaRv}, or \code{jfaFairness}.}

\item{n}{used in \code{predict}. Specifies the sample size for which predictions should be made.}

\item{cumulative}{used in \code{predict}. Specifies whether cumulative probabilities should be shown.}

\item{type}{used in \code{plot}. Specifies the type of plot to produce.}
}
\value{
The \code{summary} methods return a \code{data.frame} which contains the input and output.

The \code{print} methods simply print and return nothing.
}
\description{
Methods defined for objects returned from the \code{\link{auditPrior}}, \code{\link{planning}}, \code{\link{selection}}, and \code{\link{evaluation}} functions.
}
