% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mat.R
\name{circle_matrix}
\alias{circle_matrix}
\title{Create a circle pattern within a matrix}
\usage{
circle_matrix(m, n, x.center, y.center, r, f = 1)
}
\arguments{
\item{m}{A \code{int} that is the number of rows of the matrix}

\item{n}{A \code{int} that is the number of the columns of the matrix.}

\item{x.center}{A \code{vector} of x coordinate center position of the circle.}

\item{y.center}{A \code{vector} of y coordinate center position of the circle.}

\item{r}{A \code{vector} of integers denoting the different circle radii.}

\item{f}{A \code{vector} of values that specify what the inside of the
circles should be.}
}
\value{
A \code{matrix} with circles imprinted within its dimensions.
}
\description{
Takes a default matrix and embeds circles within the matrix.
}
\examples{

# Generate a basic circle matrix
circle_matrix(10, 10, 3, 4, 2)

# Generate two circles within the matrix
circle_matrix(10, 20, c(3,6), c(4,6), c(2,2))

# Different fills
circle_matrix(10, 20, c(3,6), c(4,6), c(2,2), f = c(1,2))
}
\author{
James J Balamuta
}
