% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{bags_to_tfidf}
\alias{bags_to_tfidf}
\title{Computes a TF-IDF weights matrix for a list of word bags}
\usage{
bags_to_tfidf(data)
}
\arguments{
\item{data}{the word-bags list}
}
\description{
Computes a TF-IDF weights matrix for a list of word bags
}
\examples{
bag1 = data.frame(
   "words" = c("this", "is", "a", "sample"),
   "counts" = c(1, 1, 2, 1),
   stringsAsFactors = FALSE
   )
bag2 = data.frame(
   "words" = c("this", "is", "another", "example"),
   "counts" = c(1, 1, 2, 3),
   stringsAsFactors = FALSE
   )
ll = list("bag1" = bag1, "bag2" = bag2)
tfidf = bags_to_tfidf(ll)
}
\references{
Senin Pavel and Malinchik Sergey,
SAX-VSM: Interpretable Time Series Classification Using SAX and Vector Space Model.
Data Mining (ICDM), 2013 IEEE 13th International Conference on, pp.1175,1180, 7-10 Dec. 2013.

Salton, G., Wong, A., Yang., C.,
A vector space model for automatic indexing. Commun. ACM 18, 11, 613-620, 1975.
}

