% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/anovarmnp.h.R
\name{anovaRMNP}
\alias{anovaRMNP}
\title{Repeated Measures ANOVA (Non-parametric)}
\usage{
anovaRMNP(data, measures, pairs = FALSE, desc = FALSE, plots = FALSE,
  plotType = "means")
}
\arguments{
\item{data}{the data as a data frame}

\item{measures}{a vector of strings naming the repeated measures variables}

\item{pairs}{\code{TRUE} or \code{FALSE} (default), perform pairwise 
comparisons}

\item{desc}{\code{TRUE} or \code{FALSE} (default), provide descriptive 
statistics}

\item{plots}{\code{TRUE} or \code{FALSE} (default), provide a descriptive 
plot}

\item{plotType}{\code{'means'} (default) or \code{'medians'}, the error 
bars to use in the plot}
}
\value{
A results object containing:
\tabular{llllll}{
  \code{results$table} \tab \tab \tab \tab \tab a table of the Friedman test results \cr
  \code{results$comp} \tab \tab \tab \tab \tab a table of the pairwise comparisons \cr
  \code{results$plot} \tab \tab \tab \tab \tab a descriptives plot \cr
}

Tables can be converted to data frames with \code{asDF} or \code{\link{as.data.frame}}. For example:

\code{results$table$asDF}

\code{as.data.frame(results$table)}
}
\description{
Friedman
}
\examples{
data('bugs', package = 'jmv')

anovaRMNP(bugs, measures = c('LDLF', 'LDHF', 'HDLF', 'HDHF'))

#
#  Friedman
#  ------------------------
#    X²      df    p
#  ------------------------
#    55.8     3    < .001
#  ------------------------
#

}
