
# This file is automatically generated, you probably don't want to edit this

cfaOptions <- if (requireNamespace('jmvcore')) R6::R6Class(
    "cfaOptions",
    inherit = jmvcore::Options,
    public = list(
        initialize = function(
            factors = list(
                list(label="Factor 1", vars=list())),
            resCov = NULL,
            miss = "fiml",
            constrain = "facVar",
            estTest = TRUE,
            ci = FALSE,
            ciWidth = 95,
            stdEst = FALSE,
            factCovEst = TRUE,
            factInterceptEst = FALSE,
            resCovEst = FALSE,
            resInterceptEst = FALSE,
            fitMeasures = list(
                "cfi",
                "tli",
                "rmsea"),
            modelTest = TRUE,
            pathDiagram = FALSE,
            corRes = FALSE,
            hlCorRes = 0.1,
            mi = FALSE,
            hlMI = 3, ...) {

            super$initialize(
                package='jmv',
                name='cfa',
                requiresData=TRUE,
                ...)

            private$..factors <- jmvcore::OptionArray$new(
                "factors",
                factors,
                default=list(
                    list(label="Factor 1", vars=list())),
                template=jmvcore::OptionGroup$new(
                    "factors",
                    NULL,
                    elements=list(
                        jmvcore::OptionString$new(
                            "label",
                            NULL),
                        jmvcore::OptionVariables$new(
                            "vars",
                            NULL,
                            suggested=list(
                                "continuous"),
                            permitted=list(
                                "numeric")))))
            private$..resCov <- jmvcore::OptionPairs$new(
                "resCov",
                resCov)
            private$..miss <- jmvcore::OptionList$new(
                "miss",
                miss,
                options=list(
                    "listwise",
                    "fiml"),
                default="fiml")
            private$..constrain <- jmvcore::OptionList$new(
                "constrain",
                constrain,
                options=list(
                    "facVar",
                    "facInd"),
                default="facVar")
            private$..estTest <- jmvcore::OptionBool$new(
                "estTest",
                estTest,
                default=TRUE)
            private$..ci <- jmvcore::OptionBool$new(
                "ci",
                ci,
                default=FALSE)
            private$..ciWidth <- jmvcore::OptionNumber$new(
                "ciWidth",
                ciWidth,
                min=50,
                max=99.9,
                default=95)
            private$..stdEst <- jmvcore::OptionBool$new(
                "stdEst",
                stdEst,
                default=FALSE)
            private$..factCovEst <- jmvcore::OptionBool$new(
                "factCovEst",
                factCovEst,
                default=TRUE)
            private$..factInterceptEst <- jmvcore::OptionBool$new(
                "factInterceptEst",
                factInterceptEst,
                default=FALSE)
            private$..resCovEst <- jmvcore::OptionBool$new(
                "resCovEst",
                resCovEst,
                default=FALSE)
            private$..resInterceptEst <- jmvcore::OptionBool$new(
                "resInterceptEst",
                resInterceptEst,
                default=FALSE)
            private$..fitMeasures <- jmvcore::OptionNMXList$new(
                "fitMeasures",
                fitMeasures,
                options=list(
                    "cfi",
                    "tli",
                    "srmr",
                    "rmsea",
                    "aic",
                    "bic"),
                default=list(
                    "cfi",
                    "tli",
                    "rmsea"))
            private$..modelTest <- jmvcore::OptionBool$new(
                "modelTest",
                modelTest,
                default=TRUE)
            private$..pathDiagram <- jmvcore::OptionBool$new(
                "pathDiagram",
                pathDiagram,
                default=FALSE)
            private$..corRes <- jmvcore::OptionBool$new(
                "corRes",
                corRes,
                default=FALSE)
            private$..hlCorRes <- jmvcore::OptionNumber$new(
                "hlCorRes",
                hlCorRes,
                default=0.1)
            private$..mi <- jmvcore::OptionBool$new(
                "mi",
                mi,
                default=FALSE)
            private$..hlMI <- jmvcore::OptionNumber$new(
                "hlMI",
                hlMI,
                default=3)

            self$.addOption(private$..factors)
            self$.addOption(private$..resCov)
            self$.addOption(private$..miss)
            self$.addOption(private$..constrain)
            self$.addOption(private$..estTest)
            self$.addOption(private$..ci)
            self$.addOption(private$..ciWidth)
            self$.addOption(private$..stdEst)
            self$.addOption(private$..factCovEst)
            self$.addOption(private$..factInterceptEst)
            self$.addOption(private$..resCovEst)
            self$.addOption(private$..resInterceptEst)
            self$.addOption(private$..fitMeasures)
            self$.addOption(private$..modelTest)
            self$.addOption(private$..pathDiagram)
            self$.addOption(private$..corRes)
            self$.addOption(private$..hlCorRes)
            self$.addOption(private$..mi)
            self$.addOption(private$..hlMI)
        }),
    active = list(
        factors = function() private$..factors$value,
        resCov = function() private$..resCov$value,
        miss = function() private$..miss$value,
        constrain = function() private$..constrain$value,
        estTest = function() private$..estTest$value,
        ci = function() private$..ci$value,
        ciWidth = function() private$..ciWidth$value,
        stdEst = function() private$..stdEst$value,
        factCovEst = function() private$..factCovEst$value,
        factInterceptEst = function() private$..factInterceptEst$value,
        resCovEst = function() private$..resCovEst$value,
        resInterceptEst = function() private$..resInterceptEst$value,
        fitMeasures = function() private$..fitMeasures$value,
        modelTest = function() private$..modelTest$value,
        pathDiagram = function() private$..pathDiagram$value,
        corRes = function() private$..corRes$value,
        hlCorRes = function() private$..hlCorRes$value,
        mi = function() private$..mi$value,
        hlMI = function() private$..hlMI$value),
    private = list(
        ..factors = NA,
        ..resCov = NA,
        ..miss = NA,
        ..constrain = NA,
        ..estTest = NA,
        ..ci = NA,
        ..ciWidth = NA,
        ..stdEst = NA,
        ..factCovEst = NA,
        ..factInterceptEst = NA,
        ..resCovEst = NA,
        ..resInterceptEst = NA,
        ..fitMeasures = NA,
        ..modelTest = NA,
        ..pathDiagram = NA,
        ..corRes = NA,
        ..hlCorRes = NA,
        ..mi = NA,
        ..hlMI = NA)
)

cfaResults <- if (requireNamespace('jmvcore')) R6::R6Class(
    inherit = jmvcore::Group,
    active = list(
        factorLoadings = function() private$.items[["factorLoadings"]],
        factorEst = function() private$.items[["factorEst"]],
        resEst = function() private$.items[["resEst"]],
        modelFit = function() private$.items[["modelFit"]],
        modelPerformance = function() private$.items[["modelPerformance"]],
        pathDiagram = function() private$.items[["pathDiagram"]],
        modelSyntax = function() private$..modelSyntax),
    private = list(
        ..modelSyntax = NA),
    public=list(
        initialize=function(options) {
            super$initialize(
                options=options,
                name="",
                title="Confirmatory Factor Analysis")
            self$add(jmvcore::Table$new(
                options=options,
                name="factorLoadings",
                title="Factor Loadings",
                refs="lavaan",
                clearWith=list(
                    "factors",
                    "resCov",
                    "constrain",
                    "miss"),
                columns=list(
                    list(
                        `name`="factor", 
                        `title`="Factor", 
                        `type`="text", 
                        `combineBelow`=TRUE),
                    list(
                        `name`="indicator", 
                        `title`="Indicator", 
                        `type`="text"),
                    list(
                        `name`="est", 
                        `title`="Estimate", 
                        `type`="number"),
                    list(
                        `name`="se", 
                        `title`="SE", 
                        `type`="number"),
                    list(
                        `name`="lower", 
                        `title`="Lower", 
                        `type`="number", 
                        `visible`="(ci)"),
                    list(
                        `name`="upper", 
                        `title`="Upper", 
                        `type`="number", 
                        `visible`="(ci)"),
                    list(
                        `name`="z", 
                        `title`="Z", 
                        `type`="number", 
                        `visible`="(estTest)"),
                    list(
                        `name`="p", 
                        `title`="p", 
                        `type`="number", 
                        `format`="zto,pvalue", 
                        `visible`="(estTest)"),
                    list(
                        `name`="stdEst", 
                        `title`="Stand. Estimate", 
                        `type`="number", 
                        `visible`="(stdEst)"))))
            self$add(R6::R6Class(
                inherit = jmvcore::Group,
                active = list(
                    factorCov = function() private$.items[["factorCov"]],
                    factorIntercept = function() private$.items[["factorIntercept"]]),
                private = list(),
                public=list(
                    initialize=function(options) {
                        super$initialize(
                            options=options,
                            name="factorEst",
                            title="Factor Estimates")
                        self$add(jmvcore::Table$new(
                            options=options,
                            name="factorCov",
                            title="Factor Covariances",
                            visible="(factCovEst)",
                            clearWith=list(
                                "factors",
                                "resCov",
                                "constrain",
                                "miss"),
                            columns=list(
                                list(
                                    `name`="factor1", 
                                    `title`="", 
                                    `type`="text", 
                                    `combineBelow`=TRUE),
                                list(
                                    `name`="factor2", 
                                    `title`="", 
                                    `type`="text"),
                                list(
                                    `name`="est", 
                                    `title`="Estimate", 
                                    `type`="number"),
                                list(
                                    `name`="se", 
                                    `title`="SE", 
                                    `type`="number"),
                                list(
                                    `name`="lower", 
                                    `title`="Lower", 
                                    `type`="number", 
                                    `visible`="(ci)"),
                                list(
                                    `name`="upper", 
                                    `title`="Upper", 
                                    `type`="number", 
                                    `visible`="(ci)"),
                                list(
                                    `name`="z", 
                                    `title`="Z", 
                                    `type`="number", 
                                    `visible`="(estTest)"),
                                list(
                                    `name`="p", 
                                    `title`="p", 
                                    `type`="number", 
                                    `format`="zto,pvalue", 
                                    `visible`="(estTest)"),
                                list(
                                    `name`="stdEst", 
                                    `title`="Stand. Estimate", 
                                    `type`="number", 
                                    `visible`="(stdEst)"))))
                        self$add(jmvcore::Table$new(
                            options=options,
                            name="factorIntercept",
                            title="Factor Intercepts",
                            visible="(factInterceptEst)",
                            clearWith=list(
                                "factors",
                                "resCov",
                                "constrain",
                                "miss"),
                            columns=list(
                                list(
                                    `name`="factor", 
                                    `title`="", 
                                    `type`="text", 
                                    `combineBelow`=TRUE),
                                list(
                                    `name`="est", 
                                    `title`="Estimate", 
                                    `type`="number"),
                                list(
                                    `name`="se", 
                                    `title`="SE", 
                                    `type`="number"),
                                list(
                                    `name`="lower", 
                                    `title`="Lower", 
                                    `type`="number", 
                                    `visible`="(ci)"),
                                list(
                                    `name`="upper", 
                                    `title`="Upper", 
                                    `type`="number", 
                                    `visible`="(ci)"),
                                list(
                                    `name`="z", 
                                    `title`="Z", 
                                    `type`="number", 
                                    `visible`="(estTest)"),
                                list(
                                    `name`="p", 
                                    `title`="p", 
                                    `type`="number", 
                                    `format`="zto,pvalue", 
                                    `visible`="(estTest)"),
                                list(
                                    `name`="stdEst", 
                                    `title`="Stand. Estimate", 
                                    `type`="number", 
                                    `visible`="(stdEst)"))))}))$new(options=options))
            self$add(R6::R6Class(
                inherit = jmvcore::Group,
                active = list(
                    resCov = function() private$.items[["resCov"]],
                    resIntercept = function() private$.items[["resIntercept"]]),
                private = list(),
                public=list(
                    initialize=function(options) {
                        super$initialize(
                            options=options,
                            name="resEst",
                            title="Residual Estimates")
                        self$add(jmvcore::Table$new(
                            options=options,
                            name="resCov",
                            title="Residual Covariances",
                            visible="(resCovEst)",
                            clearWith=list(
                                "factors",
                                "resCov",
                                "constrain",
                                "miss"),
                            columns=list(
                                list(
                                    `name`="var1", 
                                    `title`="", 
                                    `type`="text", 
                                    `combineBelow`=TRUE),
                                list(
                                    `name`="var2", 
                                    `title`="", 
                                    `type`="text"),
                                list(
                                    `name`="est", 
                                    `title`="Estimate", 
                                    `type`="number"),
                                list(
                                    `name`="se", 
                                    `title`="SE", 
                                    `type`="number"),
                                list(
                                    `name`="lower", 
                                    `title`="Lower", 
                                    `type`="number", 
                                    `visible`="(ci)"),
                                list(
                                    `name`="upper", 
                                    `title`="Upper", 
                                    `type`="number", 
                                    `visible`="(ci)"),
                                list(
                                    `name`="z", 
                                    `title`="Z", 
                                    `type`="number", 
                                    `visible`="(estTest)"),
                                list(
                                    `name`="p", 
                                    `title`="p", 
                                    `type`="number", 
                                    `format`="zto,pvalue", 
                                    `visible`="(estTest)"),
                                list(
                                    `name`="stdEst", 
                                    `title`="Stand. Estimate", 
                                    `type`="number", 
                                    `visible`="(stdEst)"))))
                        self$add(jmvcore::Table$new(
                            options=options,
                            name="resIntercept",
                            title="Residual Intercepts",
                            visible="(resInterceptEst)",
                            clearWith=list(
                                "factors",
                                "resCov",
                                "constrain",
                                "miss"),
                            columns=list(
                                list(
                                    `name`="var", 
                                    `title`="", 
                                    `type`="text", 
                                    `combineBelow`=TRUE),
                                list(
                                    `name`="est", 
                                    `title`="Estimate", 
                                    `type`="number"),
                                list(
                                    `name`="se", 
                                    `title`="SE", 
                                    `type`="number"),
                                list(
                                    `name`="lower", 
                                    `title`="Lower", 
                                    `type`="number", 
                                    `visible`="(ci)"),
                                list(
                                    `name`="upper", 
                                    `title`="Upper", 
                                    `type`="number", 
                                    `visible`="(ci)"),
                                list(
                                    `name`="z", 
                                    `title`="Z", 
                                    `type`="number", 
                                    `visible`="(estTest)"),
                                list(
                                    `name`="p", 
                                    `title`="p", 
                                    `type`="number", 
                                    `format`="zto,pvalue", 
                                    `visible`="(estTest)"),
                                list(
                                    `name`="stdEst", 
                                    `title`="Stand. Estimate", 
                                    `type`="number", 
                                    `visible`="(stdEst)"))))}))$new(options=options))
            self$add(R6::R6Class(
                inherit = jmvcore::Group,
                active = list(
                    test = function() private$.items[["test"]],
                    fitMeasures = function() private$.items[["fitMeasures"]]),
                private = list(),
                public=list(
                    initialize=function(options) {
                        super$initialize(
                            options=options,
                            name="modelFit",
                            title="Model Fit")
                        self$add(jmvcore::Table$new(
                            options=options,
                            name="test",
                            title="Test for Exact Fit",
                            rows=1,
                            visible="(modelTest)",
                            clearWith=list(
                                "factors",
                                "resCov",
                                "constrain",
                                "miss"),
                            columns=list(
                                list(
                                    `name`="chi", 
                                    `title`="\u03C7\u00B2", 
                                    `type`="number"),
                                list(
                                    `name`="df", 
                                    `title`="df", 
                                    `type`="integer"),
                                list(
                                    `name`="p", 
                                    `title`="p", 
                                    `type`="number", 
                                    `format`="zto,pvalue"))))
                        self$add(jmvcore::Table$new(
                            options=options,
                            name="fitMeasures",
                            title="Fit Measures",
                            rows=1,
                            visible="(fitMeasures:cfi || fitMeasures:tli || fitMeasures:aic || fitMeasures:bic || fitMeasures:srmr || fitMeasures:rmsea)",
                            clearWith=list(
                                "factors",
                                "resCov",
                                "constrain",
                                "miss"),
                            columns=list(
                                list(
                                    `name`="cfi", 
                                    `title`="CFI", 
                                    `type`="number", 
                                    `visible`="(fitMeasures:cfi)"),
                                list(
                                    `name`="tli", 
                                    `title`="TLI", 
                                    `type`="number", 
                                    `visible`="(fitMeasures:tli)"),
                                list(
                                    `name`="srmr", 
                                    `title`="SRMR", 
                                    `type`="number", 
                                    `visible`="(fitMeasures:srmr)"),
                                list(
                                    `name`="rmsea", 
                                    `title`="RMSEA", 
                                    `type`="number", 
                                    `visible`="(fitMeasures:rmsea)"),
                                list(
                                    `name`="rmseaLower", 
                                    `title`="Lower", 
                                    `type`="number", 
                                    `superTitle`="RMSEA 90% CI", 
                                    `visible`="(fitMeasures:rmsea)"),
                                list(
                                    `name`="rmseaUpper", 
                                    `title`="Upper", 
                                    `type`="number", 
                                    `superTitle`="RMSEA 90% CI", 
                                    `visible`="(fitMeasures:rmsea)"),
                                list(
                                    `name`="aic", 
                                    `title`="AIC", 
                                    `type`="number", 
                                    `visible`="(fitMeasures:aic)"),
                                list(
                                    `name`="bic", 
                                    `title`="BIC", 
                                    `type`="number", 
                                    `visible`="(fitMeasures:bic)"))))}))$new(options=options))
            self$add(R6::R6Class(
                inherit = jmvcore::Group,
                active = list(
                    corRes = function() private$.items[["corRes"]],
                    modIndices = function() private$.items[["modIndices"]]),
                private = list(),
                public=list(
                    initialize=function(options) {
                        super$initialize(
                            options=options,
                            name="modelPerformance",
                            title="Post-Hoc Model Performance")
                        self$add(jmvcore::Table$new(
                            options=options,
                            name="corRes",
                            title="Residuals for Observed Correlation Matrix",
                            visible="(corRes)",
                            clearWith=list(
                                "factors",
                                "resCov",
                                "constrain",
                                "miss"),
                            columns=list(
                                list(
                                    `name`="var", 
                                    `title`="", 
                                    `type`="text", 
                                    `format`="narrow"))))
                        self$add(R6::R6Class(
                            inherit = jmvcore::Group,
                            active = list(
                                factorLoadingsMod = function() private$.items[["factorLoadingsMod"]],
                                resCovMod = function() private$.items[["resCovMod"]]),
                            private = list(),
                            public=list(
                                initialize=function(options) {
                                    super$initialize(
                                        options=options,
                                        name="modIndices",
                                        title="Modification Indices")
                                    self$add(jmvcore::Table$new(
                                        options=options,
                                        name="factorLoadingsMod",
                                        title="Factor Loadings \u2013 Modification Indices",
                                        visible="(mi)",
                                        clearWith=list(
                                            "factors",
                                            "resCov",
                                            "constrain",
                                            "miss"),
                                        columns=list(
                                            list(
                                                `name`="var", 
                                                `title`="", 
                                                `type`="text", 
                                                `format`="narrow"))))
                                    self$add(jmvcore::Table$new(
                                        options=options,
                                        name="resCovMod",
                                        title="Residual Covariances \u2013 Modification Indices",
                                        visible="(mi)",
                                        clearWith=list(
                                            "factors",
                                            "resCov",
                                            "constrain",
                                            "miss"),
                                        columns=list(
                                            list(
                                                `name`="var", 
                                                `title`="", 
                                                `type`="text", 
                                                `format`="narrow"))))}))$new(options=options))}))$new(options=options))
            self$add(jmvcore::Image$new(
                options=options,
                name="pathDiagram",
                title="Path Diagram",
                width=450,
                height=600,
                renderFun=".pathDiagram",
                visible="(pathDiagram)",
                refs="semPlot",
                clearWith=list(
                    "factors",
                    "resCov",
                    "constrain")))
            private$..modelSyntax <- NULL},
        .setModelSyntax=function(x) private$..modelSyntax <- x))

cfaBase <- if (requireNamespace('jmvcore')) R6::R6Class(
    "cfaBase",
    inherit = jmvcore::Analysis,
    public = list(
        initialize = function(options, data=NULL, datasetId="", analysisId="", revision=0) {
            super$initialize(
                package = 'jmv',
                name = 'cfa',
                version = c(1,0,0),
                options = options,
                results = cfaResults$new(options=options),
                data = data,
                datasetId = datasetId,
                analysisId = analysisId,
                revision = revision,
                pause = NULL,
                completeWhenFilled = FALSE)
        }))

#' Confirmatory Factor Analysis
#'
#' Confirmatory Factor Analysis
#'
#' @examples
#' data <- lavaan::HolzingerSwineford1939
#'
#' jmv::cfa(
#'     data = data,
#'     factors = list(
#'         list(label="Visual", vars=c("x1", "x2", "x3")),
#'         list(label="Textual", vars=c("x4", "x5", "x6")),
#'         list(label="Speed", vars=c("x7", "x8", "x9"))),
#'     resCov = NULL)
#'
#' #
#' #  CONFIRMATORY FACTOR ANALYSIS
#' #
#' #  Factor Loadings
#' #  -----------------------------------------------------------------
#' #    Factor     Indicator    Estimate    SE        Z        p
#' #  -----------------------------------------------------------------
#' #    Visual     x1              0.900    0.0832    10.81    < .001
#' #               x2              0.498    0.0808     6.16    < .001
#' #               x3              0.656    0.0776     8.46    < .001
#' #    Textual    x4              0.990    0.0567    17.46    < .001
#' #               x5              1.102    0.0626    17.60    < .001
#' #               x6              0.917    0.0538    17.05    < .001
#' #    Speed      x7              0.619    0.0743     8.34    < .001
#' #               x8              0.731    0.0755     9.68    < .001
#' #               x9              0.670    0.0775     8.64    < .001
#' #  -----------------------------------------------------------------
#' #
#' #
#' #  FACTOR ESTIMATES
#' #
#' #  Factor Covariances
#' #  --------------------------------------------------------------
#' #                          Estimate    SE        Z       p
#' #  --------------------------------------------------------------
#' #    Visual     Visual      1.000 a
#' #               Textual     0.459      0.0635    7.22    < .001
#' #               Speed       0.471      0.0862    5.46    < .001
#' #    Textual    Textual     1.000 a
#' #               Speed       0.283      0.0715    3.96    < .001
#' #    Speed      Speed       1.000 a
#' #  --------------------------------------------------------------
#' #    a fixed parameter
#' #
#' #
#' #  MODEL FIT
#' #
#' #  Test for Exact Fit
#' #  ------------------------
#' #    X²      df    p
#' #  ------------------------
#' #    85.3    24    < .001
#' #  ------------------------
#' #
#' #
#' #  Fit Measures
#' #  -----------------------------------------------
#' #    CFI      TLI      RMSEA     Lower     Upper
#' #  -----------------------------------------------
#' #    0.931    0.896    0.0921    0.0714    0.114
#' #  -----------------------------------------------
#' #
#'
#' @param data the data as a data frame
#' @param factors a list containing named lists that define the \code{label}
#'   of the factor and the \code{vars} that belong to that factor
#' @param resCov a list of lists specifying the residual covariances that need
#'   to be estimated
#' @param miss \code{'listwise'} or \code{'fiml'}, how to handle missing
#'   values; \code{'listwise'} excludes a row from all analyses if one of its
#'   entries is missing, \code{'fiml'} uses a full information maximum
#'   likelihood method to estimate the model.
#' @param constrain \code{'facVar'} or \code{'facInd'}, how to contrain the
#'   model; \code{'facVar'} fixes the factor variances to one, \code{'facInd'}
#'   fixes each factor to the scale of its first indicator.
#' @param estTest \code{TRUE} (default) or \code{FALSE}, provide 'Z' and 'p'
#'   values for the model estimates
#' @param ci \code{TRUE} or \code{FALSE} (default), provide a confidence
#'   interval for the model estimates
#' @param ciWidth a number between 50 and 99.9 (default: 95) specifying the
#'   confidence interval width that is used as \code{'ci'}
#' @param stdEst \code{TRUE} or \code{FALSE} (default), provide a standardized
#'   estimate for the model estimates
#' @param factCovEst \code{TRUE} (default) or \code{FALSE}, provide estimates
#'   for the factor (co)variances
#' @param factInterceptEst \code{TRUE} or \code{FALSE} (default), provide
#'   estimates for the factor intercepts
#' @param resCovEst \code{TRUE} (default) or \code{FALSE}, provide estimates
#'   for the residual (co)variances
#' @param resInterceptEst \code{TRUE} or \code{FALSE} (default), provide
#'   estimates for the residual intercepts
#' @param fitMeasures one or more of \code{'cfi'}, \code{'tli'},
#'   \code{'srmr'}, \code{'rmsea'}, \code{'aic'}, or \code{'bic'}; use CFI, TLI,
#'   SRMR, RMSEA + 90\% confidence interval, adjusted AIC, and BIC model fit
#'   measures, respectively
#' @param modelTest \code{TRUE} (default) or \code{FALSE}, provide a
#'   chi-square test for exact fit that compares the model with the perfect
#'   fitting model
#' @param pathDiagram \code{TRUE} or \code{FALSE} (default), provide a path
#'   diagram of the model
#' @param corRes \code{TRUE} or \code{FALSE} (default), provide the residuals
#'   for the observed correlation matrix (i.e., the difference between the
#'   expected correlation matrix and the observed correlation matrix)
#' @param hlCorRes a number (default: 0.1), highlight values in the
#'   \code{'corRes'} table above this value
#' @param mi \code{TRUE} or \code{FALSE} (default), provide modification
#'   indices for the parameters not included in the model
#' @param hlMI a number (default: 3), highlight values in the
#'   \code{'modIndices'} tables above this value
#' @return A results object containing:
#' \tabular{llllll}{
#'   \code{results$factorLoadings} \tab \tab \tab \tab \tab a table containing the factor loadings \cr
#'   \code{results$factorEst$factorCov} \tab \tab \tab \tab \tab a table containing factor covariances estimates \cr
#'   \code{results$factorEst$factorIntercept} \tab \tab \tab \tab \tab a table containing factor intercept estimates \cr
#'   \code{results$resEst$resCov} \tab \tab \tab \tab \tab a table containing residual covariances estimates \cr
#'   \code{results$resEst$resIntercept} \tab \tab \tab \tab \tab a table containing residual intercept estimates \cr
#'   \code{results$modelFit$test} \tab \tab \tab \tab \tab a table containing the chi-square test for exact fit \cr
#'   \code{results$modelFit$fitMeasures} \tab \tab \tab \tab \tab a table containing fit measures \cr
#'   \code{results$modelPerformance$corRes} \tab \tab \tab \tab \tab a table containing residuals for the observed correlation matrix \cr
#'   \code{results$modelPerformance$modIndices} \tab \tab \tab \tab \tab a group \cr
#'   \code{results$pathDiagram} \tab \tab \tab \tab \tab an image containing the model path diagram \cr
#'   \code{results$modelSyntax} \tab \tab \tab \tab \tab the lavaan syntax used to fit the model \cr
#' }
#'
#' Tables can be converted to data frames with \code{asDF} or \code{\link{as.data.frame}}. For example:
#'
#' \code{results$factorLoadings$asDF}
#'
#' \code{as.data.frame(results$factorLoadings)}
#'
#' @export
cfa <- function(
    data,
    factors = list(
                list(label="Factor 1", vars=list())),
    resCov,
    miss = "fiml",
    constrain = "facVar",
    estTest = TRUE,
    ci = FALSE,
    ciWidth = 95,
    stdEst = FALSE,
    factCovEst = TRUE,
    factInterceptEst = FALSE,
    resCovEst = FALSE,
    resInterceptEst = FALSE,
    fitMeasures = list(
                "cfi",
                "tli",
                "rmsea"),
    modelTest = TRUE,
    pathDiagram = FALSE,
    corRes = FALSE,
    hlCorRes = 0.1,
    mi = FALSE,
    hlMI = 3) {

    if ( ! requireNamespace('jmvcore'))
        stop('cfa requires jmvcore to be installed (restart may be required)')

    if (missing(data))
        data <- jmvcore::marshalData(
            parent.frame())


    options <- cfaOptions$new(
        factors = factors,
        resCov = resCov,
        miss = miss,
        constrain = constrain,
        estTest = estTest,
        ci = ci,
        ciWidth = ciWidth,
        stdEst = stdEst,
        factCovEst = factCovEst,
        factInterceptEst = factInterceptEst,
        resCovEst = resCovEst,
        resInterceptEst = resInterceptEst,
        fitMeasures = fitMeasures,
        modelTest = modelTest,
        pathDiagram = pathDiagram,
        corRes = corRes,
        hlCorRes = hlCorRes,
        mi = mi,
        hlMI = hlMI)

    analysis <- cfaClass$new(
        options = options,
        data = data)

    analysis$run()

    analysis$results
}
