% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/anova.h.R
\name{ANOVA}
\alias{ANOVA}
\title{ANOVA}
\usage{
ANOVA(
  data,
  dep,
  factors = NULL,
  effectSize = NULL,
  modelTest = FALSE,
  modelTerms = NULL,
  ss = "3",
  homo = FALSE,
  norm = FALSE,
  qq = FALSE,
  contrasts = NULL,
  postHoc = NULL,
  postHocCorr = list("tukey"),
  postHocES = list(),
  emMeans = list(list()),
  emmPlots = TRUE,
  emmPlotData = FALSE,
  emmPlotError = "ci",
  emmTables = FALSE,
  emmWeights = TRUE,
  ciWidthEmm = 95,
  formula
)
}
\arguments{
\item{data}{the data as a data frame}

\item{dep}{the dependent variable from \code{data}, variable must be
numeric (not necessary when providing a formula, see examples)}

\item{factors}{the explanatory factors in \code{data} (not necessary when
providing a formula, see examples)}

\item{effectSize}{one or more of \code{'eta'}, \code{'partEta'}, or
\code{'omega'}; use eta², partial eta², and omega² effect sizes,
respectively}

\item{modelTest}{\code{TRUE} or \code{FALSE} (default); perform an overall
model test}

\item{modelTerms}{a formula describing the terms to go into the model (not
necessary when providing a formula, see examples)}

\item{ss}{\code{'1'}, \code{'2'} or \code{'3'} (default), the sum of
squares to use}

\item{homo}{\code{TRUE} or \code{FALSE} (default), perform homogeneity
tests}

\item{norm}{\code{TRUE} or \code{FALSE} (default), perform Shapiro-Wilk
tests of normality}

\item{qq}{\code{TRUE} or \code{FALSE} (default), provide a Q-Q plot of
residuals}

\item{contrasts}{a list of lists specifying the factor and type of contrast
to use, one of \code{'deviation'}, \code{'simple'}, \code{'difference'},
\code{'helmert'}, \code{'repeated'} or \code{'polynomial'}}

\item{postHoc}{a formula containing the terms to perform post-hoc tests on
(see the examples)}

\item{postHocCorr}{one or more of \code{'none'}, \code{'tukey'},
\code{'scheffe'}, \code{'bonf'}, or \code{'holm'}; provide no, Tukey,
Scheffe, Bonferroni, and Holm Post Hoc corrections respectively}

\item{postHocES}{a possible value of \code{'d'}; provide cohen's d measure
of effect size for the post-hoc tests}

\item{emMeans}{a formula containing the terms to estimate marginal means
for (see the examples)}

\item{emmPlots}{\code{TRUE} (default) or \code{FALSE}, provide estimated
marginal means plots}

\item{emmPlotData}{\code{TRUE} or \code{FALSE} (default), plot the data on
top of the marginal means}

\item{emmPlotError}{\code{'none'}, \code{'ci'} (default), or \code{'se'}.
Use no error bars, use confidence intervals, or use standard errors on the
marginal mean plots, respectively}

\item{emmTables}{\code{TRUE} or \code{FALSE} (default), provide estimated
marginal means tables}

\item{emmWeights}{\code{TRUE} (default) or \code{FALSE}, weigh each cell
equally or weigh them according to the cell frequency}

\item{ciWidthEmm}{a number between 50 and 99.9 (default: 95) specifying the
confidence interval width for the estimated marginal means}

\item{formula}{(optional) the formula to use, see the examples}
}
\value{
A results object containing:
\tabular{llllll}{
  \code{results$main} \tab \tab \tab \tab \tab a table of ANOVA results \cr
  \code{results$model} \tab \tab \tab \tab \tab The underlying \code{aov} object \cr
  \code{results$assump$homo} \tab \tab \tab \tab \tab a table of homogeneity tests \cr
  \code{results$assump$norm} \tab \tab \tab \tab \tab a table of normality tests \cr
  \code{results$assump$qq} \tab \tab \tab \tab \tab a q-q plot \cr
  \code{results$contrasts} \tab \tab \tab \tab \tab an array of contrasts tables \cr
  \code{results$postHoc} \tab \tab \tab \tab \tab an array of post-hoc tables \cr
  \code{results$emm} \tab \tab \tab \tab \tab an array of the estimated marginal means plots + tables \cr
}

Tables can be converted to data frames with \code{asDF} or \code{\link{as.data.frame}}. For example:

\code{results$main$asDF}

\code{as.data.frame(results$main)}
}
\description{
The Analysis of Variance (ANOVA) is used to explore the relationship
between a continuous dependent variable, and one or more categorical
explanatory variables.
}
\details{
ANOVA assumes that the residuals are normally distributed, and that the
variances of all groups are equal. If one is unwilling to assume that
the variances are equal, then a Welch's test can be used instead
(However, the Welch's test does not support more than one explanatory
factor). Alternatively, if one is unwilling to assume that the data is
normally distributed, a non-parametric approach (such as Kruskal-Wallis)
can be used.
}
\examples{
data('ToothGrowth')

ANOVA(formula = len ~ dose * supp, data = ToothGrowth)

#
#  ANOVA
#
#  ANOVA
#  -----------------------------------------------------------------------
#                 Sum of Squares    df    Mean Square    F        p
#  -----------------------------------------------------------------------
#    dose                   2426     2         1213.2    92.00    < .001
#    supp                    205     1          205.4    15.57    < .001
#    dose:supp               108     2           54.2     4.11     0.022
#    Residuals               712    54           13.2
#  -----------------------------------------------------------------------
#

ANOVA(
    formula = len ~ dose * supp,
    data = ToothGrowth,
    emMeans = ~ supp + dose:supp, # est. marginal means for supp and dose:supp
    emmPlots = TRUE,              # produce plots of those marginal means
    emmTables = TRUE)             # produce tables of those marginal means

}
