test_that("convert_to_omv works", {
    # check whether writing the data is working (file existence, size, contents [.omv-files are ZIP archives and must contain files that include meta, metadata.json, data.bin])
    nmeInp <- paste0(tempfile(), ".rds")
    nmeOut <- paste0(tempfile(), ".omv")
    saveRDS(datasets::ToothGrowth, nmeInp)
    convert_to_omv(fleInp = nmeInp, fleOut = nmeOut)
    expect_true(file.exists(nmeOut))
    expect_gt(file.info(nmeOut)$size, 1)
    expect_true(chkFle(nmeOut, isZIP = TRUE))
    expect_true(chkFle(nmeOut, "meta"))
    expect_true(chkFle(nmeOut, "metadata.json"))
    expect_true(chkFle(nmeOut, "data.bin"))
    unlink(nmeInp)
    unlink(nmeOut)
})
