% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/forestglm.R
\name{forestglmServer}
\alias{forestglmServer}
\title{forestglmServer:shiny module server for forestglm}
\usage{
forestglmServer(
  id,
  data,
  data_label,
  family,
  data_varStruct = NULL,
  nfactor.limit = 10,
  design.survey = NULL,
  repeated_id = NULL
)
}
\arguments{
\item{id}{id}

\item{data}{Reactive data}

\item{data_label}{Reactive data label}

\item{family}{family, "gaussian" or "binomial" or 'poisson' or 'quasipoisson'}

\item{data_varStruct}{Reactive List of variable structure, Default: NULL}

\item{nfactor.limit}{nlevels limit in factor variable, Default: 10}

\item{design.survey}{reactive survey data. default: NULL}

\item{repeated_id}{data when repeated id. default: F}
}
\value{
Shiny module server for forestglm
}
\description{
Shiny module server for forestglm
}
\details{
Shiny module server for forestglm
}
\examples{
library(shiny)
library(DT)
mtcars$vs <- factor(mtcars$vs)
mtcars$am <- factor(mtcars$am)
mtcars$kk <- factor(as.integer(mtcars$disp >= 150))
mtcars$kk1 <- factor(as.integer(mtcars$disp >= 200))

ui <- fluidPage(
  sidebarLayout(
    sidebarPanel(
      forestglmUI("Forest")
    ),
    mainPanel(
      tabsetPanel(
        type = "pills",
        tabPanel(
          title = "Data",
          DTOutput("tablesub"),
        ),
        tabPanel(
          title = "figure",
          plotOutput("forestplot", width = "100\%"),
          ggplotdownUI("Forest")
        )
      )
    )
  )
)

out <- mtcars

server <- function(input, output, session) {
  data <- reactive(out)
  label <- reactive(jstable::mk.lev(out))
  outtable <- forestglmServer("Forest", data = data, data_label = label, family = "binomial")
  output$tablesub <- renderDT({
    outtable()[[1]]
  })
  output$forestplot <- renderPlot({
    outtable()[[2]]
  })
}

}
\seealso{
\code{\link[jstable]{TableSubgroupMultiGLM}}
  \code{\link[data.table]{data.table-package}},\code{\link[data.table]{setDT}}, \code{\link[data.table]{setattr}}
 \code{\link[stats]{cor}}, \code{\link[stats]{coef}}
 \code{\link[survey]{surveysummary}}, \code{\link[survey]{svytable}}
 \code{\link[forestploter]{forest_theme}}, \code{\link[forestploter]{forest}}
 \code{\link[rvg]{dml}}
 \code{\link[officer]{read_pptx}}, \code{\link[officer]{add_slide}}, \code{\link[officer]{ph_with}}, \code{\link[officer]{ph_location}}
}
