% Generated by roxygen2 (4.0.1): do not edit by hand
\name{toJSON, fromJSON}
\alias{View}
\alias{fromJSON}
\alias{toJSON}
\alias{toJSON, fromJSON}
\title{Convert \R{} objects to/from \code{JSON}}
\usage{
fromJSON(txt, simplifyVector = TRUE, simplifyDataFrame = simplifyVector,
  simplifyMatrix = simplifyVector, flatten = FALSE, unicode = FALSE,
  validate = FALSE, ...)

toJSON(x, dataframe = c("rows", "columns"), matrix = c("rowmajor",
  "columnmajor"), Date = c("ISO8601", "epoch"), POSIXt = c("string",
  "ISO8601", "epoch", "mongo"), factor = c("string", "integer"),
  complex = c("string", "list"), raw = c("base64", "hex", "mongo"),
  null = c("list", "null"), na = c("null", "string"), auto_unbox = FALSE,
  digits = 4, pretty = FALSE, force = FALSE, ...)
}
\arguments{
\item{txt}{a \code{JSON} string, URL or file}

\item{simplifyVector}{coerce \code{JSON} arrays containing only primitives into an atomic vector}

\item{simplifyDataFrame}{coerce \code{JSON} arrays containing only records (\code{JSON} objects) into a data frame}

\item{simplifyMatrix}{coerce \code{JSON} arrays containing vectors of equal mode and dimension into matrix or array}

\item{flatten}{flatten nested data frames into a single non-nested data frame (see example)}

\item{unicode}{parse escaped (hexadecimal) unicode characters \code{\\uXXXX}. See details.}

\item{validate}{automatically \code{\link{validate}} \code{JSON} before parsing it.}

\item{x}{the object to be encoded}

\item{dataframe}{how to encode data.frame objects: must be one of 'rows' or 'columns'}

\item{matrix}{how to encode matrices and higher dimensional arrays: must be one of 'rowmajor' or 'columnmajor'.}

\item{Date}{how to encode Date objects: must be one of 'ISO8601' or 'epoch'}

\item{POSIXt}{how to encode POSIXt (datetime) objects: must be one of 'string', 'ISO8601', 'epoch' or 'mongo'}

\item{factor}{how to encode factor objects: must be one of 'string' or 'integer'}

\item{complex}{how to encode complex numbers: must be one of 'string' or 'list'}

\item{raw}{how to encode raw objects: must be one of 'base64', 'hex' or 'mongo'}

\item{null}{how to encode NULL values within a list: must be one of 'null' or 'list'}

\item{na}{how to print NA values: must be one of 'null' or 'string'. Defaults are class specific}

\item{auto_unbox}{automatically \code{\link{unbox}} all atomic vectors of length 1. Not recommended!}

\item{digits}{max number of digits (after the dot) to print for numeric values. See: \code{\link{round}}}

\item{force}{unclass/skip objects of classes with no defined \code{JSON} mapping}

\item{pretty}{adds indentation whitespace to \code{JSON} output. See \code{\link{prettify}}}

\item{...}{arguments passed on to class specific \code{print} methods}
}
\description{
These functions are used to convert between \code{JSON} data and \R{} objects. The \code{\link{toJSON}} and \code{\link{fromJSON}}
functions use a class based mapping, which follows conventions outlined in this paper:  \url{http://arxiv.org/abs/1403.2805} (also available as vignette).
}
\details{
The \code{\link{toJSON}} and \code{\link{fromJSON}} functions are drop-in replacements for the identically named functions
in packages \code{rjson} and \code{RJSONIO}. Our implementation uses an alternative, somewhat more consistent mapping
between \R{} objects and \code{JSON} strings.

The \code{\link{serializeJSON}} and \code{\link{unserializeJSON}} functions in this package use an
alternative system to convert between \R{} objects and \code{JSON}, which supports more classes but is much more verbose.

A \code{JSON} string is always unicode, using \code{UTF-8} by default, hence there is usually no need to escape any characters.
However, the \code{JSON} format does support escaping of unicode characters, which are encoded using a backslash followed by
a lower case \code{"u"} and 4 hex characters, for example: \code{"Z\\u00FCrich"}. The \code{fromJSON} function
will only parse such escape sequences correctly when the \code{unicode} argument is set to \code{TRUE}. Because this introduces
significant performance overhead, it is disabled by default. It is strongly preferable to encode unicode characters in \code{JSON}
using native \code{UTF-8} rather than escape sequences.
}
\examples{
#stringify some data
jsoncars <- toJSON(mtcars, pretty=TRUE)
cat(jsoncars)

#parse it back
fromJSON(jsoncars)

#parsing escaped unicode
fromJSON('{"city" : "Z\\\\u00FCrich"}', unicode = TRUE)

\dontrun{
# Parse data frame
data1 <- fromJSON("https://api.github.com/users/hadley/orgs")
names(data1)
data1$login

#nested data frames:
data2 <- fromJSON("https://api.github.com/users/hadley/repos")
names(data2)
names(data2$owner)
data2$owner$login

#same data, but now flattened:
data3 <- fromJSON("https://api.github.com/users/hadley/repos", flatten=TRUE)
names(data3)
}

#control scientific notation
toJSON(10 ^ (0:10))
options(scipen=3)
toJSON(10 ^ (0:10))
}
\references{
Jeroen Ooms (2014). The \code{jsonlite} Package: A Practical and Consistent Mapping Between \code{JSON} Data and \R{} Objects. \emph{arXiv:1403.2805}. \url{http://arxiv.org/abs/1403.2805}
}

