% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/svytools.R
\name{weights_tests}
\alias{weights_tests}
\title{Test whether sampling weights are needed}
\usage{
weights_tests(model, weights, data, model_output = TRUE, test = NULL,
  sims = 1000, digits = getOption("jtools-digits", default = 2))
}
\arguments{
\item{model}{The fitted model, without weights}

\item{weights}{The name of the weights column in \code{model}'s data frame
or a vector of weights equal in length to the number of observations
included in \code{model}.}

\item{data}{The data frame with the data fed to the fitted model and the
weights}

\item{model_output}{Should a summary of the model with weights as predictor
be printed? Default is TRUE, but you may not want it if you are trying to
declutter a document.}

\item{test}{Which type of test should be used in the ANOVA? The default,
\code{NULL}, chooses based on the model type ("F" for linear models).
This argument is passed to \code{anova}.}

\item{sims}{The number of bootstrap simulations to use in estimating the
variance of the residual correlation. Default is 1000, but for publications
or when computing power/time is sufficient, a higher number is better.}

\item{digits}{An integer specifying the number of digits past the decimal to
report in the output. Default is 3. You can change the default number of
digits for all jtools functions with
\code{options("jtools-digits" = digits)} where digits is the desired number.}
}
\description{
Use the tests proposed in Pfeffermann and Sverchkov (1999)
and DuMouchel and Duncan (1983) to check whether
a regression model is specified correctly without weights.
}
\details{
This function is a wrapper for the two tests implemented in this package that
test whether your regression model is correctly specified. The first is
\code{\link{wgttest}}, an R adaptation of the Stata macro of the same name.
This test can otherwise be referred to as the DuMouchel-Duncan test. The
other test is the Pfeffermann-Sverchkov test, which can be accessed directly
with \code{\link{pf_sv_test}}.

For more details on each, visit the documentation on the respective functions.
This function just runs each of them for you.
}
\examples{

# Note: This is a contrived example to show how the function works,
# not a case with actual sammpling weights from a survey vendor
if (requireNamespace("boot")) {
  states <- as.data.frame(state.x77)
  set.seed(100)
  states$wts <- runif(50, 0, 3)
  fit <- lm(Murder ~ Illiteracy + Frost, data = states)
  weights_tests(model = fit, data = states, weights = wts, sims = 100)
}

}
\references{
DuMouchel, W. H. & Duncan, D.J. (1983). Using sample survey weights in
multiple regression analyses of stratified samples. \emph{Journal of the
American Statistical Association}, \emph{78}. 535-543.

Nordberg, L. (1989). Generalized linear modeling of sample survey data.
\emph{Journal of Official Statistics; Stockholm}, \emph{5}, 223-239.

Pfeffermann, D., & Sverchkov, M. (1999). Parametric and semi-parametric
estimation of regression models fitted to survey data.
\emph{Sankhya: The Indian Journal of Statistics}, \emph{61}. 166-186.
}
\seealso{
Other survey tools: \code{\link{pf_sv_test}},
  \code{\link{svycor}}, \code{\link{svysd}},
  \code{\link{wgttest}}
}
\concept{survey tools}
