% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/event_date.R,
%   R/event_resample.R
\docType{methods}
\name{event}
\alias{event}
\alias{event-method}
\alias{predict_event}
\alias{predict_event-method}
\alias{predict_accumulation}
\alias{predict_accumulation-method}
\alias{event,CountMatrix,numeric-method}
\alias{predict_event,EventDate,missing-method}
\alias{predict_event,EventDate,CountMatrix-method}
\alias{predict_accumulation,EventDate,missing-method}
\alias{predict_accumulation,EventDate,CountMatrix-method}
\alias{jackknife,EventDate-method}
\alias{bootstrap,EventDate-method}
\title{Event and Accumulation Dates}
\usage{
event(object, dates, ...)

predict_event(object, data, ...)

predict_accumulation(object, data, ...)

\S4method{event}{CountMatrix,numeric}(object, dates, cutoff = 90, level = 0.95, ...)

\S4method{predict_event}{EventDate,missing}(object, margin = 1, level = 0.95)

\S4method{predict_event}{EventDate,CountMatrix}(object, data, margin = 1, level = 0.95)

\S4method{predict_accumulation}{EventDate,missing}(object)

\S4method{predict_accumulation}{EventDate,CountMatrix}(object, data)

\S4method{jackknife}{EventDate}(object, level = 0.95, progress = getOption("kairos.progress"), ...)

\S4method{bootstrap}{EventDate}(
  object,
  level = 0.95,
  probs = c(0.05, 0.95),
  n = 1000,
  progress = getOption("kairos.progress"),
  ...
)
}
\arguments{
\item{object}{A \link[arkhe:CountMatrix-class]{arkhe::CountMatrix} or a \linkS4class{EventDate} object.}

\item{dates}{A \code{\link{numeric}} vector of dates. If named, the names must match
the row names of \code{object}.}

\item{...}{Further arguments to be passed to internal methods.}

\item{data}{A \link[arkhe:CountMatrix-class]{arkhe::CountMatrix} object for which to predict event
and accumulation dates.}

\item{cutoff}{An \code{\link{integer}} giving the cumulative percentage of variance
used to select CA factorial components for linear model fitting (see
details). All compounds with a cumulative percentage of variance of less
than the \code{cutoff} value will be retained.}

\item{level}{A length-one \code{\link{numeric}} vector giving the confidence level.}

\item{margin}{A \code{\link{numeric}} vector giving the subscripts which the prediction
will be applied over: \code{1} indicates rows, \code{2} indicates columns.}

\item{progress}{A \code{\link{logical}} scalar: should a progress bar be displayed?}

\item{probs}{A \code{\link{numeric}} vector of probabilities with values in
\eqn{[0,1]} (see \code{\link[stats:quantile]{stats::quantile()}}). If \code{NULL}, quantiles are not
computed.}

\item{n}{A non-negative \code{\link{integer}} giving the number of bootstrap
replications.}
}
\value{
\itemize{
\item \code{event()} returns an \linkS4class{EventDate} object.
\item \code{predict_event()} returns a \code{\link{data.frame}}.
\item \code{predict_accumulation()} returns a \linkS4class{MeanDate} object.
\item \code{bootstrap()} and \code{jackknife()} return a \code{\link{data.frame}}.
}
}
\description{
\itemize{
\item \code{event()} fit a date event model.
\item \code{predict_event()} and \code{predict_accumulation()} estimates the event and
accumulation dates of an assemblage.
}
}
\details{
This is an implementation of the chronological modeling method proposed by
Bellanger and Husi (2012, 2013).

Event and accumulation dates are density estimates of the occupation and
duration of an archaeological site (Bellanger and Husi 2012, 2013).
The event date is an estimation of the \emph{terminus post-quem} of an
archaeological assemblage. The accumulation date represents the
"chronological profile" of the assemblage. According to Bellanger and Husi
(2012), accumulation date can be interpreted "at best [...] as a formation
process reflecting the duration or succession of events on the scale of
archaeological time, and at worst, as imprecise dating due to contamination
of the context by residual or intrusive material." In other words,
accumulation dates estimate occurrence of archaeological events and rhythms
of the long term.

This method relies on strong archaeological and statistical assumptions
(see \code{vignette("kairos")}).
}
\note{
Bellanger \emph{et al.} did not publish the data supporting their demonstration:
no replication of their results is possible. This implementation must be
considered \strong{experimental} and subject to major changes in a future
release.
}
\section{Resampling}{

If \code{jackknife()} is used, one type/fabric is removed at a
time and all statistics are recalculated. In this way, one can assess
whether certain type/fabric has a substantial influence on the date
estimate.
A three columns \code{data.frame} is returned, giving the results of
the resampling procedure (jackknifing fabrics) for each assemblage (in rows)
with the following columns:
\describe{
\item{\code{mean}}{The jackknife mean (event date).}
\item{\code{bias}}{The jackknife estimate of bias.}
\item{\code{error}}{The standard error of predicted means.}
}

If \code{bootstrap()} is used, a large number of new bootstrap assemblages is
created, with the same sample size, by resampling each of the original
assemblage with replacement. Then, examination of the bootstrap statistics
makes it possible to pinpoint assemblages that require further
investigation.

A five columns \code{data.frame} is returned, giving the bootstrap
distribution statistics for each replicated assemblage (in rows)
with the following columns:
\describe{
\item{\code{min}}{Minimum value.}
\item{\code{mean}}{Mean value (event date).}
\item{\code{max}}{Maximum value.}
\item{\code{Q5}}{Sample quantile to 0.05 probability.}
\item{\code{Q95}}{Sample quantile to 0.95 probability.}
}
}

\examples{
\dontrun{
utils::vignette("kairos")
}
}
\references{
Bellanger, L. & Husi, P. (2013). Mesurer et modéliser le temps inscrit dans
la matière à partir d'une source matérielle : la céramique médiévale.
In \emph{Mesure et Histoire Médiévale}. Histoire ancienne et médiévale.
Paris: Publication de la Sorbonne, p. 119-134.

Bellanger, L. & Husi, P. (2012). Statistical Tool for Dating and
Interpreting Archaeological Contexts Using Pottery. \emph{Journal of
Archaeological Science}, 39(4), 777-790. \doi{10.1016/j.jas.2011.06.031}.

Bellanger, L., Tomassone, R. & Husi, P. (2008). A Statistical Approach for
Dating Archaeological Contexts. \emph{Journal of Data Science}, 6, 135-154.

Bellanger, L., Husi, P. & Tomassone, R. (2006). Une approche statistique
pour la datation de contextes archéologiques. \emph{Revue de Statistique
Appliquée}, 54(2), 65-81.

Bellanger, L., Husi, P. & Tomassone, R. (2006). Statistical Aspects of
Pottery Quantification for the Dating of Some Archaeological Contexts.
\emph{Archaeometry}, 48(1), 169-183. \doi{10.1111/j.1475-4754.2006.00249.x}.

Poblome, J. & Groenen, P. J. F. (2003). Constrained Correspondence Analysis
for Seriation of Sagalassos Tablewares. In Doerr, M. & Apostolis, S. (eds.),
\emph{The Digital Heritage of Archaeology}. Athens: Hellenic Ministry of Culture.
}
\seealso{
\link[=plot]{plot_event}

Other dating methods: 
\code{\link{mcd}()}
}
\author{
N. Frerebeau
}
\concept{dating methods}
