% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/mcd.R
\docType{methods}
\name{resample}
\alias{resample}
\alias{bootstrap}
\alias{bootstrap-method}
\alias{jackknife}
\alias{jackknife-method}
\alias{bootstrap,MeanDate-method}
\alias{jackknife,MeanDate-method}
\alias{simulate,MeanDate-method}
\title{Resampling Methods}
\usage{
bootstrap(object, ...)

jackknife(object, ...)

\S4method{bootstrap}{MeanDate}(object, n = 1000, f = NULL)

\S4method{jackknife}{MeanDate}(object)

\S4method{simulate}{MeanDate}(
  object,
  n = 1000,
  interval = c("student", "normal", "percentiles"),
  level = 0.8
)
}
\arguments{
\item{object}{An object.}

\item{...}{Currently not used}

\item{n}{A non-negative \code{\link{integer}} specifying the number of bootstrap
replications.}

\item{f}{A \code{\link{function}} that takes a single numeric vector (the result of
the resampling procedure) as argument.}

\item{interval}{A \code{\link{character}} string giving the type of confidence
interval to be returned. It must be one "\code{student}" (the default),
"\code{normal}" or "\code{percentiles}". Any unambiguous substring can be given.}

\item{level}{A length-one \code{\link{numeric}} vector giving the confidence level.}
}
\value{
If \code{f} is \code{NULL}, \code{bootstrap()} and \code{jackknife()} return a \code{\link{data.frame}}
with the following elements (else, returns the result of \code{f} applied to the
\code{n} resampled values) :
\describe{
\item{original}{The observed value.}
\item{mean}{The bootstrap/jackknife estimate of mean.}
\item{bias}{The bootstrap/jackknife estimate of bias.}
\item{error}{The boostrap/jackknife estimate of standard erro.}
}
}
\description{
\itemize{
\item \code{bootstrap()} generate bootstrap estimations of a statistic.
\item \code{jackknife()} generate jackknife estimations of a statistic.
}
}
\author{
N. Frerebeau
}
\concept{resampling methods}
