% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kanjistat-package.R
\docType{data}
\encoding{UTF-8}
\name{pooled_similarity}
\alias{pooled_similarity}
\title{Precomputed kanji distances}
\format{
A tibble containing kanji similarity judgments by 3 "native or native-like"
speakers of Japanese. For each row, the pivot kanji was compared to a list of
potential distractors. From the distractors, the subjects selected one
character which they found particularly easy to confuse with the pivot. For
the exact methodology, see the original study referenced below.
}
\source{
Datasets from \url{https://lars.yencken.org/datasets}, made available under the
Creative Commons Attribution 3.0 Unported licence.

Collected as part of \emph{Yencken, Lars (2010)
\href{https://lars.yencken.org/papers/phd-thesis.pdf}{Orthographic support for passing the reading hurdle in Japanese}.
PhD Thesis, University of Melbourne, Melbourne, Australia}.
}
\usage{
pooled_similarity
}
\description{
Precomputed kanji distances
}
\examples{
# Get kanji characters that were found to be easily confused with \u5927.
pooled_similarity[pooled_similarity$selected == "\u5927", ]$pivot

}
\references{
Yencken, Lars, & Baldwin, Timothy (2008). Measuring and predicting orthographic associations:
Modelling the similarity of Japanese kanji. In: \emph{Proceedings of the 22nd International Conference on Computational
Linguistics (Coling 2008)}, pp. 1041-1048.
}
\keyword{datasets}
