% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/base_list_append.R
\name{list.append}
\alias{list.append}
\title{list.append}
\usage{
list.append(main_list, append_list, ...)
}
\arguments{
\item{main_list}{A list, to which another should be appended.}

\item{append_list}{A list to append to \code{main_list} (can be \code{NULL} or empty).}

\item{...}{Further arguments passed to \code{utils::modifyList()}.}
}
\value{
A \code{list} is returned.
}
\description{
Helper function to append an R list.
}
\details{
This function is a save wrapper around \code{utils::modifyLists} to
combine lists as it checks for the input types and only appends the new
list if its length is greater than 0.
}
\examples{
l1 <- list("a" = 1, "b" = 2)
l2 <- list("c" = 3, "d" = 4)
list.append(l1, l2)
}
\seealso{
\code{\link[utils:modifyList]{utils::modifyList()}}
}
