% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/initializers.R
\name{initializer_variance_scaling}
\alias{initializer_variance_scaling}
\title{Initializer capable of adapting its scale to the shape of weights.}
\usage{
initializer_variance_scaling(scale = 1, mode = c("fan_in", "fan_out",
  "fan_avg"), distribution = c("normal", "uniform"), seed = NULL)
}
\arguments{
\item{scale}{Scaling factor (positive float).}

\item{mode}{One of "fan_in", "fan_out", "fan_avg".}

\item{distribution}{One of "normal", "uniform"}

\item{seed}{Integer used to seed the random generator.}
}
\description{
With \code{distribution="normal"}, samples are drawn from a truncated normal
distribution centered on zero, with \code{stddev = sqrt(scale / n)} where n is:
\itemize{
\item number of input units in the weight tensor, if mode = "fan_in"
\item number of output units, if mode = "fan_out"
\item average of the numbers of input and output units, if mode = "fan_avg"
}
}
\details{
With \code{distribution="uniform"}, samples are drawn from a uniform distribution
within \code{-limit, limit}, with \code{limit = sqrt(3 * scale / n)}.
}
\seealso{
Other initializers: \code{\link{initializer_constant}},
  \code{\link{initializer_glorot_normal}},
  \code{\link{initializer_glorot_uniform}},
  \code{\link{initializer_he_normal}},
  \code{\link{initializer_he_uniform}},
  \code{\link{initializer_identity}},
  \code{\link{initializer_lecun_normal}},
  \code{\link{initializer_lecun_uniform}},
  \code{\link{initializer_ones}},
  \code{\link{initializer_orthogonal}},
  \code{\link{initializer_random_normal}},
  \code{\link{initializer_random_uniform}},
  \code{\link{initializer_truncated_normal}},
  \code{\link{initializer_zeros}}
}
