% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model.R
\name{predict_generator}
\alias{predict_generator}
\title{Generates predictions for the input samples from a data generator.}
\usage{
predict_generator(object, generator, steps, max_queue_size = 10,
  workers = 1, verbose = 0, callbacks = NULL)
}
\arguments{
\item{object}{Keras model object}

\item{generator}{Generator yielding batches of input samples.}

\item{steps}{Total number of steps (batches of samples) to yield from
\code{generator} before stopping.}

\item{max_queue_size}{Maximum size for the generator queue. If unspecified,
\code{max_queue_size} will default to 10.}

\item{workers}{Maximum number of threads to use for parallel processing. Note that
parallel processing will only be performed for native Keras generators (e.g.
\code{flow_images_from_directory()}) as R based generators must run on the main thread.}

\item{verbose}{verbosity mode, 0 or 1.}

\item{callbacks}{List of callbacks to apply during prediction.}
}
\value{
Numpy array(s) of predictions.
}
\description{
The generator should return the same kind of data as accepted by
\code{predict_on_batch()}.
}
\section{Raises}{
 ValueError: In case the generator yields data in an invalid
format.
}

\seealso{
Other model functions: \code{\link{compile.keras.engine.training.Model}},
  \code{\link{evaluate.keras.engine.training.Model}},
  \code{\link{evaluate_generator}},
  \code{\link{fit.keras.engine.training.Model}},
  \code{\link{fit_generator}}, \code{\link{get_config}},
  \code{\link{get_layer}},
  \code{\link{keras_model_sequential}},
  \code{\link{keras_model}}, \code{\link{multi_gpu_model}},
  \code{\link{pop_layer}},
  \code{\link{predict.keras.engine.training.Model}},
  \code{\link{predict_on_batch}},
  \code{\link{predict_proba}},
  \code{\link{summary.keras.engine.training.Model}},
  \code{\link{train_on_batch}}
}
\concept{model functions}
