% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layers-preprocessing.R
\name{layer_random_height}
\alias{layer_random_height}
\title{Randomly vary the height of a batch of images during training}
\usage{
layer_random_height(
  object,
  factor,
  interpolation = "bilinear",
  seed = NULL,
  ...
)
}
\arguments{
\item{object}{What to call the new \code{Layer} instance with. Typically a keras
\code{Model}, another \code{Layer}, or a \code{tf.Tensor}/\code{KerasTensor}. If \code{object} is
missing, the \code{Layer} instance is returned, otherwise, \code{layer(object)} is
returned.}

\item{factor}{A positive float (fraction of original height), or a list of size 2
representing lower and upper bound for resizing vertically. When
represented as a single float, this value is used for both the upper and
lower bound. For instance, \code{factor = c(0.2, 0.3)} results in an output with
height changed by a random amount in the range \verb{[20\%, 30\%]}.
\code{factor = c(-0.2, 0.3)} results in an output with height changed by a random
amount in the range \verb{[-20\%, +30\%]}. \code{factor=0.2} results in an output with
height changed by a random amount in the range \verb{[-20\%, +20\%]}.}

\item{interpolation}{String, the interpolation method. Defaults to \code{"bilinear"}.
Supports \code{"bilinear"}, \code{"nearest"}, \code{"bicubic"}, \code{"area"},
\code{"lanczos3"}, \code{"lanczos5"}, \code{"gaussian"}, \code{"mitchellcubic"}.}

\item{seed}{Integer. Used to create a random seed.}

\item{...}{standard layer arguments.}
}
\description{
Randomly vary the height of a batch of images during training
}
\details{
Adjusts the height of a batch of images by a random factor. The input
should be a 3D (unbatched) or 4D (batched) tensor in the \code{"channels_last"}
image data format.

By default, this layer is inactive during inference.
}
\seealso{
\itemize{
\item \url{https://www.tensorflow.org/api_docs/python/tf/keras/layers/RandomHeight}
\item \url{https://keras.io/api/layers/preprocessing_layers/}
}

Other image augmentation layers: 
\code{\link{layer_random_contrast}()},
\code{\link{layer_random_crop}()},
\code{\link{layer_random_flip}()},
\code{\link{layer_random_rotation}()},
\code{\link{layer_random_translation}()},
\code{\link{layer_random_width}()},
\code{\link{layer_random_zoom}()}

Other preprocessing layers: 
\code{\link{layer_category_encoding}()},
\code{\link{layer_center_crop}()},
\code{\link{layer_discretization}()},
\code{\link{layer_hashing}()},
\code{\link{layer_integer_lookup}()},
\code{\link{layer_normalization}()},
\code{\link{layer_random_contrast}()},
\code{\link{layer_random_crop}()},
\code{\link{layer_random_flip}()},
\code{\link{layer_random_rotation}()},
\code{\link{layer_random_translation}()},
\code{\link{layer_random_width}()},
\code{\link{layer_random_zoom}()},
\code{\link{layer_rescaling}()},
\code{\link{layer_resizing}()},
\code{\link{layer_string_lookup}()},
\code{\link{layer_text_vectorization}()}
}
\concept{image augmentation layers}
\concept{preprocessing layers}
