% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layers-pooling.R
\name{layer_global_max_pooling_3d}
\alias{layer_global_max_pooling_3d}
\title{Global Max pooling operation for 3D data.}
\usage{
layer_global_max_pooling_3d(object, data_format = NULL, keepdims = FALSE, ...)
}
\arguments{
\item{object}{What to call the new \code{Layer} instance with. Typically a keras
\code{Model}, another \code{Layer}, or a \code{tf.Tensor}/\code{KerasTensor}. If \code{object} is
missing, the \code{Layer} instance is returned, otherwise, \code{layer(object)} is
returned.}

\item{data_format}{A string, one of \code{channels_last} (default) or
\code{channels_first}. The ordering of the dimensions in the inputs.
\code{channels_last} corresponds to inputs with shape \verb{(batch, spatial_dim1, spatial_dim2, spatial_dim3, channels)} while \code{channels_first} corresponds
to inputs with shape \verb{(batch, channels, spatial_dim1, spatial_dim2, spatial_dim3)}. It defaults to the \code{image_data_format} value found in your
Keras config file at \verb{~/.keras/keras.json}. If you never set it, then it
will be "channels_last".}

\item{keepdims}{A boolean, whether to keep the spatial dimensions or not. If
\code{keepdims} is \code{FALSE} (default), the rank of the tensor is reduced for
spatial dimensions. If \code{keepdims} is \code{TRUE}, the spatial dimensions are
retained with length 1. The behavior is the same as for \code{tf.reduce_mean} or
\code{np.mean}.}

\item{...}{standard layer arguments.}
}
\description{
Global Max pooling operation for 3D data.
}
\section{Input shape}{

\itemize{
\item If \code{data_format='channels_last'}: 5D tensor with shape: \verb{(batch_size, spatial_dim1, spatial_dim2, spatial_dim3, channels)}
\item If \code{data_format='channels_first'}: 5D tensor with shape: \verb{(batch_size, channels, spatial_dim1, spatial_dim2, spatial_dim3)}
}
}

\section{Output shape}{
 2D tensor with shape: \verb{(batch_size, channels)}
}

\seealso{
Other pooling layers: 
\code{\link{layer_average_pooling_1d}()},
\code{\link{layer_average_pooling_2d}()},
\code{\link{layer_average_pooling_3d}()},
\code{\link{layer_global_average_pooling_1d}()},
\code{\link{layer_global_average_pooling_2d}()},
\code{\link{layer_global_average_pooling_3d}()},
\code{\link{layer_global_max_pooling_1d}()},
\code{\link{layer_global_max_pooling_2d}()},
\code{\link{layer_max_pooling_1d}()},
\code{\link{layer_max_pooling_2d}()},
\code{\link{layer_max_pooling_3d}()}
}
\concept{pooling layers}
