% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/image-utils.R
\name{image_from_array}
\alias{image_from_array}
\title{Converts a 3D array to a PIL Image instance.}
\usage{
image_from_array(x, data_format = NULL, scale = TRUE, dtype = NULL)
}
\arguments{
\item{x}{Input data, in any form that can be converted to an array.}

\item{data_format}{Image data format, can be either \code{"channels_first"} or
\code{"channels_last"}. Defaults to \code{NULL}, in which case the global
setting \code{config_image_data_format()} is used (unless you
changed it, it defaults to \code{"channels_last"}).}

\item{scale}{Whether to rescale the image such that minimum and maximum values
are 0 and 255 respectively. Defaults to \code{TRUE}.}

\item{dtype}{Dtype to use. \code{NULL} means the global setting
\code{config_floatx()} is used (unless you changed it, it
defaults to \code{"float32"}). Defaults to \code{NULL}.}
}
\value{
A PIL Image instance.
}
\description{
Converts a 3D array to a PIL Image instance.
}
\section{Usage}{
\if{html}{\out{<div class="sourceCode r">}}\preformatted{img <- array(runif(30000), dim = c(100, 100, 3))
pil_img <- image_from_array(img)
pil_img
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## <PIL.Image.Image image mode=RGB size=100x100>

}\if{html}{\out{</div>}}
}

\seealso{
Other image utils: \cr
\code{\link{image_array_save}()} \cr
\code{\link{image_load}()} \cr
\code{\link{image_smart_resize}()} \cr
\code{\link{image_to_array}()} \cr
\code{\link{op_image_affine_transform}()} \cr
\code{\link{op_image_extract_patches}()} \cr
\code{\link{op_image_map_coordinates}()} \cr
\code{\link{op_image_pad}()} \cr
\code{\link{op_image_resize}()} \cr

Other utils: \cr
\code{\link{audio_dataset_from_directory}()} \cr
\code{\link{clear_session}()} \cr
\code{\link{config_disable_interactive_logging}()} \cr
\code{\link{config_disable_traceback_filtering}()} \cr
\code{\link{config_enable_interactive_logging}()} \cr
\code{\link{config_enable_traceback_filtering}()} \cr
\code{\link{config_is_interactive_logging_enabled}()} \cr
\code{\link{config_is_traceback_filtering_enabled}()} \cr
\code{\link{get_file}()} \cr
\code{\link{get_source_inputs}()} \cr
\code{\link{image_array_save}()} \cr
\code{\link{image_dataset_from_directory}()} \cr
\code{\link{image_load}()} \cr
\code{\link{image_smart_resize}()} \cr
\code{\link{image_to_array}()} \cr
\code{\link{layer_feature_space}()} \cr
\code{\link{layer_torch_module_wrapper}()} \cr
\code{\link{normalize}()} \cr
\code{\link{pack_x_y_sample_weight}()} \cr
\code{\link{pad_sequences}()} \cr
\code{\link{set_random_seed}()} \cr
\code{\link{split_dataset}()} \cr
\code{\link{text_dataset_from_directory}()} \cr
\code{\link{timeseries_dataset_from_array}()} \cr
\code{\link{to_categorical}()} \cr
\code{\link{unpack_x_y_sample_weight}()} \cr
\code{\link{zip_lists}()} \cr
}
\concept{image utils}
\concept{utils}
