\name{mboAll}
\alias{mboAll}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
Efficient global optimization inclusive meta model validation
}
\description{
Implements the efficient global optimization algorithm based on Kriging. It is a wrapper around \code{\link{mbo1d}} and additionally includes latin hypercube design generation and meta model validation of the Kriging model.
}
\usage{
mboAll(loss_func, n_steps, initDesign, lower_bounds, 
upper_bounds, x_start, isoInput=FALSE, addInfo=TRUE, 
maxRuns=3, repetitions=5, tol_input=.Machine$double.eps^0.25, 
nCores=1, envir=parent.frame(), metaModelSelect=TRUE)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
\item{loss_func}{
Loss function to be minimized.
}
\item{n_steps}{
Number of steps of the EGO algorithm.
}
\item{initDesign}{
Number of initial design points to be evaluated. The higher the number, the more function evaluations of the loss function are required, but the approximation with Kriging will be more accurate.
}
\item{lower_bounds}{
Vector of lower bounds of the tuning parameters. First element is the lower bound of the first tuning parameter, second element the lower bound of the next tuning parameter etc.
}
\item{upper_bounds}{
Vector of upper bounds of the tuning parameters. First element is the upper bound of the first tuning parameter, second element the upper bound of the next tuning parameter etc.
}
\item{x_start}{
Starting value of the one dimensional optimization algorithm. See \code{\link{optimize1dMulti}}.
}
\item{isoInput}{
Force the covariance structure of the km to have only one range parameter. For details see \code{\link[DiceKriging]{km}}
}
\item{addInfo}{
Should additional information be displayed during optimization? (logical value). Default is TRUE.
}
\item{maxRuns}{
Maximal number of iterations in the conditional optimization. Default is three. See \code{\link{optimize1dMulti}}.
}
\item{repetitions}{
Maximal number of random starting values for helping to avoid local optima. Default is five. See \code{\link{optimize1dMulti}}.
}
\item{tol_input}{
Convergence criteria of each one dimensional sub-optimization. Higher values will be more accurate, but require much more function evaluations. Default is the fourth root of the machine double accuracy. See \code{\link{optimize1dMulti}}.
}
\item{nCores}{
Specifies how many cores are used in tuning (integer scalar). Default=1 is serial processing.
}
\item{envir}{
Internal variable to store environments. Default is to look up in a one level higher environment. Modification is unnecessary.
}
\item{metaModelSelect}{
Should the covariance kernel of the Kriging model be automatically selected? (logical scalar) Default is TRUE and corresponds to the 5/2 materin covariance structure.
}
}
\details{
In addition to the function \code{\link{mbo1d}} a latin hypercube design will be generated. The design is generated by maximizing the minimum distance between the design points (maximin criteria). For reference see \code{\link[lhs]{maximinLHS}}. Then the complete initial design is evaluated with the loss function. The model validation of Kriging searches for the best covariance kernel structure between five alternative specifications (see \code{\link[DiceKriging]{covTensorProduct-class}}). The performance is evaluated with a Gaussian likelihood with leave one out estimated expectations and variances of the Kriging model.
}

%return(list(par=c(ego_result), value=attr(ego_result, "funcVal")))

\value{
List with following components:
\itemize{
\item{par: }{Best found parameter values}
\item{value: }{Function value at the best found parameters}
}
}

\references{
Michael Stein, (1987), 
\emph{Large Sample Properties of Simulations Using Latin Hypercube Sampling},
Technometrics. 29, 143-151

Carl Edward Rasmussen and Christopher K. I. Williams, (2006), 
\emph{Gaussian Processes for Machine Learning},
Massachusetts Institute of Technology
}

\author{
Thomas Welchowski \email{welchow@imbie.meb.uni-bonn.de}
}

\note{
Function is supplied for model customization and intended for the experienced user. The more user friendly function \code{\link{tuneMboKDSN}} uses this code as intermediate step.
}

%% ~Make other sections like Warning with \section{Warning }{....} ~

\seealso{
\code{\link[DiceKriging]{km}}, \code{\link[DiceKriging]{leaveOneOut.km}}, \code{\link[lhs]{maximinLHS}}, \code{\link{tuneMboKDSN}}, \code{\link{mbo1d}}
}

\examples{
# Example with Branin function
library(globalOptTests)
tryBranin <- mboAll (loss_func=function (x) goTest(par=x, fnName="Branin", 
checkDim = FALSE), n_steps=5, initDesign=15, lower_bounds=c(-5, 0), 
upper_bounds=c(10, 15), x_start=c(5, -5))
abs(tryBranin$value-getGlobalOpt("Branin"))
}

% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{ models & regression }
%\keyword{ ~kwd2 }% __ONLY ONE__ keyword per line