% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bandwidth.R
\name{bw.silv}
\alias{bw.silv}
\alias{bw.scott}
\title{Bandwidth selector for multivariate kernel density estimation}
\usage{
bw.silv(x, na.rm = FALSE)

bw.scott(x, na.rm = FALSE)
}
\arguments{
\item{x}{numeric matrix or data.frame.}

\item{na.rm}{a logical value indicating whether \code{NA} values should
be stripped before the computation proceeds.}
}
\description{
Rule of thumb bandwidth selectors for Gaussian kernels as described by
Scott (1992) and Silverman (1986).
}
\details{
Scott's (1992) rule is defined as

\deqn{
H = n^{-2/(m+4)} \hat\Sigma
}{
H = n^(-2/(m+4)) * S
}

Silverman's (1986; see Chacon, Duong and Wand, 2011) rule is defined as

\deqn{
H = \left(\frac{4}{n(m+2)}\right)^{2/(m+4)} \hat\Sigma
}{
H = (4/(n*(m+2)))^(2/(m+4)) * S
}

where \eqn{m} is number of variables, \eqn{n} is sample size, \eqn{\hat\Sigma}{S}
is the empirical covariance matrix. The bandwidth is returned as a \emph{covariance matrix},
so to use it for a product kernel, take square root of it's diagonal: \code{sqrt(diag(H))}.

\code{bw.silv} corresponds to \code{Hns} method with \code{deriv.order=0} from the
\pkg{ks} package.
}
\references{
Silverman, B.W. (1986). Density estimation for statistics and data analysis. Chapman and Hall/CRC.

Wand, M.P. and Jones, M.C. (1995). Kernel smoothing. Chapman and Hall/CRC.

Scott, D.W. (1992). Multivariate density estimation: theory, practice,
and visualization. John Wiley & Sons.

Chacon J.E., Duong, T. and Wand, M.P. (2011). Asymptotics for general multivariate kernel density
derivative estimators. Statistica Sinica, 21, 807-840.

Epanechnikov, V.A. (1969). Non-parametric estimation of a multivariate orobability density.
Theory of Probability & Its Applications, 14(1): 153-158.
}
\seealso{
\code{\link[stats]{bandwidth}}
}
