% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{summary.kernelshap}
\alias{summary.kernelshap}
\title{Summary Method}
\usage{
\method{summary}{kernelshap}(object, compact = FALSE, n = 2L, ...)
}
\arguments{
\item{object}{An object of class "kernelshap".}

\item{compact}{Set to \code{TRUE} to hide printing the top n SHAP values,
standard errors and feature values.}

\item{n}{Maximum number of rows of SHAP values, standard errors and feature values
to print.}

\item{...}{Further arguments passed from other methods.}
}
\value{
Invisibly, the input is returned.
}
\description{
Summary Method
}
\examples{
fit <- stats::lm(Sepal.Length ~ ., data = iris)
s <- kernelshap(fit, iris[1:3, -1], bg_X = iris[-1])
summary(s)
}
\seealso{
\code{\link[=kernelshap]{kernelshap()}}
}
