% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggplot2-tol.R
\name{scale_tol_sequential}
\alias{scale_tol_sequential}
\alias{scale_colour_YlOrBr}
\alias{scale_color_YlOrBr}
\alias{scale_fill_YlOrBr}
\alias{scale_colour_iridescent}
\alias{scale_color_iridescent}
\alias{scale_fill_iridescent}
\alias{scale_colour_discreterainbow}
\alias{scale_color_discreterainbow}
\alias{scale_fill_discreterainbow}
\alias{scale_colour_smoothrainbow}
\alias{scale_color_smoothrainbow}
\alias{scale_fill_smoothrainbow}
\title{Paul Tol's Sequential Colour Schemes for ggplot2}
\usage{
scale_colour_YlOrBr(..., reverse = FALSE, aesthetics = "colour")

scale_color_YlOrBr(..., reverse = FALSE, aesthetics = "colour")

scale_fill_YlOrBr(..., reverse = FALSE, aesthetics = "fill")

scale_colour_iridescent(..., reverse = FALSE, aesthetics = "colour")

scale_color_iridescent(..., reverse = FALSE, aesthetics = "colour")

scale_fill_iridescent(..., reverse = FALSE, aesthetics = "fill")

scale_colour_discreterainbow(..., reverse = FALSE,
  aesthetics = "colour")

scale_color_discreterainbow(..., reverse = FALSE,
  aesthetics = "colour")

scale_fill_discreterainbow(..., reverse = FALSE, aesthetics = "fill")

scale_colour_smoothrainbow(..., reverse = FALSE, aesthetics = "colour")

scale_color_smoothrainbow(..., reverse = FALSE, aesthetics = "colour")

scale_fill_smoothrainbow(..., reverse = FALSE, aesthetics = "fill")
}
\arguments{
\item{...}{Arguments passed to \code{\link[ggplot2]{continuous_scale}}.}

\item{reverse}{A \code{\link{logical}} scalar. Should the resulting
vector of colours be reversed?}

\item{aesthetics}{A \code{\link{character}} string or vector of character
strings listing the name(s) of the aesthetic(s) that this scale works with.}
}
\description{
Provides sequential colour scales from Paul Tol's \emph{Colour Schemes}.
}
\details{
The sequential colour schemes are linearly interpolated, with the exception
 of the \code{discrete rainbow} palette (see below).
 Note that the default colour for \code{NA} can be overridden by passing
 a value to \code{\link[ggplot2]{continuous_scale}}.

 \tabular{lll}{
  \strong{Palette} \tab \strong{Max. colours} \tab \strong{NA value} \cr
  YlOrBr \tab 9 \tab #888888 \cr
  iridescent \tab 23 \tab #999999 \cr
  discrete rainbow \tab 23 \tab #777777 \cr
  smooth rainbow \tab 34 \tab #666666 \cr
 }
}
\section{Rainbow colour scheme}{

 As a general rule, ordered data should not be represented using a rainbow
 scheme. There are three main arguments against such use (Tol 2018):
 \itemize{
  \item{The spectral order of visible light carries no inherent magnitude
  message.}
  \item{Some bands of almost constant hue with sharp transitions between
  them, can be perceived as jumps in the data.}
  \item{Colour-blind people have difficulty distinguishing some colours of
  the rainbow.}
 }
 If such use cannot be avoided, Paul Tol's technical note provides two colour
 schemes that are reasonably clear in colour-blind vision. To remain
 colour-blind safe, these two schemes must comply with the following
 conditions:
 \describe{
  \item{discrete rainbow}{This scheme must not be interpolated.}
  \item{smooth rainbow}{This scheme does not have to be used over the full
  range.}
 }
}

\examples{
library(ggplot2)

# Sequential data
ggplot(faithfuld, aes(waiting, eruptions, fill = density)) +
  geom_raster() +
  khroma::scale_fill_YlOrBr()

ggplot(faithfuld, aes(waiting, eruptions, fill = density)) +
  geom_raster() +
  khroma::scale_fill_iridescent()

ggplot(faithfuld, aes(waiting, eruptions, fill = density)) +
  geom_raster() +
  khroma::scale_fill_smoothrainbow(reverse = TRUE)
}
\references{
Tol, Paul (2018). \emph{Colour Schemes}. SRON. Technical Note No.
 SRON/EPS/TN/09-002. URL: \url{https://personal.sron.nl/~pault/data/colourschemes.pdf}
}
\seealso{
Other Paul Tol's colour schemes: \code{\link{scale_tol_discrete}},
  \code{\link{scale_tol_diverging}}
}
\author{
N. Frerebeau
}
\concept{Paul Tol's colour schemes}
