% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scale_colour_tol.R
\name{scale_tol_diverging}
\alias{scale_tol_diverging}
\title{Paul Tol's Diverging Color Schemes for \pkg{ggplot2} and \pkg{ggraph}}
\arguments{
\item{...}{Arguments passed to \code{\link[ggplot2:continuous_scale]{ggplot2::continuous_scale()}}.}

\item{reverse}{A \code{\link{logical}} scalar. Should the resulting
vector of colors be reversed?}

\item{range}{A length-two \code{\link{numeric}} vector specifying the
fraction of the scheme's color domain to keep.}

\item{midpoint}{A length-one \code{\link{numeric}} vector giving the midpoint
(in data value) of the diverging scale. Defaults to \code{0}.}

\item{discrete}{A \code{\link{logical}} scalar: should the color scheme be
used as a discrete scale? If \code{TRUE}, it is a departure from Paul Tol's
recommendations and likely a very poor use of color.}

\item{aesthetics}{A \code{\link{character}} string or vector of character
strings listing the name(s) of the aesthetic(s) that this scale works with.}
}
\value{
A \link[ggplot2:continuous_scale]{continuous} scale.
}
\description{
Provides diverging color scales from Paul Tol's \emph{Colour Schemes}.
}
\details{
\tabular{lll}{
\strong{Palette} \tab \strong{Max. colors} \tab \strong{NA value} \cr
\code{sunset} \tab 11 \tab #FFFFFF \cr
\code{BuRd} \tab 9 \tab #FFEE99 \cr
\code{PRGn} \tab 9 \tab #FFEE99 \cr
}
}
\section{Interpolation}{

If more colors than defined are needed from a given scheme, the color
coordinates are linearly interpolated to provide a continuous version of the
scheme.

Note that the default color for \code{NA} can be overridden by passing
a value to \code{\link[ggplot2:continuous_scale]{ggplot2::continuous_scale()}}.
}

\examples{
data(economics, package = "ggplot2")

ggplot2::ggplot(economics, ggplot2::aes(psavert, pce, colour = unemploy)) +
  ggplot2::geom_point() +
  scale_color_sunset(reverse = TRUE, midpoint = 12000)

ggplot2::ggplot(economics, ggplot2::aes(psavert, pce, colour = unemploy)) +
  ggplot2::geom_point() +
  scale_color_BuRd(midpoint = 9000)

ggplot2::ggplot(economics, ggplot2::aes(psavert, pce, colour = unemploy)) +
  ggplot2::geom_point() +
  scale_color_PRGn(midpoint = 9000, range = c(0.25, 1))
}
\references{
Tol, P. (2018). \emph{Colour Schemes}. SRON. Technical Note No.
SRON/EPS/TN/09-002, issue 3.1.
URL: \url{https://personal.sron.nl/~pault/data/colourschemes.pdf}
}
\seealso{
Other color-blind safe color schemes: 
\code{\link{scale_crameri_cyclic}},
\code{\link{scale_crameri_diverging}},
\code{\link{scale_crameri_mutlisequential}},
\code{\link{scale_crameri_sequential}},
\code{\link{scale_okabeito_discrete}},
\code{\link{scale_tol_discrete}},
\code{\link{scale_tol_sequential}}
}
\author{
N. Frerebeau
}
\concept{color-blind safe color schemes}
\keyword{internal}
