% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_map.R
\name{plot_map}
\alias{plot_map}
\title{Diagnostic Map}
\usage{
plot_map(x)
}
\arguments{
\item{x}{A \code{\link{character}} vector of colors.}
}
\description{
Produces a diagnostic map for a given color scheme.
}
\examples{
plot(colour("bright")(7))
plot(colour("smooth rainbow")(256))

## Plot colour schemes
plot_scheme(colour("bright")(7))
plot_scheme(colour("sunset")(11))
plot_scheme(colour("YlOrBr")(9))
plot_scheme(colour("discrete rainbow")(14))

## Plot diagnostic maps
plot_map(colour("bright")(7))
plot_map(colour("sunset")(11))
plot_map(colour("YlOrBr")(9))
plot_map(colour("discrete rainbow")(14))

## Plot diagnostic images
plot_tiles(colour("discrete rainbow")(14), n = 256)
plot_tiles(colour("discrete rainbow")(23), n = 256)
plot_tiles(colour("smooth rainbow")(256), n = 256)
}
\seealso{
Other diagnostic tools: 
\code{\link{compare}()},
\code{\link{convert}()},
\code{\link{plot.color_scheme}()},
\code{\link{plot_scheme_colourblind}()},
\code{\link{plot_scheme}()},
\code{\link{plot_tiles}()}
}
\author{
N. Frerebeau, V. Arel-Bundock
}
\concept{diagnostic tools}
