% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multiple_regression.R
\name{multiple_regression}
\alias{multiple_regression}
\title{Multiple regression}
\usage{
multiple_regression(
  data = NULL,
  formula = NULL,
  sigfigs = NULL,
  round_digits_after_decimal = NULL
)
}
\arguments{
\item{data}{a data object (a data frame or a data.table)}

\item{formula}{a formula object for the regression equation}

\item{sigfigs}{number of significant digits to round to}

\item{round_digits_after_decimal}{round to nth digit after decimal
(alternative to \code{sigfigs})}
}
\value{
the output will be a data.table showing multiple regression
results.
}
\description{
Conduct multiple regression analysis and summarize the results
in a data.table.
}
\details{
To include standardized beta(s) in the regression results table,
the following package(s) must be installed prior to running the function:
Package 'lm.beta' v1.5-1 (or possibly a higher version) by
Stefan Behrendt (2014),
\url{https://cran.r-project.org/package=lm.beta}
}
\examples{
multiple_regression(data = mtcars, formula = mpg ~ gear * cyl)
}
