% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chi_squared_test_pairwise.R
\name{chi_squared_test_pairwise}
\alias{chi_squared_test_pairwise}
\title{Chi-squared test, pairwise}
\usage{
chi_squared_test_pairwise(
  data = NULL,
  iv_name = NULL,
  dv_name = NULL,
  focal_dv_value = NULL,
  contingency_table = TRUE,
  contingency_table_sigfigs = 2,
  percent_and_total = FALSE,
  percentages_only = NULL,
  counts_only = NULL,
  sigfigs = 3,
  chi_sq_test_stats = FALSE,
  correct = TRUE
)
}
\arguments{
\item{data}{a data object (a data frame or a data.table)}

\item{iv_name}{name of the independent variable
(must be a categorical variable)}

\item{dv_name}{name of the dependent variable (must be a binary variable)}

\item{focal_dv_value}{focal value of the dependent variable
whose frequencies will be calculated (i.e., the value of the
dependent variable that will be considered a "success" or
a result of interest)}

\item{contingency_table}{If \code{contingency_table = TRUE} or
if \code{contingency_table = "percentages"}, the percentage of each
binary value within each group will be printed. If
\code{contingency_table = "counts"}, a table of frequencies will be
printed. If \code{contingency_table = FALSE}, no contingency table
will be printed.}

\item{contingency_table_sigfigs}{number of significant digits that
the contingency table's percentage values should be rounded to
(default = 2)}

\item{percent_and_total}{logical. If \code{percent_and_total = TRUE},
tabulate percentages of the focal DV value and a total count of
the two values in DV. By default \code{percent_and_total = FALSE}}

\item{percentages_only}{tabulate percentages of the focal DV value only}

\item{counts_only}{tabulate counts of the focal DV value only}

\item{sigfigs}{number of significant digits to round to}

\item{chi_sq_test_stats}{if \code{chi_sq_test_stats = TRUE},
chi-squared test statistic and degrees of freedom will be included
in the pairwise comparison data.table.}

\item{correct}{logical. Should continuity correction be applied?
(default = TRUE)}
}
\description{
Conducts a chi-squared test for every possible pairwise comparison
with Bonferroni correction
}
\examples{
chi_squared_test_pairwise(data = mtcars, iv_name = "vs", dv_name = "am")
chi_squared_test_pairwise(data = mtcars, iv_name = "vs", dv_name = "am",
percentages_only = TRUE)
# using 3 mtcars data sets combined
chi_squared_test_pairwise(
data = rbind(mtcars, rbind(mtcars, mtcars)),
iv_name = "cyl", dv_name = "am")
# include the total counts
chi_squared_test_pairwise(
data = rbind(mtcars, rbind(mtcars, mtcars)),
iv_name = "cyl", dv_name = "am", percent_and_total = TRUE)
# display counts
chi_squared_test_pairwise(
data = rbind(mtcars, rbind(mtcars, mtcars)),
iv_name = "cyl", dv_name = "am", contingency_table = "counts")
}
