% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kmeRs_similarity_matrix.R
\name{kmeRs_similarity_matrix}
\alias{kmeRs_similarity_matrix}
\title{Pairwise Similarity Matrix}
\usage{
kmeRs_similarity_matrix(kmers_given, compare_to = "",
  alignment_type = "global", k = 3, submat = "BLOSUM62",
  save_to_file = "")
}
\arguments{
\item{kmers_given}{vector with given k-mers}

\item{compare_to}{this parameter can have 3 different states, when:
'' - the \code{kmers_given} will be compared to each other, default value;
ALL -  the \code{kmers_given} will be compared to all possible combinations given by k parameter e.g. N= 4^6 = 4096 combinations for 6-mers;
3rd option is to provide a list of k-mers which should be compared with the set given by the \code{kmers_given} parameter}

\item{alignment_type}{type of alignment, default is 'global', could be 'local' or 'global', where 'global' represents
Needleman-Wunsch global alignment; 'local' represents Smith-Waterman local alignment.}

\item{k}{length of k-mers to calculate similarity matrix, higher values may slow down the computer, default value is k=3}

\item{submat}{substitution matrix, default is 'BLOSUM62', but could be one of 'BLOSUM45', 'BLOSUM50', 'BLOSUM62', 'BLOSUM80',
'BLOSUM100', 'PAM30', 'PAM40', 'PAM70', 'PAM120', 'PAM250'}

\item{save_to_file}{directory and file name; if value is declared the matrix will be saved to the given file name}
}
\value{
similarity matrix is returned as a data.frame
}
\description{
The \code{kmeRs_similarity_matrix} function generates a pairwise similarity score
matrix for for k length given k-mers vs. all possible k-mers combination.
The pairwise similarity score is calculated using PAM or BLOSUM substitution matrix;
30, 40, 70, 120, 250 and 62, 45, 50, 62, 80, 100 matrix versions are available for
PAM or BLOSUM, respectively. The results are evaluated by global similarity score;
higher similarity score indicates more similar sequences for BLOSUM and opposite for
PAM matrix.
}
\examples{
# Display BLOSUM matrix used for calculation

kmeRs_similarity_matrix(kmers_given = c("A", "T", "C", "G"), submat = "BLOSUM62")

}
