% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/switchcol_nfi.R
\name{switchcol_nfi}
\alias{switchcol_nfi}
\title{Switch column names}
\usage{
switchcol_nfi(data)
}
\arguments{
\item{data}{: A \code{list} generated by \code{\link{read_nfi}}.}
}
\value{
A \code{list} of dataframes with switched column names.
}
\description{
The \code{switchcol_nfi()} function allows switching between the original Korean column names and English column names.
If the input data has English column names, it changes them to the original Korean names, and vice versa.
}
\details{
Important: Data with original Korean column names cannot be used with any \code{\link{read_nfi}} functions except \code{colchange_nfi()} itself.
The option to revert to original Korean names is provided solely for users who wish to store or process the NFI data with original column names.
}
\examples{

data("nfi_donghae")

#Switch column names from English to original Korean names
nfi_donghae_kor <- switchcol_nfi(nfi_donghae)

# Switch column names from original Korean to English names
nfi_donghae_eng <- switchcol_nfi(nfi_donghae_kor)

}
