% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FixationFilterFunctions.R
\name{algorithm_ivt}
\alias{algorithm_ivt}
\title{I-VT algorithm for fixation and saccade detection}
\usage{
algorithm_ivt(
  gaze_raw,
  velocity.filter.ms = 20,
  velocity.threshold = 35,
  min.saccade.duration = 10,
  min.fixation.duration = 40,
  one_degree = 40,
  save.velocity.profiles = FALSE,
  xcol = "x.raw",
  ycol = "y.raw",
  distance.threshold = 0.7,
  merge.ms.threshold = 75,
  missing.samples.threshold = 0.5,
  trim.fixations = FALSE,
  trim.dispersion.threshold = NA
)
}
\arguments{
\item{gaze_raw}{Data frame with gaze data before fixation and saccade detection. Include the variable timestamp with timing in ms and columns with raw
x and y data as specified by the parameters xcol and ycol or their default values}

\item{velocity.filter.ms}{Window in milliseconds for moving average window used for smoothing the sample to sample velocity vector.}

\item{velocity.threshold}{Velocity threshold for saccade detection in degrees/second}

\item{min.saccade.duration}{Minimum duration of saccades in milliseconds}

\item{min.fixation.duration}{Minimum duration of fixations in milliseconds}

\item{one_degree}{One degree of the visual field in the unit of the raw x and y coordinates, typically pixels or proportion of the screen. Make sure that
it is consistent with the format of your data}

\item{save.velocity.profiles}{If TRUE, return velocity profiles of each detected saccade as a variable in the saccades data frame}

\item{xcol}{Name of the column where raw x values are stored. Default: x.raw}

\item{ycol}{Name of the column where raw y values are stored. Default: y.raw}

\item{distance.threshold}{Subsequent fixations occurring withing this distance are merged. Set to 0 if you don't want to merge fixations.}

\item{merge.ms.threshold}{Subsequent fixations occuring within this time window and distance specified by distance.threshold are merged.
Set to 0 if you don't want to merge fixations.}

\item{missing.samples.threshold}{Remove fixations with a higher proportion of missing samples. Range 0 to 1.}

\item{trim.fixations}{If TRUE, the onset of each fixation will be shifted forwards to the first non-missing (non-NA) sample during the period.
The offset will be shifted backwards to the last non-missing
sample. If TRUE, and the parameter trim.dispersion.threshold is a positive number, samples at the margins with large distances from the centroid
will also be excluded}

\item{trim.dispersion.threshold}{If not NA and trim.fixations is TRUE, fixation onsets and offsets will also be shrinked to exclude any samples
at the margins with a larger distance from the centroid than trim.dispersion.threshold*MAD.}
}
\value{
list including separate data frames for fixations and sample-by-sample data including x and y coordinates before and after fixation detection.
The fixations data frame gives onset, offset, x, y, sample-to-sample RMSD (precision),root-mean-square deviations from fixation centroid,  and missing samples of each fixation.
}
\description{
Apply an \code{I-VT} event detection algorithm to the eye tracking data.
The algorithm identifies saccades as periods with sample-to-sample velocity above a threshold and fixations as periods between saccades.
See Salvucci and Goldberg 2000. Identifying fixations and saccades in eye tracking protocols. Proc. 2000 symposium on Eye tracking
research and applications for a description.

Input data must be a data frame with the variables timestamp, x.raw and y.raw as variables. Other variables can
be included but will be ignored. This function does not perform pre-processing in the form of interpolation or smoothing. Use the function preprocess_gaze for this.
Timestamps are assumed to be in milliseconds. X and y coordinates can be in pixels or proportion of the screen
depending on the format of your data. Make sure that the parameter one_degree matches the unit of your data
The output data is a list with three data frames: fixations includes all detected fixations with coordinates, duration
and a number of other metrics, saccades includes data for saccades, filt.gaze is a sample-by-sample data frame with time stamps, and gaze coordinates before ("raw") and after fixation detection.
The function has a number of parameters for removing potentially invalid fixations and saccades. The parameter min.fixation.duration can be used to remove unlikely
short fixations. If the parameter missing.samples threshold is set to a value lower than 1, fixations with a higher proportion of missing raw samples are removed.
}
\examples{
ivt_data <- algorithm_ivt(sample.data.processed, velocity.threshold = 30,
min.fixation.duration = 40)
}
