% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AnalysisFunctions.R
\name{aoi_test}
\alias{aoi_test}
\title{Test whether a gaze coordinates are within or outside a rectangular or elliptical AOI.
The aois df must contain the variables x0, x1, y0 and y1. x0 is the minimum x value, y0 the minimum y value. x1 the maximum x value. y1 the maximum y value and
type where rect means that the AOI is a rectangle and circle that the AOI is a circle or ellipse
If a column called name is present, the output for each
AOI will be labelled accordingly. Otherwise, the output will be labelled according to the order of the AOI in the data frame.
The df 'gaze' must contain the variables onset, duration, x, and y.
Latency will be defined as the value in onset of the first detected gaze coordinate in the AOI Make sure
that the timestamps are correct!
The function can be used with gaze data either fixations, saccades, or single samples. Note that the output variables are not equally relevant for all types of
gaze data. For example, both total duration and latency are relevant in many analyses focusing on fixations, but total duration may be less relevant in analyses of
saccades.}
\usage{
aoi_test(gaze, aois, outside = FALSE)
}
\arguments{
\item{gaze}{data frame with each row representing a gaze coordinate from a fixation, saccade, or sample. Must include the variables x, y, duration, and onset. Onset zero should
typically be trial onset}

\item{aois}{data frame with AOIs.}

\item{outside}{If FALSE, summarize data within AOIs. If TRUE, summarize data outside AOIs.}
}
\value{
data frame with total duration, number of occurrences and latency to first detected gaze coordinates for each AOI. Data are in long format.
}
\description{
Test whether a gaze coordinates are within or outside a rectangular or elliptical AOI.
The aois df must contain the variables x0, x1, y0 and y1. x0 is the minimum x value, y0 the minimum y value. x1 the maximum x value. y1 the maximum y value and
type where rect means that the AOI is a rectangle and circle that the AOI is a circle or ellipse
If a column called name is present, the output for each
AOI will be labelled accordingly. Otherwise, the output will be labelled according to the order of the AOI in the data frame.
The df 'gaze' must contain the variables onset, duration, x, and y.
Latency will be defined as the value in onset of the first detected gaze coordinate in the AOI Make sure
that the timestamps are correct!
The function can be used with gaze data either fixations, saccades, or single samples. Note that the output variables are not equally relevant for all types of
gaze data. For example, both total duration and latency are relevant in many analyses focusing on fixations, but total duration may be less relevant in analyses of
saccades.
}
