% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/update.R
\name{update.krige}
\alias{update.krige}
\title{Update Model}
\usage{
\method{update}{krige}(object, n.iter, n.burnin = 0, combine = FALSE, ...)
}
\arguments{
\item{object}{An \code{krige} object from the \code{metropolis.krige} function.}

\item{n.iter}{Number of iterations for the update run.}

\item{n.burnin}{The number of burnin iterations. Defaults to 0.}

\item{combine}{Logical value indicate whether to combine the update run with 
original output.}

\item{\dots}{Additional arguments passed to \code{update} methods. Not supported for 
\code{krige} objects.}
}
\value{
An object of class \code{krige} that includes the output MCMC matrix
  of sampled values from the posterior distribution as well as the record of 
  function arguments, model frame, acceptance rates, and standing parameters.
}
\description{
Update the Markov chain associated with the \code{metropolis.krige} model
}
\details{
Since MCMC calculations typically need to run relatively long. This 
  function can continue the MCMC calculations by \code{metropolis.krige()}. 
  The parameters of the original model and the estimated results from the previous
  run are passed through the \code{krige} object. 
  
  As geospatial estimation can be computationally taxing, the users may want to 
    preserve more iterations of the posterior samples. The \code{combine} argument 
    can be used to indicate whether combine the updated run with previous results. 
    This includes both the posterior samples and acceptance rates.
}
\examples{
\dontrun{
# Summarize Data
summary(ContrivedData)

# Set seed
set.seed(1241060320)

M <- 100
#M<-10000

contrived.run <- metropolis.krige(y ~ x.1 + x.2, coords = c("s.1","s.2"), 
   data = ContrivedData, n.iter = M, range.tol = 0.05)
summary(contrived.run)

# Update run
contrived.run2 <- update(contrived.run, n.iter = M, combine = TRUE)

summary(contrived.run2)
#plot(contrived.run2)
}

}
