% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/kwb.hantush.R
\name{hantushDistancesBaseProps}
\alias{hantushDistancesBaseProps}
\title{Hantush distances & base properties: allows input of vector of x,y coordinates and
also a vector for one of the base properties}
\usage{
hantushDistancesBaseProps(x = seq(0, 200, 5), y = rep(0, length(x)),
  baseProps = baseProperties(time = 2^(0:6), infiltrationRate = 1, basinWidth
  = 10, basinLength = 50, horizConductivity = 10, iniHead = 10, specificYield =
  0.2), dbg = FALSE)
}
\arguments{
\item{x}{vector with distances from the center of the recharge basin in the x
direction (L), (Default: every 5 meter between 0-200m)}

\item{y}{vector with distances from the center of the recharge basin in the y
direction (L), (Default: 0 times length of x)}

\item{baseProps}{as retrieved by baseProperties(), but one property is allowed
to be a vector (e.g. infiltrationRate = c(1,2,4))}

\item{dbg}{If True additional debug messages are printed on screen}
}
\value{
List with sublists "dat" (x,y,head & WLincrease), "changedBaseProp.Name"
(name of base property with multiple values) and "baseProps" (complete base
parameterisation)
}
\description{
Hantush distances & base properties: allows input of vector of x,y coordinates and
also a vector for one of the base properties
}
\examples{
baseProps <- baseProperties( time = 2^(0:6),
                             infiltrationRate = 1,
                             basinWidth = 10,
                             basinLength = 50,
                             horizConductivity = 10,
                             iniHead = 10,
                             specificYield = 0.2,
                             numberTimeSteps = 15)
res <- hantushDistancesBaseProps(baseProps = baseProps)
cols <- length(unique(res$dat[[res$changedBaseProp.Name]]))
mainTxt <- sprintf("Changed baseProperty: \%s", res$changedBaseProp.Name)
xyplot(WLincrease ~ x,
       groups=res$dat[[res$changedBaseProp.Name]],
       data=res$dat,
       type="b",
       auto.key=list(columns=cols),
       main=mainTxt)
}
\seealso{
\code{\link{baseProperties}} for basic model properties
}

