% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kz.ft.R
\name{kz.rc2}
\alias{kz.rc2}
\title{Reconstruct 2D Wave Signals For Given Directions with KZFT}
\usage{
kz.rc2(ds, f, m, ...)
}
\arguments{
\item{ds}{Matrix for data of wave field. Missing values are allowed.}

\item{f}{Vector. Identified wave frequency.}

\item{m}{The window size for a regular Fourier transform}

\item{...}{Other arguments. 
\itemize{
 \item   \code{angle : } Vector. Identified wave direction value in degree. 
 \item    \code{k : } Integer, defaulting to 2. The iterations number of KZFT.
 \item    \code{n : }    The sampling frequency rate as a multiplication 
            of the Fourier frequencies
 \item    \code{p : } The distance between two successive intervals as 
            a percentage of the total length of the data series
 \item    \code{avg : } Logic. If average along orthogonal direction. 
            Default is TRUE if \code{angle} is available. 
 \item    \code{plot : } Logic. Flag for outputing figures. Default is FALSE. 
 \item    \code{edge : } Logic. Flag for keeping the edge data in the returned
               reconstructed signal. Default is FALSE. 
}}
}
\description{
Once you have identified the waves' directions and frequencies, 
   you can reconstruct the spatial wave singals with \code{kz.drc}.
Directional information is utilized to suppressive the nosie.
}
\details{
Averaging along the orthogonal direction of a wave signal will
significantly reduce the noise effects and increase the accuracy
of reconstruction. 

   When the direction information is not available, the 2D signal 
will be reconstructed along x-axis, but it will not be averaged
along the y-axis direction.
}
\examples{
dx <- 100			# The x and y scale of the wave field
dy <- 100			# Enlarge them to get better result.

b <- expand.grid(x=1:dx, y=dy:1)
q1 <- pi/6; f1 <- 0.1;
b$v1 <- sin(f1*2*pi*(b$x*cos(q1)+b$y*sin(q1))+runif(1))
a1 <- array(0,c(dx,dy))
a1[as.matrix(b[,1:2])] <- b$v1
q2 <- pi/3; f2 <- 0.15;
b$v2 <- sin(f2*2*pi*(b$x*cos(q2)+b$y*sin(q2))+runif(1))
a2 <- array(0,c(dx,dy))
a2[as.matrix(b[,1:2])] <- b$v2
a <- array(0,c(dx,dy))
a[as.matrix(b[,1:2])] <- b$v1 + 1.25*b$v2
noise <- matrix(rnorm(dx*dy,0,1),ncol=dy)

persp(1:(dx/2), 1:(dy/2), a1[1:(dx/2), 1:(dy/2)], zlab="",
	main="wave #1", theta=0, phi=45, ticktype="detailed", col="lightblue")
persp(1:(dx/2), 1:(dy/2), a2[1:(dx/2), 1:(dy/2)], 
	main="wave #2", theta=90, phi=-110, ticktype="detailed", col="lightblue")
persp(1:(dx/2), 1:(dy/2), a[1:(dx/2), 1:(dy/2)], 
	main="wave #1 + #2 ", theta=90, phi=-110, ticktype="detailed", col="lightblue")
persp(1:(dx/2), 1:(dy/2), a[1:(dx/2), 1:(dy/2)] + 5*noise[1:(dx/2), 1:(dy/2)], 
	main="wave #1 + #2 + 5*noise", theta=90, phi=-110, ticktype="detailed", col="lightblue")

image(x=1:dim(a1)[1] , y=1:dim(a1)[2], z=a1)
	box(); mtext("wave #1")
image(x=1:dim(a2)[1] , y=1:dim(a2)[2], z=a2) 
	box(); mtext("wave #2")
image(x=1:dim(a)[1] , y=1:dim(a)[2], z=a+0*noise)
	box(); mtext("wave #1 + #2 ")
image(x=1:dim(a)[1] , y=1:dim(a)[2], z=a+5*noise)
	box(); mtext("wave #1 + #2 + 5*noise")

rc0 <- kz.rc2(a+0*noise, f=c(0.1,0.05), m = 50)
cor(as.vector(a[1:dim(rc0)[1],1:dim(rc0)[2]]), as.vector(rc0), use="pairwise.complete.obs")

\dontrun{
# It may take a 10 ~ 30 seconds
# system.time(rc <- kz.rc2(a+5*noise, angle=c(30,60), f=c(0.1,0.15), m = 50))
# cor(as.vector(a[1:dim(rc)[1],1:dim(rc)[2]]), as.vector(rc), use="pairwise.complete.obs")
# image(x=1:dim(rc)[1] , y=1:dim(rc)[2], z=rc)
# box();mtext("Reconstruction")
# image(x=1:dim(rc)[1] , y=1:dim(rc)[2], z=rc-a[1:dim(rc)[1],1:dim(rc)[2]])
# box();mtext("Difference")
}

system.time(rc1 <- kz.rc2(a+5*noise, angle=30, f=0.1, m = 50))
cor(as.vector(a1[1:dim(rc1)[1],1:dim(rc1)[2]]), as.vector(rc1), use="pairwise.complete.obs")
image(x=1:dim(rc1)[1] , y=1:dim(rc1)[2], z=rc1); box();mtext("Reconstruction")

system.time(rc2 <- kz.rc2(a+5*noise, angle=60, f=0.05, m = 50))
cor(as.vector(a1[1:dim(rc1)[1],1:dim(rc1)[2]]), as.vector(rc1), use="pairwise.complete.obs")
image(x=1:dim(rc2)[1] , y=1:dim(rc2)[2], z=rc2); box()

}
\seealso{
\code{\link[kzft]{kzft}}, \code{\link{kz.smpg}}, \code{\link{kzp2}}
}
\concept{
Kolmogorov-Zurbenko Fourier Transform
}
\keyword{KZFT}
\keyword{reconstruction}

