% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/placegrainsfromlib.R
\name{placegrainsfromlib}
\alias{placegrainsfromlib}
\alias{meanarea.grainlib}
\alias{meansetcov.grainlib}
\alias{covar.grainlib}
\title{Place grains randomly on a point pattern}
\usage{
placegrainsfromlib(
  pp,
  grainlib,
  replace = TRUE,
  prob = NULL,
  w = NULL,
  xy = NULL
)

meanarea.grainlib(
  grainlib,
  weights = rep(1/length(grainlib), length(grainlib))
)

meansetcov.grainlib(
  grainlib,
  weights = rep(1/length(grainlib), length(grainlib)),
  xy
)

covar.grainlib(lambda, grainlib, weights, xy)
}
\arguments{
\item{pp}{A point pattern (in \code{ppp} format).}

\item{grainlib}{A list of grains as \code{owin} objects in a \code{\link[spatstat.geom]{solist}}.}

\item{replace}{passed directly to \code{\link[base]{sample}}. When TRUE grains are chosen from library with replacement.}

\item{prob}{A list of probability weights for each grain in the library. Passed directly to \code{\link[base]{sample}}.
If NULL the grains are selected with equal probability.}

\item{w}{Optional desired observation window. If this is non-null then any grains with Frame outside the Frame of \code{w} will be ignored.
This reduces polygonal intersection calculations for very large buffer distances}

\item{xy}{An \code{im} or binary mask object that is used to specify the pixel array of objects.}

\item{weights}{Probability of selecting each grain in the library}

\item{lambda}{Intensity of germs of a Boolean model - for computing the covariance of a Boolean model that has grain distribution given by \code{grainlib} and \code{weights}.}
}
\value{
Returns an \code{owin} object.
}
\description{
Places subsets (grains) of two dimension space randomly on a given point pattern.
This is useful for simulating germ-grain models such as Boolean models.
Also described here are functions for computing summary properties of the a list of grains.
}
\details{
Germ-grain models have two components, a point process (called germs) and a process that creates
grains that are centred on the germs.
The point process of germs can be easily simulated using a number of \pkg{spatstat} functions
(e.g. \code{\link[spatstat.core]{rpoispp}} for Boolean models).
To simulate a germ-grain model in a window \eqn{W} the germ process must be simulated in a larger window
because grains centred outside \eqn{W} can intersect \eqn{W}.
The result must then be cropped to \eqn{W} to achieve a realisation of the germ-grain process within \eqn{W}.

\code{placegrainsfromlib} randomly samples from a library of grains (\code{grainlib}) and places these on the points in \code{pp}.
Sampling of the grain is independent of the location of the point in \code{pp}.
It can be used to simulate the grain process in some germ-grain models.
}
\section{Functions}{
\itemize{
\item \code{placegrainsfromlib}: Place grains randomly from a list of grains.

\item \code{meanarea.grainlib}: Compute mean area of a random grain given by the library

\item \code{meansetcov.grainlib}: Computes the mean of the set covariance of the grains in \code{grainlib}.
\code{xy} is required because the set covariance function must rasterise the \code{owin} objects.

\item \code{covar.grainlib}: Compute the covariance of a Boolean model with random grain given by the library
}}

\examples{
# Simulate a germ-grain model where germs are a Poisson point process
# and grains are randomly selected from 3 different disc sizes.
grainlib <- solist(disc(radius = 1), disc(radius = 1.9), disc(radius = 0.2))
bufferdist <- 2 #chosen to be larger than the largest radius in library
w <- owin(xrange = c(0, 10), yrange = c(0, 10))

# Simulate the germ process in the window plus a buffer region around window
pp <- rpoispp(lambda = 0.1, win = dilation(w, bufferdist), nsim = 1, drop = TRUE)
xi_withbuffer <- placegrainsfromlib(pp, grainlib)

# Simulation of germ-grain model is the part within the window
xi <- intersect.owin(xi_withbuffer, w)

# Computation of properties from parameters 
lambda <- 0.1
discr <- 10
weights <- c(0.9999, 0.0001)
grainlib <- solist(disc(r = discr), disc(r = 2*discr))
meanarea.grainlib(grainlib, weights)
truecovar <- covar.grainlib(lambda, grainlib, weights, xy = as.mask(w, eps = 2))
}
\author{
Kassel Liam Hingee
}
\keyword{datagen}
\keyword{nonparametric}
\keyword{spatial}
