\name{arpt}
\alias{arpt}
\title{At-risk-of-poverty threshold}
\usage{
  arpt(inc, weights = NULL, sort = NULL, years = NULL,
    data = NULL, p = 0.6, na.rm = FALSE)
}
\arguments{
  \item{inc}{either a numeric vector giving the equivalized
  disposable income, or (if \code{data} is not \code{NULL})
  a character string, an integer or a logical vector
  specifying the corresponding column of \code{data}.}

  \item{weights}{optional; either a numeric vector giving
  the personal sample weights, or (if \code{data} is not
  \code{NULL}) a character string, an integer or a logical
  vector specifying the corresponding column of
  \code{data}.}

  \item{sort}{optional; either a numeric vector giving the
  personal IDs to be used as tie-breakers for sorting, or
  (if \code{data} is not \code{NULL}) a character string,
  an integer or a logical vector specifying the
  corresponding column of \code{data}.}

  \item{years}{optional; either a numeric vector giving the
  different years of the survey, or (if \code{data} is not
  \code{NULL}) a character string, an integer or a logical
  vector specifying the corresponding column of
  \code{data}.  If supplied, values are computed for each
  year.}

  \item{data}{an optional \code{data.frame}.}

  \item{p}{a numeric value in \eqn{[0,1]} giving the
  percentage of the weighted median to be used for the
  at-risk-of-poverty threshold.}

  \item{na.rm}{a logical indicating whether missing values
  should be removed.}
}
\value{
  A numeric vector containing the value(s) of the
  at-risk-of-poverty threshold is returned.
}
\description{
  Estimate the at-risk-of-poverty threshold.  The standard
  definition is to use 60\% of the weighted median
  equivalized disposable income.
}
\details{
  The implementation strictly follows the Eurostat
  definition.
}
\examples{
data(eusilc)
arpt("eqIncome", weights = "rb050", data = eusilc)
}
\author{
  Andreas Alfons
}
\references{
  Working group on Statistics on Income and Living
  Conditions (2004) Common cross-sectional EU indicators
  based on EU-SILC; the gender pay gap.  \emph{EU-SILC
  131-rev/04}, Eurostat.
}
\seealso{
  \code{\link{arpr}}, \code{\link{incMedian}},
  \code{\link{weightedMedian}}
}
\keyword{survey}

