% Generated by roxygen2 (4.0.1.99): do not edit by hand
\name{utils}
\alias{is.arpr}
\alias{is.gini}
\alias{is.gpg}
\alias{is.indicator}
\alias{is.prop}
\alias{is.qsr}
\alias{is.rmpg}
\alias{print.arpr}
\alias{print.indicator}
\alias{print.rmpg}
\alias{subset.arpr}
\alias{subset.indicator}
\alias{subset.rmpg}
\alias{utils}
\title{Utility functions for indicators on social exclusion and poverty}
\usage{
is.indicator(x)

is.arpr(x)

is.qsr(x)

is.rmpg(x)

is.gini(x)

is.prop(x)

is.gpg(x)

\method{print}{indicator}(x, ...)

\method{print}{arpr}(x, ...)

\method{print}{rmpg}(x, ...)

\method{subset}{indicator}(x, years = NULL, strata = NULL, ...)

\method{subset}{arpr}(x, years = NULL, strata = NULL, ...)

\method{subset}{rmpg}(x, years = NULL, strata = NULL, ...)
}
\arguments{
\item{x}{for \code{is.xyz}, any object to be tested.  The \code{print} and
\code{subset} methods are called by the generic functions if an object of the
respective class is supplied.}

\item{years}{an optional numeric vector giving the years to be extracted.}

\item{strata}{an optional vector giving the domains of the breakdown to be
extracted.}

\item{\dots}{additional arguments to be passed to and from methods.}
}
\value{
\code{is.indicator} returns \code{TRUE} if \code{x} inherits from
class \code{"indicator"} and \code{FALSE} otherwise.

\code{is.arpr} returns \code{TRUE} if \code{x} inherits from class
\code{"arpr"} and \code{FALSE} otherwise.

\code{is.qsr} returns \code{TRUE} if \code{x} inherits from class
\code{"qsr"} and \code{FALSE} otherwise.

\code{is.rmpg} returns \code{TRUE} if \code{x} inherits from class
\code{"rmpg"} and \code{FALSE} otherwise.

\code{is.gini} returns \code{TRUE} if \code{x} inherits from class
\code{"gini"} and \code{FALSE} otherwise.

\code{is.gini} returns \code{TRUE} if \code{x} inherits from class
\code{"gini"} and \code{FALSE} otherwise.

\code{print.indicator}, \code{print.arpr} and \code{print.rmpg} return
\code{x} invisibly.

\code{subset.indicator}, \code{subset.arpr} and \code{subset.rmpg} return a
subset of \code{x} of the same class.
}
\description{
Test for class, print and take subsets of indicators on social exclusion and
poverty.
}
\examples{
data(eusilc)

# at-risk-of-poverty rate
a <- arpr("eqIncome", weights = "rb050",
    breakdown = "db040", data = eusilc)
print(a)
is.arpr(a)
is.indicator(a)
subset(a, strata = c("Lower Austria", "Vienna"))

# quintile share ratio
q <- qsr("eqIncome", weights = "rb050",
    breakdown = "db040", data = eusilc)
print(q)
is.qsr(q)
is.indicator(q)
subset(q, strata = c("Lower Austria", "Vienna"))

# relative median at-risk-of-poverty gap
r <- rmpg("eqIncome", weights = "rb050",
    breakdown = "db040", data = eusilc)
print(r)
is.rmpg(r)
is.indicator(r)
subset(r, strata = c("Lower Austria", "Vienna"))

# Gini coefficient
g <- gini("eqIncome", weights = "rb050",
    breakdown = "db040", data = eusilc)
print(g)
is.gini(g)
is.indicator(g)
subset(g, strata = c("Lower Austria", "Vienna"))
}
\references{
A. Alfons and M. Templ (2013) Estimation of Social Exclusion Indicators
from Complex Surveys: The \R Package \pkg{laeken}.  \emph{Journal of
Statistical Software}, \bold{54}(15), 1--25.  URL
\url{http://www.jstatsoft.org/v54/i15/}
}
\seealso{
\code{\link{arpr}}, \code{\link{qsr}}, \code{\link{rmpg}},
\code{\link{gini}}, \code{\link{gpg}}
}
\keyword{survey}

