% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/thetaWML.R
\name{thetaWML}
\alias{thetaWML}
\title{Weighted maximum likelihood estimator}
\usage{
thetaWML(x, k = NULL, x0 = NULL, weight = c("residuals",
  "probability"), const, bias = TRUE, ...)
}
\arguments{
\item{x}{a numeric vector.}

\item{k}{the number of observations in the upper tail to which the Pareto
distribution is fitted.}

\item{x0}{the threshold (scale parameter) above which the Pareto distribution
is fitted.}

\item{weight}{a character string specifying the weight function to be used.
If \code{"residuals"} (the default), the weight function is based on
standardized residuals.  If \code{"probability"}, probability based weighting
is used.  Partial string matching allows these names to be abbreviated.}

\item{const}{Tuning constant(s) that control the robustness of the method.
If \code{weight="residuals"}, a single numeric value is required (the default
is 2.5).  If \code{weight="probability"}, a numeric vector of length two must
be supplied (a single numeric value is recycled; the default is 0.005 for
both tuning parameters).  See the references for more details.}

\item{bias}{a logical indicating whether bias correction should be applied.}

\item{\dots}{additional arguments to be passed to
\code{\link[stats]{uniroot}} (see \dQuote{Details}).}
}
\value{
The estimated shape parameter.
}
\description{
Estimate the shape parameter of a Pareto distribution using a weighted
maximum likelihood approach.
}
\details{
The arguments \code{k} and \code{x0} of course correspond with each other.
If \code{k} is supplied, the threshold \code{x0} is estimated with the \eqn{n
- k} largest value in \code{x}, where \eqn{n} is the number of observations.
On the other hand, if the threshold \code{x0} is supplied, \code{k} is given
by the number of observations in \code{x} larger than \code{x0}.  Therefore,
either \code{k} or \code{x0} needs to be supplied.  If both are supplied,
only \code{k} is used (mainly for back compatibility).

The weighted maximum likelihood estimator belongs to the class of
M-estimators.  In order to obtain the estimate, the root of a certain
function needs to be found, which is implemented using
\code{\link[stats]{uniroot}}.
}
\note{
The argument \code{x0} for the threshold (scale parameter) of the
Pareto distribution was introduced in version 0.2.
}
\examples{
data(eusilc)
# equivalized disposable income is equal for each household
# member, therefore only one household member is taken
eusilc <- eusilc[!duplicated(eusilc$db030),]

# estimate threshold
ts <- paretoScale(eusilc$eqIncome, w = eusilc$db090)

# using number of observations in tail
thetaWML(eusilc$eqIncome, k = ts$k)

# using threshold
thetaWML(eusilc$eqIncome, x0 = ts$x0)

}
\references{
Dupuis, D.J. and Morgenthaler, S. (2002) Robust weighted
likelihood estimators with an application to bivariate extreme value
problems. \emph{The Canadian Journal of Statistics}, \bold{30}(1), 17--36.

Dupuis, D.J. and Victoria-Feser, M.-P. (2006) A robust prediction error
criterion for Pareto modelling of upper tails. \emph{The Canadian Journal of
Statistics}, \bold{34}(4), 639--658.
}
\seealso{
\code{\link{paretoTail}}, \code{\link{fitPareto}}
}
\author{
Andreas Alfons and Josef Holzer
}
\keyword{manip}
