% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/start-listening.R
\name{classify_event}
\alias{classify_event}
\title{Classify an event based on how it is invoked}
\usage{
classify_event(event_content)
}
\arguments{
\item{event_content}{the content of the response received from querying the
text invocation endpoint, as a character}
}
\value{
character vector, the last element of which is always "event"
}
\description{
Events need to be handled differently depending on how the Lambda is invoked.
For example, an event via an API Gateway needs to be parsed and handled
differently to that of an event received via direct invocation. This function
attempts to detect the method of invocation and returns a character vector
which can be used to assign an S3 class to the event. The last element of
the vector is always "event".
}
\keyword{internal}
