% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RelatedRecords.R
\name{RelatedRecords}
\alias{RelatedRecords}
\title{RelatedRecords}
\description{
A container for accessing records with a one-to-many or many-to-many
relationship.
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-RelatedRecords-new}{\code{RelatedRecords$new()}}
\item \href{#method-RelatedRecords-df}{\code{RelatedRecords$df()}}
\item \href{#method-RelatedRecords-print}{\code{RelatedRecords$print()}}
\item \href{#method-RelatedRecords-to_string}{\code{RelatedRecords$to_string()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RelatedRecords-new"></a>}}
\if{latex}{\out{\hypertarget{method-RelatedRecords-new}{}}}
\subsection{Method \code{new()}}{
Creates an instance of this R6 class. This class should not be instantiated directly,
but rather by connecting to a LaminDB instance using the \code{\link[=connect]{connect()}} function.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RelatedRecords$new(instance, registry, field, related_to, api)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{instance}}{The instance the records list belongs to.}

\item{\code{registry}}{The registry the records list belongs to.}

\item{\code{field}}{The field associated with the records list.}

\item{\code{related_to}}{ID or UID of the parent that records are related to.}

\item{\code{api}}{The API for the instance.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RelatedRecords-df"></a>}}
\if{latex}{\out{\hypertarget{method-RelatedRecords-df}{}}}
\subsection{Method \code{df()}}{
Get a data frame summarising records in the registry
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RelatedRecords$df(limit = 100, verbose = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{limit}}{Maximum number of records to return}

\item{\code{verbose}}{Boolean, whether to print progress messages}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A data.frame containing the available records
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RelatedRecords-print"></a>}}
\if{latex}{\out{\hypertarget{method-RelatedRecords-print}{}}}
\subsection{Method \code{print()}}{
Print a \code{RelatedRecords}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RelatedRecords$print(style = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{style}}{Logical, whether the output is styled using ANSI codes}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RelatedRecords-to_string"></a>}}
\if{latex}{\out{\hypertarget{method-RelatedRecords-to_string}{}}}
\subsection{Method \code{to_string()}}{
Create a string representation of a \code{RelatedRecords}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RelatedRecords$to_string(style = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{style}}{Logical, whether the output is styled using ANSI codes}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A \code{cli::cli_ansi_string} if \code{style = TRUE} or a character vector
}
}
}
