% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/train.spLearner.R
\name{predict.spLearner}
\alias{predict.spLearner}
\title{Predict using spLearner at new locations}
\usage{
\method{predict}{spLearner}(
  object,
  predictionLocations,
  model.error = TRUE,
  error.type = c("quantreg", "weighted.sd", "interval")[1],
  t.prob = 1/3,
  w,
  quantiles = c((1 - 0.682)/2, 1 - (1 - 0.682)/2),
  ...
)
}
\arguments{
\item{object}{of type \code{spLearner}.}

\item{predictionLocations}{\code{SpatialPixelsDataFrame} with values of all features.}

\item{model.error}{Logical specify if prediction errors should be derived.}

\item{error.type}{Specify how should be the prediction error be derived.}

\item{t.prob}{Threshold probability for significant learners; only applyies for meta-learners based on lm model.}

\item{w}{optional weights vector.}

\item{quantiles}{list of quantiles for quantreg forest (maximum lower and upper quantile).}

\item{...}{optional parameters.}
}
\value{
Object of class \code{SpatialPixelsDataFrame} with predictions and model error.
}
\description{
Predict using spLearner at new locations
}
