% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_circumscribingcircle.R
\name{get_circumscribingcircle}
\alias{get_circumscribingcircle}
\alias{get_circumscribingcircle.RasterLayer}
\alias{get_circumscribingcircle.matrix}
\title{get_circumscribingcircle}
\usage{
get_circumscribingcircle(landscape, resolution)

\method{get_circumscribingcircle}{RasterLayer}(landscape, resolution)

\method{get_circumscribingcircle}{matrix}(landscape, resolution = NULL)
}
\arguments{
\item{landscape}{RasterLayer or matrix (with x,y,id columns)}

\item{resolution}{Resolution of the landscape (only needed if matrix as input is used)}
}
\description{
Calculates the diameter of the smallest circumscribing circle around patches in a landscape.
}
\details{
Fast and memory safe Rcpp implementation for calculating maximum euclidean distances between
cells of the same class in a raster or matrix. Uses the edge boundary of cells,
not the cell center. Using the edge boundary and the maximum distance between
the 4 cell corners around each cell center of the patch derives in the diameter of
the smallest circumscribing circle around a patch.

If one uses this functions with a matrix the resolution of the underlying data must be provided.#'
}
\examples{
# get patches for class 1 from testdata as raster
class_1 <- get_patches(landscape,1)[[1]]

# calculate the max distance between cell edges of each class
get_circumscribingcircle(class_1)

# do the same with a 3 column matrix (x,y,id)
class_1_matrix <- raster::rasterToPoints(class_1)
get_circumscribingcircle(class_1_matrix, 1)

}
\references{
Based on RCpp code of Florian Privé \email{florian.prive.21@gmail.com}
}
