% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lsm_l_circle_sd.R
\name{lsm_l_circle_sd}
\alias{lsm_l_circle_sd}
\alias{lsm_l_circle_sd.RasterLayer}
\alias{lsm_l_circle_sd.RasterStack}
\alias{lsm_l_circle_sd.RasterBrick}
\alias{lsm_l_circle_sd.list}
\title{CIRCLE_SD (landscape level)}
\usage{
lsm_l_circle_sd(landscape, directions)

\method{lsm_l_circle_sd}{RasterLayer}(landscape, directions = 8)

\method{lsm_l_circle_sd}{RasterStack}(landscape, directions = 8)

\method{lsm_l_circle_sd}{RasterBrick}(landscape, directions = 8)

\method{lsm_l_circle_sd}{list}(landscape, directions = 8)
}
\arguments{
\item{landscape}{Raster* Layer, Stack, Brick or a list of rasterLayers.}

\item{directions}{The number of directions in which patches should be
connected: 4 (rook's case) or 8 (queen's case).}
}
\value{
tibble
}
\description{
Standard deviation of related circumscribing circle (Shape metric)
}
\details{
\deqn{CIRCLE_{SD} = sd(CIRCLE[patch_{ij}])}
where \eqn{CIRCLE[patch_{ij}]} is the related circumscribing circle of each patch.

CIRCLE_SD is a 'Shape metric' and summarises the landscape as the standard deviation of
the related circumscribing circle of all patches in the landscape. CIRCLE describes
the ratio between the patch area and the smallest circumscribing circle of the patch
and characterises the compactness of the patch. The metric describes the differences
among all patches of the landscape.

\subsection{Units}{None}
\subsection{Range}{CIRCLE_SD >= 0}
\subsection{Behaviour}{Equals CIRCLE_SD if the related circumscribing circle is identical
for all patches. Increases, without limit, as the variation of related circumscribing
circles increases.}
}
\examples{
lsm_l_circle_sd(landscape)

}
\references{
McGarigal, K., SA Cushman, and E Ene. 2012. FRAGSTATS v4: Spatial Pattern Analysis
Program for Categorical and Continuous Maps. Computer software program produced by
the authors at the University of Massachusetts, Amherst. Available at the following
web site: http://www.umass.edu/landeco/research/fragstats/fragstats.html

Baker, W. L., and Y. Cai. 1992. The r.le programs for multiscale analysis of
landscape structure using the GRASS geographical information system.
Landscape Ecology 7: 291-302.
}
\seealso{
\code{\link{lsm_p_circle}},
\code{\link{mean}}, \cr
\code{\link{lsm_c_circle_mn}},
\code{\link{lsm_c_circle_sd}},
\code{\link{lsm_c_circle_cv}}, \cr
\code{\link{lsm_l_circle_mn}},
\code{\link{lsm_l_circle_cv}}
}
